/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.VaultPortalSize;
import iskallia.vault.block.entity.VaultPortalTileEntity;
import iskallia.vault.core.Version;
import iskallia.vault.core.event.CommonEvents;
import iskallia.vault.core.vault.EntityState;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.VaultFactory;
import iskallia.vault.core.vault.player.Listener;
import iskallia.vault.core.vault.player.Runner;
import iskallia.vault.core.world.storage.VirtualWorld;
import iskallia.vault.entity.entity.SpiritEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModGameRules;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.ServerVaults;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VaultPortalBlock
extends NetherPortalBlock
implements EntityBlock {
    public static final BlockBehaviour.StatePredicate FRAME = (state, reader, p) -> Arrays.stream(ModConfigs.VAULT_PORTAL.getValidFrameBlocks()).anyMatch(b -> b == state.m_60734_());
    public static final EnumProperty<Style> STYLE = EnumProperty.m_61587_((String)"style", Style.class);

    public VaultPortalBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50142_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54904_, (Comparable)Direction.Axis.X)).m_61124_(STYLE, (Comparable)((Object)Style.RAINBOW)));
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STYLE});
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
    }

    public void m_7892_(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        Vault vault;
        VaultPortalTileEntity portal;
        if (level.f_46443_) {
            return;
        }
        if (entity instanceof SpiritEntity) {
            SpiritEntity spirit = (SpiritEntity)entity;
            spirit.teleportOut();
            return;
        }
        if (!(entity instanceof Player) || entity.m_20159_() || !entity.m_6072_()) {
            return;
        }
        VoxelShape playerVoxel = Shapes.m_83064_((AABB)entity.m_142469_().m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_())));
        if (!Shapes.m_83157_((VoxelShape)playerVoxel, (VoxelShape)state.m_60808_((BlockGetter)level, pos), (BooleanOp)BooleanOp.f_82689_)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        BlockEntity te = level.m_7702_(pos);
        VaultPortalTileEntity vaultPortalTileEntity = portal = te instanceof VaultPortalTileEntity ? (VaultPortalTileEntity)te : null;
        if (player.m_20092_()) {
            player.m_20091_();
            return;
        }
        if (ServerVaults.get(level).isPresent()) {
            CommonEvents.VAULT_PORTAL_COLLIDE.invoke((ServerLevel)level, state, pos, player);
            return;
        }
        UUID vaultId = portal.getData().getVaultId();
        if (vaultId == null) {
            vault = ServerVaults.add(VaultFactory.create(Version.latest(), portal.getData().copy(), level.m_46469_().m_46207_(ModGameRules.CASUAL_VAULTS)));
            this.fill(level, pos, tileEntity -> {
                tileEntity.getData().setVaultId(vault.get(Vault.ID));
                tileEntity.m_6596_();
            }, new HashSet<BlockPos>());
        } else {
            vault = ServerVaults.get(vaultId).orElse(null);
        }
        VirtualWorld world = ServerVaults.getWorld(vault).orElse(null);
        if (world != null && vault != null) {
            vault.ifPresent(Vault.LISTENERS, listeners -> listeners.add(world, vault, (Listener)((Listener)new Runner().set(Runner.JOIN_STATE, new EntityState(player))).set(Runner.ID, player.m_142081_())));
        }
    }

    public void fill(Level world, BlockPos pos, Consumer<VaultPortalTileEntity> action, Set<BlockPos> traversed) {
        action.accept((VaultPortalTileEntity)world.m_7702_(pos));
        traversed.add(pos);
        for (Direction offset : Direction.values()) {
            BlockPos next = pos.m_142300_(offset);
            if (traversed.contains(next) || !(world.m_7702_(next) instanceof VaultPortalTileEntity)) continue;
            this.fill(world, pos.m_142300_(offset), action, traversed);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor iWorld, BlockPos currentPos, BlockPos facingPos) {
        if (!(iWorld instanceof ServerLevel)) {
            return state;
        }
        ServerLevel sLevel = (ServerLevel)iWorld;
        if (!ServerVaults.isVaultWorld((Level)sLevel)) {
            Direction.Axis facingAxis = facing.m_122434_();
            Direction.Axis portalAxis = (Direction.Axis)state.m_61143_((Property)f_54904_);
            boolean flag = portalAxis != facingAxis && facingAxis.m_122479_();
            return !flag && !facingState.m_60713_((Block)this) && !new VaultPortalSize((LevelAccessor)sLevel, currentPos, portalAxis, FRAME).validatePortal() ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, (LevelAccessor)sLevel, currentPos, facingPos);
        }
        return state;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.VAULT_PORTAL_TILE_ENTITY.m_155264_(pPos, pState);
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level level, BlockState state, BlockEntityType<A> tBlockEntityType) {
        return BlockHelper.getTicker(tBlockEntityType, ModBlocks.VAULT_PORTAL_TILE_ENTITY, VaultPortalTileEntity::tick);
    }

    public static enum Style implements StringRepresentable
    {
        RAINBOW,
        FINAL,
        VELARA,
        TENOS,
        WENDARR,
        IDONA;


        public String m_7912_() {
            return this.name().toLowerCase();
        }
    }
}

