/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.VaultChestTileEntity;
import iskallia.vault.core.vault.stat.VaultChestType;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.util.BlockHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.Nullable;

public class VaultChestBlock
extends ChestBlock {
    private final VaultChestType type;

    protected VaultChestBlock(VaultChestType type, BlockBehaviour.Properties builder, Supplier<BlockEntityType<? extends ChestBlockEntity>> tileSupplier) {
        super(builder, tileSupplier);
        this.type = type;
    }

    public VaultChestBlock(VaultChestType type, BlockBehaviour.Properties builder) {
        this(type, builder, () -> ModBlocks.VAULT_CHEST_TILE_ENTITY);
    }

    public VaultChestType getType() {
        return this.type;
    }

    @javax.annotation.Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level pLevel, BlockState state, BlockEntityType<A> tBlockEntityType) {
        return BlockHelper.getTicker(tBlockEntityType, ModBlocks.VAULT_CHEST_TILE_ENTITY, pLevel.f_46443_ ? VaultChestTileEntity::tick : null);
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        VaultChestTileEntity chest;
        block6: {
            block5: {
                BlockEntity te = world.m_7702_(pos);
                if (!(te instanceof VaultChestTileEntity)) break block5;
                chest = (VaultChestTileEntity)te;
                if (!player.m_7500_()) break block6;
            }
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        if (this != ModBlocks.GILDED_CHEST && this != ModBlocks.LIVING_CHEST && this != ModBlocks.ORNATE_CHEST) {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        if (chest.m_7983_()) {
            return super.onDestroyedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        this.m_5707_(world, pos, state, player);
        return true;
    }

    public void m_6240_(Level world, Player player, BlockPos pos, BlockState state, @javax.annotation.Nullable BlockEntity te, ItemStack stack) {
        if (this != ModBlocks.GILDED_CHEST && this != ModBlocks.LIVING_CHEST && this != ModBlocks.ORNATE_CHEST) {
            super.m_6240_(world, player, pos, state, te, stack);
            return;
        }
        player.m_36246_(Stats.f_12949_.m_12902_((Object)this));
        player.m_36399_(0.005f);
        if (te instanceof VaultChestTileEntity) {
            VaultChestTileEntity chest = (VaultChestTileEntity)te;
            for (int slot = 0; slot < chest.m_6643_(); ++slot) {
                ItemStack invStack = chest.m_8020_(slot);
                if (invStack.m_41619_()) continue;
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)invStack);
                chest.m_6836_(slot, ItemStack.f_41583_);
                break;
            }
        }
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new VaultChestTileEntity(pPos, pState);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = super.m_5573_(context);
        return state == null ? null : (BlockState)state.m_61124_((Property)f_51479_, (Comparable)ChestType.SINGLE);
    }

    @Nullable
    public MenuProvider m_7246_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity;
        if ((state.m_60734_() == ModBlocks.ALTAR_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.GILDED_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.LIVING_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.ORNATE_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.TREASURE_CHEST_PLACEABLE || state.m_60734_() == ModBlocks.WOODEN_CHEST_PLACEABLE) && (blockEntity = level.m_7702_(pos)) instanceof VaultChestTileEntity) {
            final VaultChestTileEntity te = (VaultChestTileEntity)blockEntity;
            return new MenuProvider(){

                public Component m_5446_() {
                    return te.m_5446_();
                }

                @javax.annotation.Nullable
                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    if (te.m_7525_(player)) {
                        switch (te.m_6643_()) {
                            case 36: {
                                return new ChestMenu(MenuType.f_39960_, containerId, playerInventory, (Container)te, 4);
                            }
                            case 45: {
                                return new ChestMenu(MenuType.f_39961_, containerId, playerInventory, (Container)te, 5);
                            }
                            case 54: {
                                return new ChestMenu(MenuType.f_39962_, containerId, playerInventory, (Container)te, 6);
                            }
                        }
                        return new ChestMenu(MenuType.f_39959_, containerId, playerInventory, (Container)te, 3);
                    }
                    return null;
                }
            };
        }
        if (this == ModBlocks.TREASURE_CHEST && (blockEntity = level.m_7702_(pos)) instanceof ChestBlockEntity) {
            final ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            return new MenuProvider(){

                public Component m_5446_() {
                    return chest.m_5446_();
                }

                @javax.annotation.Nullable
                public AbstractContainerMenu m_7208_(int containerId, Inventory playerInventory, Player player) {
                    if (chest.m_7525_(player)) {
                        chest.m_59640_(player);
                        return ChestMenu.m_39246_((int)containerId, (Inventory)playerInventory, (Container)chest);
                    }
                    return null;
                }
            };
        }
        return super.m_7246_(state, level, pos);
    }
}

