/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.altar.AltarInfusionRecipe;
import iskallia.vault.block.entity.VaultAltarTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.world.data.PlayerVaultAltarData;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class VaultAltarBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public VaultAltarBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76278_, (MaterialColor)MaterialColor.f_76367_).m_60999_().m_60913_(3.0f, 3600000.0f).m_60955_());
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.FALSE));
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level p_153212_, BlockState state, BlockEntityType<A> tBlockEntityType) {
        return BlockHelper.getTicker(tBlockEntityType, ModBlocks.VAULT_ALTAR_TILE_ENTITY, VaultAltarTileEntity::tick);
    }

    @javax.annotation.Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.FALSE);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    public void m_7100_(@Nonnull BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        BlockEntity tileEntity = world.m_7702_(pos);
        if (!(tileEntity instanceof VaultAltarTileEntity)) {
            return;
        }
        VaultAltarTileEntity altarTileEntity = (VaultAltarTileEntity)tileEntity;
        AltarInfusionRecipe recipe = altarTileEntity.getRecipe();
        if (recipe == null || !recipe.isPogInfused()) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.m_123341_() + rand.nextDouble();
            double d1 = (double)pos.m_123342_() + rand.nextDouble();
            double d2 = (double)pos.m_123343_() + rand.nextDouble();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (!world.m_8055_(pos.m_142125_()).m_60713_((Block)this) && !world.m_8055_(pos.m_142126_()).m_60713_((Block)this)) {
                d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            world.m_7106_((ParticleOptions)ParticleTypes.f_123771_, d0, d1, d2, d3, d4, d5);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.VAULT_ALTAR_TILE_ENTITY.m_155264_(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (world.f_46443_ || handIn != InteractionHand.MAIN_HAND || !(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21205_();
        VaultAltarTileEntity altar = this.getAltarTileEntity(world, pos);
        if (altar == null) {
            return InteractionResult.SUCCESS;
        }
        if (altar.getAltarState() == VaultAltarTileEntity.AltarState.IDLE) {
            if (heldItem.m_41720_() == ModItems.VAULT_ROCK) {
                return altar.onAddVaultRock((ServerPlayer)player, heldItem);
            }
            return InteractionResult.SUCCESS;
        }
        if (altar.getAltarState() == VaultAltarTileEntity.AltarState.ACCEPTING) {
            // empty if block
        }
        if (player.m_6144_() && (altar.getAltarState() == VaultAltarTileEntity.AltarState.ACCEPTING || altar.getAltarState() == VaultAltarTileEntity.AltarState.COMPLETE)) {
            InteractionResult result = altar.getRecipe() != null && altar.getRecipe().isPogInfused() ? altar.onRemovePogInfusion() : altar.onRemoveVaultRock();
            PlayerVaultAltarData.get((ServerLevel)world).m_77762_();
            return result;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        VaultAltarTileEntity altar;
        if (worldIn.f_46443_) {
            return;
        }
        boolean powered = worldIn.m_46753_(pos);
        if (powered != (Boolean)state.m_61143_((Property)POWERED) && powered && (altar = this.getAltarTileEntity(worldIn, pos)) != null) {
            altar.onAltarPowered();
        }
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 3);
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @javax.annotation.Nullable Direction side) {
        return true;
    }

    private VaultAltarTileEntity getAltarTileEntity(Level worldIn, BlockPos pos) {
        BlockEntity te = worldIn.m_7702_(pos);
        if (!(te instanceof VaultAltarTileEntity)) {
            return null;
        }
        VaultAltarTileEntity tile = (VaultAltarTileEntity)te;
        return tile;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        ItemEntity entity;
        VaultAltarTileEntity altar = this.getAltarTileEntity(world, pos);
        if (altar == null) {
            return;
        }
        if (newState.m_60734_() != Blocks.f_50016_) {
            return;
        }
        if (altar.getAltarState() == VaultAltarTileEntity.AltarState.ACCEPTING || altar.getAltarState() == VaultAltarTileEntity.AltarState.COMPLETE) {
            entity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModItems.VAULT_ROCK));
            world.m_7967_((Entity)entity);
        }
        entity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.2, (double)pos.m_123343_() + 0.5, new ItemStack((ItemLike)ModBlocks.VAULT_ALTAR));
        world.m_7967_((Entity)entity);
        PlayerVaultAltarData.get((ServerLevel)world).removeAltar(altar.getOwner(), pos);
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity placer, ItemStack stack) {
        if (worldIn.f_46443_) {
            return;
        }
        VaultAltarTileEntity altar = (VaultAltarTileEntity)worldIn.m_7702_(pos);
        if (altar == null || !(placer instanceof Player)) {
            return;
        }
        altar.setOwner(placer.m_142081_());
        altar.setAltarState(VaultAltarTileEntity.AltarState.IDLE);
        altar.sendUpdates();
        PlayerVaultAltarData.get((ServerLevel)worldIn).addAltar(placer.m_142081_(), pos);
        super.m_6402_(worldIn, pos, state, placer, stack);
    }
}

