/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.FillableAltarBlock;
import iskallia.vault.block.entity.TimeAltarTileEntity;
import iskallia.vault.core.vault.Vault;
import iskallia.vault.core.vault.time.modifier.TimeAltarExtension;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModParticles;
import iskallia.vault.world.data.PlayerFavourData;
import iskallia.vault.world.data.ServerVaults;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TimeAltarBlock
extends FillableAltarBlock<TimeAltarTileEntity> {
    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.TIME_ALTAR_TILE_ENTITY.m_155264_(pPos, pState);
    }

    @Override
    public ParticleOptions getFlameParticle() {
        return (ParticleOptions)ModParticles.YELLOW_FLAME.get();
    }

    @Override
    public PlayerFavourData.VaultGodType getAssociatedVaultGod() {
        return PlayerFavourData.VaultGodType.TIMEKEEPER;
    }

    @Override
    public ItemStack getAssociatedVaultGodShard() {
        return new ItemStack((ItemLike)ModItems.CRYSTAL_SHARD_TIMEKEEPER);
    }

    @Override
    public InteractionResult rightClicked(BlockState state, ServerLevel world, BlockPos pos, TimeAltarTileEntity tileEntity, ServerPlayer player, ItemStack heldStack) {
        if (!tileEntity.initialized()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_7500_()) {
            tileEntity.makeProgress(player, 1, sPlayer -> {});
            return InteractionResult.SUCCESS;
        }
        tileEntity.makeProgress(player, 1, sPlayer -> {
            PlayerFavourData.VaultGodType vg;
            PlayerFavourData data = PlayerFavourData.get(sPlayer.m_183503_());
            if (rand.nextFloat() < TimeAltarBlock.getFavourChance((Player)sPlayer, PlayerFavourData.VaultGodType.TIMEKEEPER) && data.addFavour((Player)sPlayer, vg = this.getAssociatedVaultGod(), 1)) {
                data.addFavour((Player)sPlayer, vg.getOther(rand), -1);
                FillableAltarBlock.playFavourInfo(sPlayer);
            }
        });
        ServerVaults.get((Level)world).ifPresent(vault -> vault.ifPresent(Vault.CLOCK, clock -> clock.addModifier(new TimeAltarExtension((Player)player, 1200))));
        return InteractionResult.SUCCESS;
    }
}

