/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.VaultMod;
import iskallia.vault.block.VaultPortalSize;
import iskallia.vault.block.entity.OtherSidePortalTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.item.BurntCrystalItem;
import iskallia.vault.item.OtherSideData;
import iskallia.vault.world.vault.VaultUtils;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class OtherSidePortalBlock
extends NetherPortalBlock
implements EntityBlock {
    public static final BlockBehaviour.StatePredicate FRAME = (state, reader, p) -> Arrays.stream(ModConfigs.OTHER_SIDE.getValidFrameBlocks()).anyMatch(b -> b == state.m_60734_());

    public OtherSidePortalBlock() {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50142_));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54904_, (Comparable)Direction.Axis.X));
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return ModBlocks.OTHER_SIDE_PORTAL_TILE_ENTITY.m_155264_(pPos, pState);
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
    }

    public void m_7892_(BlockState state, Level world, BlockPos pos, Entity entity) {
        OtherSidePortalTileEntity portal;
        if (world.f_46443_ || !(entity instanceof Player)) {
            return;
        }
        if (entity.m_20159_() || entity.m_20160_() || !entity.m_6072_()) {
            return;
        }
        VoxelShape playerVoxel = Shapes.m_83064_((AABB)entity.m_142469_().m_82386_((double)(-pos.m_123341_()), (double)(-pos.m_123342_()), (double)(-pos.m_123343_())));
        if (!Shapes.m_83157_((VoxelShape)playerVoxel, (VoxelShape)state.m_60808_((BlockGetter)world, pos), (BooleanOp)BooleanOp.f_82689_)) {
            return;
        }
        VaultPortalSize current = new VaultPortalSize((LevelAccessor)world, pos, (Direction.Axis)state.m_61143_((Property)f_54904_), FRAME);
        if (!current.validatePortal()) {
            return;
        }
        ResourceKey<Level> destinationKey = world.m_46472_() == VaultMod.OTHER_SIDE_KEY ? Level.f_46428_ : VaultMod.OTHER_SIDE_KEY;
        ServerLevel destination = ((ServerLevel)world).m_142572_().m_129880_(destinationKey);
        if (destination == null) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (player.m_20092_()) {
            player.m_20091_();
            return;
        }
        BlockEntity te = world.m_7702_(pos);
        OtherSidePortalTileEntity otherSidePortalTileEntity = portal = te instanceof OtherSidePortalTileEntity ? (OtherSidePortalTileEntity)te : null;
        if (portal == null) {
            return;
        }
        OtherSideData data = portal.getData();
        if (data == null) {
            return;
        }
        BlockPos targetPos = data.getLinkedPos();
        ResourceKey<Level> targetDim = data.getLinkedDim();
        if (targetPos == null || targetDim == null) {
            return;
        }
        ServerLevel target = world.m_142572_().m_129880_(targetDim);
        if (target == null) {
            return;
        }
        if (target.m_8055_(targetPos).m_60734_() != ModBlocks.OTHER_SIDE_PORTAL) {
            targetPos = BurntCrystalItem.forcePlace((ServerLevel)world, current.getBottomLeft(), target, current);
            data.setLinkedPos(targetPos);
        }
        VaultUtils.moveTo(target, (Entity)player, new Vec3((double)targetPos.m_123341_() + 0.2, (double)targetPos.m_123342_(), (double)targetPos.m_123343_() + 0.2), null);
        player.m_20091_();
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor iworld, BlockPos currentPos, BlockPos facingPos) {
        if (!(iworld instanceof ServerLevel)) {
            return state;
        }
        Direction.Axis facingAxis = facing.m_122434_();
        Direction.Axis portalAxis = (Direction.Axis)state.m_61143_((Property)f_54904_);
        boolean flag = portalAxis != facingAxis && facingAxis.m_122479_();
        return !flag && !facingState.m_60713_((Block)this) && !new VaultPortalSize(iworld, currentPos, portalAxis, FRAME).validatePortal() ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, facing, facingState, iworld, currentPos, facingPos);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random rand) {
        for (int i = 0; i < 4; ++i) {
            double d0 = (double)pos.m_123341_() + rand.nextDouble();
            double d1 = (double)pos.m_123342_() + rand.nextDouble();
            double d2 = (double)pos.m_123343_() + rand.nextDouble();
            double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
            double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
            int j = rand.nextInt(2) * 2 - 1;
            if (!world.m_8055_(pos.m_142125_()).m_60713_((Block)this) && !world.m_8055_(pos.m_142126_()).m_60713_((Block)this)) {
                d0 = (double)pos.m_123341_() + 0.5 + 0.25 * (double)j;
                d3 = rand.nextFloat() * 2.0f * (float)j;
            } else {
                d2 = (double)pos.m_123343_() + 0.5 + 0.25 * (double)j;
                d5 = rand.nextFloat() * 2.0f * (float)j;
            }
            world.m_7106_((ParticleOptions)ParticleTypes.f_123790_, d0, d1, d2, d3, d4, d5);
        }
    }
}

