/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.FinalVaultFrameTileEntity;
import iskallia.vault.init.ModBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class FinalVaultFrameBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public FinalVaultFrameBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60918_(SoundType.f_56742_).m_60913_(2.0f, 3600000.0f).m_60955_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    @SubscribeEvent
    public static void onBlockHit(PlayerInteractEvent.LeftClickBlock event) {
        if (!event.isCancelable()) {
            return;
        }
        Player player = event.getPlayer();
        if (player.m_7500_()) {
            return;
        }
        FinalVaultFrameTileEntity tileEntity = FinalVaultFrameTileEntity.get((BlockGetter)player.f_19853_, event.getPos());
        if (tileEntity == null) {
            return;
        }
        if (!tileEntity.getOwnerUUID().equals(player.m_142081_())) {
            event.setCanceled(true);
        }
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        ItemStack itemStack = new ItemStack((ItemLike)this);
        FinalVaultFrameTileEntity tileEntity = FinalVaultFrameTileEntity.get(level, pos);
        CompoundTag entityNBT = new CompoundTag();
        if (tileEntity != null) {
            tileEntity.writeToEntityTag(entityNBT);
        }
        itemStack.m_41784_().m_128365_("BlockEntityTag", (Tag)entityNBT);
        return itemStack;
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        if (world.m_5776_()) {
            return;
        }
        CompoundTag tag = stack.m_41737_("BlockEntityTag");
        if (tag == null) {
            return;
        }
        FinalVaultFrameTileEntity tileEntity = FinalVaultFrameTileEntity.get((BlockGetter)world, pos);
        if (tileEntity == null) {
            return;
        }
        tileEntity.loadFromNBT(tag);
        super.m_6402_(world, pos, state, placer, stack);
    }

    public void m_5707_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull Player player) {
        FinalVaultFrameTileEntity tileEntity;
        if (!world.f_46443_ && !player.m_7500_() && (tileEntity = FinalVaultFrameTileEntity.get((BlockGetter)world, pos)) != null) {
            ItemStack itemStack = new ItemStack((ItemLike)this);
            CompoundTag entityNBT = new CompoundTag();
            tileEntity.writeToEntityTag(entityNBT);
            itemStack.m_41784_().m_128365_("BlockEntityTag", (Tag)entityNBT);
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        }
        super.m_5707_(world, pos, state, player);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.FINAL_VAULT_FRAME_TILE_ENTITY.m_155264_(pos, state);
    }
}

