/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.VaultMod;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModConfigs;
import iskallia.vault.init.ModItems;
import iskallia.vault.item.crystal.CrystalData;
import iskallia.vault.item.crystal.theme.ValueCrystalTheme;
import iskallia.vault.world.data.PlayerVaultStatsData;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrystalClusterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    protected final VoxelShape northAabb;
    protected final VoxelShape southAabb;
    protected final VoxelShape eastAabb;
    protected final VoxelShape westAabb;
    protected final VoxelShape upAabb;
    protected final VoxelShape downAabb;

    public CrystalClusterBlock(SoundType soundType, int lightLevel, int height, double width) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_164531_).m_60955_().m_60977_().m_60918_(soundType).m_60978_(1.5f).m_60953_(value -> lightLevel));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.UP));
        this.upAabb = Block.m_49796_((double)width, (double)0.0, (double)width, (double)(16.0 - width), (double)height, (double)(16.0 - width));
        this.downAabb = Block.m_49796_((double)width, (double)(16 - height), (double)width, (double)(16.0 - width), (double)16.0, (double)(16.0 - width));
        this.northAabb = Block.m_49796_((double)width, (double)width, (double)(16 - height), (double)(16.0 - width), (double)(16.0 - width), (double)16.0);
        this.southAabb = Block.m_49796_((double)width, (double)width, (double)0.0, (double)(16.0 - width), (double)(16.0 - width), (double)height);
        this.eastAabb = Block.m_49796_((double)0.0, (double)width, (double)width, (double)height, (double)(16.0 - width), (double)(16.0 - width));
        this.westAabb = Block.m_49796_((double)(16 - height), (double)width, (double)width, (double)16.0, (double)(16.0 - width), (double)(16.0 - width));
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> this.northAabb;
            case Direction.SOUTH -> this.southAabb;
            case Direction.EAST -> this.eastAabb;
            case Direction.WEST -> this.westAabb;
            case Direction.DOWN -> this.downAabb;
            case Direction.UP -> this.upAabb;
        };
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        Direction direction = (Direction)blockState.m_61143_((Property)FACING);
        BlockPos relativeBlockPos = blockPos.m_142300_(direction.m_122424_());
        return levelReader.m_8055_(relativeBlockPos).m_60783_((BlockGetter)levelReader, relativeBlockPos, direction);
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState neighborState, LevelAccessor levelAccessor, BlockPos currentBlockPos, BlockPos neighborBlockPos) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(currentBlockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return direction == ((Direction)blockState.m_61143_((Property)FACING)).m_122424_() && !blockState.m_60710_((LevelReader)levelAccessor, currentBlockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, neighborState, levelAccessor, currentBlockPos, neighborBlockPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(blockPlaceContext.m_43725_().m_6425_(blockPlaceContext.m_8083_()).m_76152_() == Fluids.f_76193_))).m_61124_((Property)FACING, (Comparable)blockPlaceContext.m_43719_());
    }

    @Nonnull
    public BlockState m_6843_(BlockState blockState, Rotation rotation) {
        return (BlockState)blockState.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)blockState.m_61143_((Property)FACING)));
    }

    @Nonnull
    public BlockState m_6943_(BlockState blockState, Mirror mirror) {
        return blockState.m_60717_(mirror.m_54846_((Direction)blockState.m_61143_((Property)FACING)));
    }

    @Nonnull
    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED, FACING});
    }

    @Nonnull
    public PushReaction m_5537_(@Nonnull BlockState blockState) {
        return PushReaction.DESTROY;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public List<ItemStack> m_7381_(BlockState blockState, LootContext.Builder builder) {
        List drops = super.m_7381_(blockState, builder);
        if (blockState.m_60734_() == ModBlocks.CRYSTAL_CLUSTER) {
            int n;
            ItemStack stack = new ItemStack((ItemLike)ModItems.VAULT_CRYSTAL);
            CrystalData crystal = new CrystalData(stack);
            Entity entity = (Entity)builder.m_78982_(LootContextParams.f_81455_);
            if (entity instanceof Player) {
                Player player = (Player)entity;
                n = PlayerVaultStatsData.get((ServerLevel)player.f_19853_).getVaultStats(player).getVaultLevel();
            } else {
                n = 0;
            }
            int level = n;
            crystal.setLevel(level);
            crystal.setModel(CrystalData.Model.RAW);
            crystal.setTheme(new ValueCrystalTheme(VaultMod.id("raw_vault_cave")));
            drops.add(stack);
        }
        return drops;
    }

    @ParametersAreNonnullByDefault
    public void m_7100_(BlockState blockState, Level level, BlockPos blockPos, Random random) {
        if (!ModConfigs.CRYSTAL_BUDDING.showParticles() || this != ModBlocks.CRYSTAL_CLUSTER) {
            return;
        }
        double x = (float)blockPos.m_123341_() + random.nextFloat();
        double y = (float)blockPos.m_123342_() + random.nextFloat();
        double z = (float)blockPos.m_123343_() + random.nextFloat();
        if (random.nextInt(5) == 0) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123810_, x, y, z, 0.0, (double)0.0125f, 0.0);
        }
    }
}

