/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.entity.AncientCryoChamberTileEntity;
import iskallia.vault.block.entity.CryoChamberTileEntity;
import iskallia.vault.container.RenamingContainer;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.util.BlockHelper;
import iskallia.vault.util.MiscUtils;
import iskallia.vault.util.RenameType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class CryoChamberBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final EnumProperty<ChamberState> CHAMBER_STATE = EnumProperty.m_61587_((String)"chamber_state", ChamberState.class);

    public CryoChamberBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76404_).m_60913_(5.0f, 3600000.0f).m_60918_(SoundType.f_56743_).m_60955_().m_60924_(CryoChamberBlock::isntSolid).m_60971_(CryoChamberBlock::isntSolid));
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(CHAMBER_STATE, (Comparable)((Object)ChamberState.NONE)));
    }

    @Nullable
    public <A extends BlockEntity> BlockEntityTicker<A> m_142354_(Level p_153212_, BlockState state, BlockEntityType<A> tBlockEntityType) {
        if (this.isNormal(state)) {
            return BlockHelper.getTicker(tBlockEntityType, ModBlocks.CRYO_CHAMBER_TILE_ENTITY, CryoChamberTileEntity::tick);
        }
        return BlockHelper.getTicker(tBlockEntityType, ModBlocks.ANCIENT_CRYO_CHAMBER_TILE_ENTITY, AncientCryoChamberTileEntity::tick);
    }

    private static boolean isntSolid(BlockState state, BlockGetter reader, BlockPos pos) {
        return false;
    }

    public void m_49811_(CreativeModeTab group, NonNullList<ItemStack> items) {
        for (ChamberState state : ChamberState.values()) {
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.m_41721_(state.ordinal());
            items.add((Object)stack);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            if (this.isNormal(state)) {
                return ModBlocks.CRYO_CHAMBER_TILE_ENTITY.m_155264_(pos, state);
            }
            return ModBlocks.ANCIENT_CRYO_CHAMBER_TILE_ENTITY.m_155264_(pos, state);
        }
        return null;
    }

    private boolean isNormal(BlockState state) {
        return state.m_61143_(CHAMBER_STATE) == ChamberState.NONE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockPos pos = context.m_8083_();
        Level world = context.m_43725_();
        if (pos.m_123342_() < 255 && world.m_8055_(pos.m_7494_()).m_60629_(context)) {
            return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_())).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER)).m_61124_(CHAMBER_STATE, (Comparable)((Object)MiscUtils.getEnumEntry(ChamberState.class, context.m_43722_().m_41773_())));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING, CHAMBER_STATE});
    }

    public void m_5707_(Level worldIn, BlockPos pos, BlockState state, Player player) {
        BlockPos blockpos;
        BlockState blockstate;
        DoubleBlockHalf half;
        if (!worldIn.f_46443_ && player.m_7500_() && (half = (DoubleBlockHalf)state.m_61143_(HALF)) == DoubleBlockHalf.UPPER && (blockstate = worldIn.m_8055_(blockpos = pos.m_7495_())).m_60734_() == state.m_60734_() && blockstate.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            worldIn.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 35);
            worldIn.m_5898_(player, 2001, blockpos, Block.m_49956_((BlockState)blockstate));
        }
        super.m_5707_(worldIn, pos, state, player);
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor worldIn, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)stateIn.m_61143_(HALF);
        if (facing.m_122434_() == Direction.Axis.Y && half == DoubleBlockHalf.LOWER == (facing == Direction.UP)) {
            return facingState.m_60713_((Block)this) && facingState.m_61143_(HALF) != half ? (BlockState)stateIn.m_61124_((Property)FACING, (Comparable)((Direction)facingState.m_61143_((Property)FACING))) : Blocks.f_50016_.m_49966_();
        }
        return half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !stateIn.m_60710_((LevelReader)worldIn, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(stateIn, facing, facingState, worldIn, currentPos, facingPos);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        worldIn.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
        if (placer != null) {
            CryoChamberTileEntity te = CryoChamberBlock.getCryoChamberTileEntity(worldIn, pos, state);
            te.setOwner(placer.m_142081_());
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        if (!newState.m_60795_()) {
            return;
        }
        CryoChamberTileEntity chamber = CryoChamberBlock.getCryoChamberTileEntity(worldIn, pos, state);
        if (chamber == null) {
            return;
        }
        if (state.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            this.dropCryoChamber(worldIn, pos, state, chamber);
        }
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    private void dropCryoChamber(Level world, BlockPos pos, BlockState state, CryoChamberTileEntity te) {
        ItemStack chamberStack = new ItemStack((ItemLike)ModBlocks.CRYO_CHAMBER);
        chamberStack.m_41721_(((ChamberState)((Object)state.m_61143_(CHAMBER_STATE))).ordinal());
        CompoundTag nbt = chamberStack.m_41784_();
        nbt.m_128365_("BlockEntityTag", (Tag)te.serializeNBT());
        chamberStack.m_41751_(nbt);
        ItemEntity entity = new ItemEntity(world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), chamberStack);
        world.m_7967_((Entity)entity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.m_5776_() || !(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        CryoChamberTileEntity chamber = CryoChamberBlock.getCryoChamberTileEntity(world, pos, state);
        if (chamber == null) {
            return InteractionResult.SUCCESS;
        }
        if (chamber.getOwner() != null && !chamber.getOwner().equals(player.m_142081_())) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldStack = player.m_21120_(hand);
        if (chamber.getEternal() != null) {
            if (player.m_6144_()) {
                if (!heldStack.m_41619_()) return InteractionResult.SUCCESS;
                final CompoundTag nbt = new CompoundTag();
                nbt.m_128405_("RenameType", RenameType.CRYO_CHAMBER.ordinal());
                nbt.m_128365_("Data", (Tag)chamber.getRenameNBT());
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)new MenuProvider(){

                    public Component m_5446_() {
                        return new TextComponent("Cryo Chamber");
                    }

                    @javax.annotation.Nullable
                    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player playerEntity) {
                        return new RenamingContainer(windowId, nbt);
                    }
                }, buffer -> buffer.m_130079_(nbt));
                return InteractionResult.SUCCESS;
            }
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)chamber, buffer -> buffer.m_130064_(pos));
            return InteractionResult.SUCCESS;
        }
        if (((ChamberState)((Object)state.m_61143_(CHAMBER_STATE))).containsAncient() || heldStack.m_41720_() != ModItems.ETERNAL_SOUL) return InteractionResult.SUCCESS;
        if (chamber.getOwner() == null) {
            chamber.setOwner(player.m_142081_());
        }
        if (!chamber.addEternalSoul()) return InteractionResult.SUCCESS;
        if (!player.m_7500_()) {
            heldStack.m_41774_(1);
        }
        chamber.sendUpdates();
        return InteractionResult.SUCCESS;
    }

    public static BlockPos getCryoChamberPos(BlockState state, BlockPos pos) {
        return state.m_61143_(HALF) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos;
    }

    public static CryoChamberTileEntity getCryoChamberTileEntity(Level world, BlockPos pos, BlockState state) {
        BlockPos cryoChamberPos = CryoChamberBlock.getCryoChamberPos(state, pos);
        BlockEntity tileEntity = world.m_7702_(cryoChamberPos);
        if (!(tileEntity instanceof CryoChamberTileEntity)) {
            return null;
        }
        return (CryoChamberTileEntity)tileEntity;
    }

    public static enum ChamberState implements StringRepresentable
    {
        NONE("none"),
        RUSTY("rusty");

        private final String name;

        private ChamberState(String name) {
            this.name = name;
        }

        public boolean containsAncient() {
            return this == RUSTY;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

