/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.block;

import iskallia.vault.block.base.FillableAltarBlock;
import iskallia.vault.block.entity.BloodAltarTileEntity;
import iskallia.vault.init.ModBlocks;
import iskallia.vault.init.ModItems;
import iskallia.vault.init.ModParticles;
import iskallia.vault.util.EntityHelper;
import iskallia.vault.world.data.PlayerFavourData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class BloodAltarBlock
extends FillableAltarBlock<BloodAltarTileEntity> {
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ModBlocks.BLOOD_ALTAR_TILE_ENTITY.m_155264_(pos, state);
    }

    @Override
    public ParticleOptions getFlameParticle() {
        return (ParticleOptions)ModParticles.GREEN_FLAME.get();
    }

    @Override
    public PlayerFavourData.VaultGodType getAssociatedVaultGod() {
        return PlayerFavourData.VaultGodType.BENEVOLENT;
    }

    @Override
    public ItemStack getAssociatedVaultGodShard() {
        return new ItemStack((ItemLike)ModItems.CRYSTAL_SHARD_BENEVOLENT);
    }

    @Override
    public InteractionResult rightClicked(BlockState state, ServerLevel world, BlockPos pos, BloodAltarTileEntity tileEntity, ServerPlayer player, ItemStack heldStack) {
        if (!tileEntity.initialized()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_7500_()) {
            tileEntity.makeProgress(player, 1, sPlayer -> {});
            return InteractionResult.SUCCESS;
        }
        EntityHelper.changeHealth((LivingEntity)player, -2);
        tileEntity.makeProgress(player, 1, sPlayer -> {
            PlayerFavourData.VaultGodType vg;
            PlayerFavourData data = PlayerFavourData.get(sPlayer.m_183503_());
            if (rand.nextFloat() < BloodAltarBlock.getFavourChance((Player)sPlayer, PlayerFavourData.VaultGodType.BENEVOLENT) && data.addFavour((Player)sPlayer, vg = this.getAssociatedVaultGod(), 1)) {
                data.addFavour((Player)sPlayer, vg.getOther(rand), -1);
                FillableAltarBlock.playFavourInfo(sPlayer);
            }
        });
        return InteractionResult.SUCCESS;
    }
}

