/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.attribute;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;

public class VAttribute<T, I extends Instance<T>> {
    private final ResourceLocation id;
    private final Supplier<I> instance;
    private final List<VAttribute<T, I>> modifiers;

    public VAttribute(ResourceLocation id, Supplier<I> instance) {
        this(id, instance, new VAttribute[0]);
    }

    public VAttribute(ResourceLocation id, Supplier<I> instance, VAttribute<T, I> ... modifiers) {
        this.id = id;
        this.instance = instance;
        this.modifiers = new ArrayList<VAttribute<T, I>>(Arrays.asList(modifiers));
    }

    public ResourceLocation getId() {
        return this.id;
    }

    protected String getTagKey() {
        return "Attributes";
    }

    public Optional<I> get(CompoundTag nbt) {
        if (nbt == null || !nbt.m_128425_(this.getTagKey(), 9)) {
            return Optional.empty();
        }
        ListTag attributesList = nbt.m_128437_(this.getTagKey(), 10);
        for (Tag element : attributesList) {
            CompoundTag tag = (CompoundTag)element;
            if (!tag.m_128461_("Id").equals(this.getId().toString())) continue;
            Instance instance = (Instance)this.instance.get();
            instance.parent = this;
            instance.delegate = tag;
            instance.read(tag);
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public boolean exists(CompoundTag nbt) {
        return this.get(nbt).isPresent();
    }

    public I getOrDefault(CompoundTag nbt, T value) {
        return this.getOrDefault(nbt, () -> value);
    }

    public I getOrDefault(CompoundTag nbt, Supplier<T> value) {
        return (I)this.get(nbt).orElse(((Instance)this.instance.get()).setBaseValue(value.get()));
    }

    public I getOrCreate(CompoundTag nbt, T value) {
        return this.getOrCreate(nbt, () -> value);
    }

    public I getOrCreate(CompoundTag nbt, Supplier<T> value) {
        return (I)this.get(nbt).orElseGet(() -> this.create(nbt, value));
    }

    public I create(CompoundTag nbt, T value) {
        return this.create(nbt, () -> value);
    }

    public I create(CompoundTag nbt, Supplier<T> value) {
        if (!nbt.m_128425_(this.getTagKey(), 9)) {
            nbt.m_128365_(this.getTagKey(), (Tag)new ListTag());
        }
        ListTag attributesList = nbt.m_128437_(this.getTagKey(), 10);
        CompoundTag attributeNBT = attributesList.stream().map(element -> (CompoundTag)element).filter(tag -> tag.m_128461_("Id").equals(this.getId().toString())).findFirst().orElseGet(() -> {
            CompoundTag tag = new CompoundTag();
            attributesList.add((Object)tag);
            return tag;
        });
        Instance instance = (Instance)this.instance.get();
        instance.parent = this;
        instance.delegate = attributeNBT;
        instance.setBaseValue(value.get());
        return (I)instance;
    }

    public Optional<I> get(ItemStack stack) {
        CompoundTag nbt = stack.m_41737_("Vault");
        if (nbt == null || !nbt.m_128425_(this.getTagKey(), 9)) {
            return Optional.empty();
        }
        ListTag attributesList = nbt.m_128437_(this.getTagKey(), 10);
        for (Tag element : attributesList) {
            CompoundTag tag = (CompoundTag)element;
            if (!tag.m_128461_("Id").equals(this.getId().toString())) continue;
            Instance instance = (Instance)this.instance.get();
            instance.parent = this;
            instance.delegate = tag;
            instance.read(tag);
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public Optional<T> getBase(ItemStack stack) {
        return this.get(stack).map(Instance::getBaseValue);
    }

    public Optional<T> getValue(ItemStack stack) {
        return this.get(stack).map(attribute -> attribute.getValue(stack));
    }

    public boolean exists(ItemStack stack) {
        return this.get(stack).isPresent();
    }

    public I getOrDefault(ItemStack stack, T value) {
        return this.getOrDefault(stack, () -> value);
    }

    public I getOrDefault(ItemStack stack, Random random, Instance.Generator<T> generator) {
        return this.getOrDefault(stack, () -> generator.generate(stack, random));
    }

    public I getOrDefault(ItemStack stack, Supplier<T> value) {
        return (I)this.get(stack).orElse(((Instance)this.instance.get()).setBaseValue(value.get()));
    }

    public I getOrCreate(ItemStack stack, T value) {
        return this.getOrCreate(stack, () -> value);
    }

    public I getOrCreate(ItemStack stack, Random random, Instance.Generator<T> generator) {
        return this.getOrCreate(stack, () -> generator.generate(stack, random));
    }

    public I getOrCreate(ItemStack stack, Supplier<T> value) {
        return (I)this.get(stack).orElseGet(() -> this.create(stack, value));
    }

    public I create(ItemStack stack, T value) {
        return this.create(stack, () -> value);
    }

    public I create(ItemStack stack, Random random, Instance.Generator<T> generator) {
        return this.create(stack, () -> generator.generate(stack, random));
    }

    public I create(ItemStack stack, Supplier<T> value) {
        CompoundTag nbt = stack.m_41698_("Vault");
        if (!nbt.m_128425_(this.getTagKey(), 9)) {
            nbt.m_128365_(this.getTagKey(), (Tag)new ListTag());
        }
        ListTag attributesList = nbt.m_128437_(this.getTagKey(), 10);
        CompoundTag attributeNBT = attributesList.stream().map(element -> (CompoundTag)element).filter(tag -> tag.m_128461_("Id").equals(this.getId().toString())).findFirst().orElseGet(() -> {
            CompoundTag tag = new CompoundTag();
            attributesList.add((Object)tag);
            return tag;
        });
        Instance instance = (Instance)this.instance.get();
        instance.parent = this;
        instance.delegate = attributeNBT;
        instance.setBaseValue(value.get());
        return (I)instance;
    }

    public static abstract class Instance<T>
    implements INBTSerializable<CompoundTag>,
    Modifier<T> {
        protected VAttribute<T, ? extends Instance<T>> parent;
        protected T baseValue;
        private Modifier<T> modifier;
        protected CompoundTag delegate;

        protected Instance() {
        }

        protected Instance(Modifier<T> modifier) {
            this.modifier = modifier;
        }

        public final CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("Id", this.parent.id.toString());
            this.write(nbt);
            return nbt;
        }

        public final void deserializeNBT(CompoundTag nbt) {
            this.read(nbt);
        }

        public abstract void write(CompoundTag var1);

        public abstract void read(CompoundTag var1);

        public T getBaseValue() {
            return this.baseValue;
        }

        public Instance<T> setBaseValue(T baseValue) {
            this.baseValue = baseValue;
            this.updateNBT();
            return this;
        }

        public T getValue(ItemStack stack) {
            T value = this.getBaseValue();
            if (this.parent == null) {
                return value;
            }
            for (VAttribute modifier : this.parent.modifiers) {
                Optional instance = modifier.get(stack);
                if (!instance.isPresent()) continue;
                value = ((Instance)instance.get()).apply(stack, (Instance)instance.get(), value);
            }
            return value;
        }

        @Override
        public T apply(ItemStack stack, Instance<T> parent, T value) {
            return this.modifier == null ? value : this.modifier.apply(stack, parent, value);
        }

        public void updateNBT() {
            if (this.delegate == null) {
                return;
            }
            CompoundTag nbt = this.serializeNBT();
            for (String key : nbt.m_128431_()) {
                Tag value = nbt.m_128423_(key);
                if (value == null) continue;
                this.delegate.m_128365_(key, value);
            }
        }

        @FunctionalInterface
        public static interface Generator<T> {
            public T generate(ItemStack var1, Random var2);
        }
    }

    @FunctionalInterface
    public static interface Modifier<T> {
        public T apply(ItemStack var1, Instance<T> var2, T var3);
    }
}

