/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.attribute;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.JsonAdapter;
import iskallia.vault.attribute.PooledAttribute;
import iskallia.vault.attribute.VAttribute;
import iskallia.vault.util.gson.IgnoreEmpty;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;

public class StringAttribute
extends PooledAttribute<String> {
    public StringAttribute() {
    }

    public StringAttribute(VAttribute.Modifier<String> modifier) {
        super(modifier);
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128359_("BaseValue", (String)this.getBaseValue());
    }

    @Override
    public void read(CompoundTag nbt) {
        this.setBaseValue(nbt.m_128461_("BaseValue"));
    }

    public static enum Type {
        SET,
        APPEND,
        JOIN,
        REPLACE_FIRST,
        REPLACE_ALL;


        public static Optional<Type> getByName(String name) {
            for (Type value : Type.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }

    public static class Generator
    extends PooledAttribute.Generator<String, Operator> {
        @Override
        public String getDefaultValue(Random random) {
            return "";
        }

        public static class Operator
        extends PooledAttribute.Generator.Operator<String> {
            @Expose
            protected String type;
            @Expose
            @JsonAdapter(value=IgnoreEmpty.StringAdapter.class)
            protected String delimiter;
            @Expose
            @JsonAdapter(value=IgnoreEmpty.StringAdapter.class)
            protected String regex;

            public Operator(Type type) {
                this.type = type.name();
            }

            public Type getType() {
                return Type.getByName(this.type).orElseThrow(() -> new IllegalStateException("Unknown type \"" + this.type + "\""));
            }

            @Override
            public String apply(String value, String modifier) {
                if (this.getType() == Type.SET) {
                    return modifier;
                }
                if (this.getType() == Type.APPEND) {
                    return value + modifier;
                }
                if (this.getType() == Type.JOIN) {
                    return value + this.delimiter + modifier;
                }
                if (this.getType() == Type.REPLACE_FIRST) {
                    return value.replaceFirst(this.regex, modifier);
                }
                if (this.getType() == Type.REPLACE_ALL) {
                    return value.replaceAll(this.regex, modifier);
                }
                return value;
            }
        }
    }
}

