/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.attribute;

import iskallia.vault.attribute.NumberAttribute;
import iskallia.vault.attribute.VAttribute;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;

public class FloatAttribute
extends NumberAttribute<Float> {
    public FloatAttribute() {
    }

    public FloatAttribute(VAttribute.Modifier<Float> modifier) {
        super(modifier);
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128350_("BaseValue", ((Float)this.getBaseValue()).floatValue());
    }

    @Override
    public void read(CompoundTag nbt) {
        this.setBaseValue(Float.valueOf(nbt.m_128457_("BaseValue")));
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Generator.Operator of(NumberAttribute.Type type) {
        return new Generator.Operator(type);
    }

    public static class Generator
    extends NumberAttribute.Generator<Float, Operator> {
        @Override
        public Float getDefaultValue(Random random) {
            return Float.valueOf(0.0f);
        }

        public static class Operator
        extends NumberAttribute.Generator.Operator<Float> {
            public Operator(NumberAttribute.Type type) {
                super(type);
            }

            @Override
            public Float apply(Float value, Float modifier) {
                if (this.getType() == NumberAttribute.Type.SET) {
                    return modifier;
                }
                if (this.getType() == NumberAttribute.Type.ADD) {
                    return Float.valueOf(value.floatValue() + modifier.floatValue());
                }
                if (this.getType() == NumberAttribute.Type.MULTIPLY) {
                    return Float.valueOf(value.floatValue() * modifier.floatValue());
                }
                return value;
            }
        }
    }
}

