/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.attribute;

import com.google.gson.annotations.Expose;
import iskallia.vault.attribute.PooledAttribute;
import iskallia.vault.attribute.VAttribute;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;

public class EnumAttribute<E extends Enum<E>>
extends PooledAttribute<E> {
    private final Class<E> enumClass;

    public EnumAttribute(Class<E> enumClass) {
        this.enumClass = enumClass;
    }

    public EnumAttribute(Class<E> enumClass, VAttribute.Modifier<E> modifier) {
        super(modifier);
        this.enumClass = enumClass;
    }

    public Class<E> getEnumClass() {
        return this.enumClass;
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128359_("BaseValue", ((Enum)this.getBaseValue()).name());
    }

    @Override
    public void read(CompoundTag nbt) {
        this.setBaseValue(this.getEnumConstant(nbt.m_128461_("BaseValue")));
    }

    public E getEnumConstant(String value) {
        try {
            return Enum.valueOf(this.getEnumClass(), value);
        }
        catch (Exception e) {
            Enum[] enumConstants = (Enum[])this.getEnumClass().getEnumConstants();
            return (E)(enumConstants.length == 0 ? null : enumConstants[0]);
        }
    }

    public static <E extends Enum<E>> Generator<E> generator(Class<E> enumClass) {
        return new Generator();
    }

    public static <E extends Enum<E>> Generator.Operator<E> of(Type type) {
        return new Generator.Operator(type);
    }

    public static class Generator<E extends Enum<E>>
    extends PooledAttribute.Generator<E, Operator<E>> {
        @Override
        public E getDefaultValue(Random random) {
            return null;
        }

        public static class Operator<E extends Enum<E>>
        extends PooledAttribute.Generator.Operator<E> {
            @Expose
            protected String type;

            public Operator(Type type) {
                this.type = type.name();
            }

            public Type getType() {
                return Type.getByName(this.type).orElseThrow(() -> new IllegalStateException("Unknown type \"" + this.type + "\""));
            }

            @Override
            public E apply(E value, E modifier) {
                if (this.getType() == Type.SET) {
                    return modifier;
                }
                return value;
            }
        }
    }

    public static enum Type {
        SET;


        public static Optional<Type> getByName(String name) {
            for (Type value : Type.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }
}

