/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.attribute;

import com.google.gson.annotations.Expose;
import iskallia.vault.attribute.PooledAttribute;
import iskallia.vault.attribute.VAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;

public class EffectAttribute
extends PooledAttribute<List<Instance>> {
    public EffectAttribute() {
    }

    public EffectAttribute(VAttribute.Modifier<List<Instance>> modifier) {
        super(modifier);
    }

    @Override
    public void write(CompoundTag nbt) {
        if (this.getBaseValue() == null) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        ListTag effectsList = new ListTag();
        ((List)this.getBaseValue()).forEach(effect -> {
            CompoundTag effectTag = new CompoundTag();
            tag.m_128359_("Id", effect.effect);
            effectsList.add((Object)effectTag);
        });
        tag.m_128365_("Effects", (Tag)effectsList);
        nbt.m_128365_("BaseValue", (Tag)tag);
    }

    @Override
    public void read(CompoundTag nbt) {
        if (!nbt.m_128425_("BaseValue", 10)) {
            this.setBaseValue(new ArrayList());
            return;
        }
        CompoundTag tag = nbt.m_128469_("BaseValue");
        ListTag effectsList = tag.m_128437_("Effects", 10);
        this.setBaseValue(effectsList.stream().map(inbt -> (CompoundTag)inbt).map(effect -> new Instance(tag.m_128461_("Id"))).collect(Collectors.toList()));
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Generator.Operator of(Type type) {
        return new Generator.Operator(type);
    }

    public static class Generator
    extends PooledAttribute.Generator<List<Instance>, Operator> {
        @Override
        public List<Instance> getDefaultValue(Random random) {
            return new ArrayList<Instance>();
        }

        public static class Operator
        extends PooledAttribute.Generator.Operator<List<Instance>> {
            @Expose
            protected String type;

            public Operator(Type type) {
                this.type = type.name();
            }

            public Type getType() {
                return Type.getByName(this.type).orElseThrow(() -> new IllegalStateException("Unknown type \"" + this.type + "\""));
            }

            @Override
            public List<Instance> apply(List<Instance> value, List<Instance> modifier) {
                if (this.getType() == Type.SET) {
                    return modifier;
                }
                if (this.getType() == Type.MERGE) {
                    ArrayList<Instance> res = new ArrayList<Instance>(value);
                    res.addAll(modifier);
                    return res;
                }
                return value;
            }
        }
    }

    public static enum Type {
        SET,
        MERGE;


        public static Optional<Type> getByName(String name) {
            for (Type value : Type.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }

    public static class Instance {
        @Expose
        protected String effect;

        public Instance(String effect) {
            this.effect = effect;
        }

        public Instance(MobEffect effect) {
            this(effect.getRegistryName().toString());
        }

        public String getId() {
            return this.effect;
        }

        public MobEffect toEffect() {
            return Registry.f_122823_.m_6612_(new ResourceLocation(this.effect)).orElse(null);
        }

        public String toString() {
            return "Instance{effect='" + this.effect + "'}";
        }
    }
}

