/*
 * Decompiled with CFR 0.152.
 */
package iskallia.vault.attribute;

import com.google.gson.annotations.Expose;
import iskallia.vault.attribute.PooledAttribute;
import iskallia.vault.attribute.VAttribute;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;

public class BooleanAttribute
extends PooledAttribute<Boolean> {
    public BooleanAttribute() {
    }

    public BooleanAttribute(VAttribute.Modifier<Boolean> modifier) {
        super(modifier);
    }

    @Override
    public void write(CompoundTag nbt) {
        nbt.m_128379_("BaseValue", ((Boolean)this.getBaseValue()).booleanValue());
    }

    @Override
    public void read(CompoundTag nbt) {
        this.setBaseValue(nbt.m_128471_("BaseValue"));
    }

    public static Generator generator() {
        return new Generator();
    }

    public static Generator.Operator of(Type type) {
        return new Generator.Operator(type);
    }

    public static class Generator
    extends PooledAttribute.Generator<Boolean, Operator> {
        @Override
        public Boolean getDefaultValue(Random random) {
            return false;
        }

        public static class Operator
        extends PooledAttribute.Generator.Operator<Boolean> {
            @Expose
            protected String type;

            public Operator(Type type) {
                this.type = type.name();
            }

            public Type getType() {
                return Type.getByName(this.type).orElseThrow(() -> new IllegalStateException("Unknown type \"" + this.type + "\""));
            }

            @Override
            public Boolean apply(Boolean value, Boolean modifier) {
                if (this.getType() == Type.SET) {
                    return modifier;
                }
                if (this.getType() == Type.AND) {
                    return value & modifier;
                }
                if (this.getType() == Type.OR) {
                    return value | modifier;
                }
                if (this.getType() == Type.XOR) {
                    return value ^ modifier;
                }
                if (this.getType() == Type.NAND) {
                    return !(value & modifier);
                }
                if (this.getType() == Type.NOR) {
                    return !(value | modifier);
                }
                if (this.getType() == Type.XNOR) {
                    return value == modifier;
                }
                return value;
            }
        }
    }

    public static enum Type {
        SET,
        AND,
        OR,
        XOR,
        NAND,
        NOR,
        XNOR;


        public static Optional<Type> getByName(String name) {
            for (Type value : Type.values()) {
                if (!value.name().equalsIgnoreCase(name)) continue;
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }
}

