/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.filtering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.SidedFilteringBehaviour;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import com.simibubi.create.foundation.utility.VecHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FilteringRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.m_91087_();
        HitResult target = mc.f_91077_;
        if (target == null || !(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.f_91073_;
        BlockPos pos = result.m_82425_();
        BlockState state = world.m_8055_(pos);
        FilteringBehaviour behaviour = TileEntityBehaviour.get((BlockGetter)world, pos, FilteringBehaviour.TYPE);
        if (mc.f_91074_.m_6144_()) {
            return;
        }
        if (behaviour == null) {
            return;
        }
        if (behaviour instanceof SidedFilteringBehaviour && (behaviour = ((SidedFilteringBehaviour)behaviour).get(result.m_82434_())) == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)behaviour.slotPositioning).fromSide(result.m_82434_());
        }
        if (!behaviour.slotPositioning.shouldRender(state)) {
            return;
        }
        ItemStack filter = behaviour.getFilter();
        boolean isFilterSlotted = filter.m_41720_() instanceof FilterItem;
        boolean showCount = behaviour.isCountVisible();
        boolean fluids = behaviour.fluidFilter;
        Component label = isFilterSlotted ? Components.immutableEmpty() : Lang.translateDirect(behaviour.recipeFilter ? "logistics.recipe_filter" : (fluids ? "logistics.fluid_filter" : "logistics.filter"), new Object[0]);
        boolean hit = behaviour.slotPositioning.testHit(state, target.m_82450_().m_82546_(Vec3.m_82528_((Vec3i)pos)));
        AABB emptyBB = new AABB(Vec3.f_82478_, Vec3.f_82478_);
        AABB bb = isFilterSlotted ? emptyBB.m_82377_((double)0.45f, (double)0.31f, (double)0.2f) : emptyBB.m_82400_(0.25);
        ValueBox box = showCount ? new ValueBox.ItemValueBox(label, bb, pos, filter, behaviour.scrollableValue) : new ValueBox(label, bb, pos);
        box.offsetLabel(behaviour.textShift).withColors(fluids ? 4223112 : 8022572, fluids ? 7384501 : 12033380).scrollTooltip((Component)(showCount && !isFilterSlotted ? Components.literal("[").m_7220_((Component)Lang.translateDirect("action.scroll", new Object[0])).m_130946_("]") : Components.immutableEmpty())).passive(!hit);
        CreateClient.OUTLINER.showValueBox(Pair.of("filter", pos), box.transform(behaviour.slotPositioning)).lineWidth(0.015625f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(result.m_82434_());
    }

    public static void renderOnTileEntity(SmartTileEntity te, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        FilteringBehaviour behaviour;
        Entity cameraEntity;
        if (te == null || te.m_58901_()) {
            return;
        }
        if (!te.isVirtual() && (cameraEntity = Minecraft.m_91087_().f_91075_) != null && te.m_58904_() == cameraEntity.m_183503_()) {
            float max = AllConfigs.CLIENT.filterItemRenderDistance.getF();
            if (cameraEntity.m_20182_().m_82557_(VecHelper.getCenterOf((Vec3i)te.m_58899_())) > (double)(max * max)) {
                return;
            }
        }
        if ((behaviour = te.getBehaviour(FilteringBehaviour.TYPE)) == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.getFilter().m_41619_() && !(behaviour instanceof SidedFilteringBehaviour)) {
            return;
        }
        ValueBoxTransform slotPositioning = behaviour.slotPositioning;
        BlockState blockState = te.m_58900_();
        if (slotPositioning instanceof ValueBoxTransform.Sided) {
            ValueBoxTransform.Sided sided = (ValueBoxTransform.Sided)slotPositioning;
            Direction side = sided.getSide();
            for (Direction d : Iterate.directions) {
                ItemStack filter = behaviour.getFilter(d);
                if (filter.m_41619_()) continue;
                sided.fromSide(d);
                if (!slotPositioning.shouldRender(blockState)) continue;
                ms.m_85836_();
                slotPositioning.transform(blockState, ms);
                ValueBoxRenderer.renderItemIntoValueBox(filter, ms, buffer, light, overlay);
                ms.m_85849_();
            }
            sided.fromSide(side);
            return;
        }
        if (slotPositioning.shouldRender(blockState)) {
            ms.m_85836_();
            slotPositioning.transform(blockState, ms);
            ValueBoxRenderer.renderItemIntoValueBox(behaviour.getFilter(), ms, buffer, light, overlay);
            ms.m_85849_();
        }
    }
}

