/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement.train.capability;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.components.structureMovement.AbstractContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.OrientedContraptionEntity;
import com.simibubi.create.content.contraptions.components.structureMovement.train.CouplingHandler;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.CapabilityMinecartController;
import com.simibubi.create.content.contraptions.components.structureMovement.train.capability.MinecartControllerUpdatePacket;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.Couple;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableBoolean;

public class MinecartController
implements INBTSerializable<CompoundTag> {
    public static MinecartController EMPTY;
    private boolean needsEntryRefresh;
    private WeakReference<AbstractMinecart> weakRef;
    private Couple<Optional<StallData>> stallData;
    private Couple<Optional<CouplingData>> couplings;

    public MinecartController(AbstractMinecart minecart) {
        this.weakRef = new WeakReference<AbstractMinecart>(minecart);
        this.stallData = Couple.create(Optional::empty);
        this.couplings = Couple.create(Optional::empty);
        this.needsEntryRefresh = true;
    }

    public void tick() {
        AbstractMinecart cart = this.cart();
        Level world = this.getWorld();
        if (this.needsEntryRefresh) {
            CapabilityMinecartController.queuedAdditions.get((LevelAccessor)world).add(cart);
            this.needsEntryRefresh = false;
        }
        this.stallData.forEach(opt -> opt.ifPresent(sd -> sd.tick(cart)));
        MutableBoolean internalStall = new MutableBoolean(false);
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(world, idOfOther);
            internalStall.setValue(internalStall.booleanValue() || otherCart == null || !otherCart.isPresent() || otherCart.isStalled(false));
        }));
        if (!world.f_46443_) {
            this.setStalled(internalStall.booleanValue(), true);
            this.disassemble(cart);
        }
    }

    private void disassemble(AbstractMinecart cart) {
        int k;
        int j;
        if (cart instanceof Minecart) {
            return;
        }
        List passengers = cart.m_20197_();
        if (passengers.isEmpty() || !(passengers.get(0) instanceof AbstractContraptionEntity)) {
            return;
        }
        Level world = cart.f_19853_;
        int i = Mth.m_14107_((double)cart.m_20185_());
        if (world.m_8055_(new BlockPos(i, (j = Mth.m_14107_((double)cart.m_20186_())) - 1, k = Mth.m_14107_((double)cart.m_20189_()))).m_204336_(BlockTags.f_13034_)) {
            --j;
        }
        BlockPos blockpos = new BlockPos(i, j, k);
        BlockState blockstate = world.m_8055_(blockpos);
        if (cart.canUseRail() && blockstate.m_204336_(BlockTags.f_13034_) && blockstate.m_60734_() instanceof PoweredRailBlock && ((PoweredRailBlock)blockstate.m_60734_()).isActivatorRail()) {
            if (cart.m_20160_()) {
                cart.m_20153_();
            }
            if (cart.m_38176_() == 0) {
                cart.m_38160_(-cart.m_38177_());
                cart.m_38154_(10);
                cart.m_38109_(50.0f);
                cart.f_19864_ = true;
            }
        }
    }

    public boolean isFullyCoupled() {
        return this.isLeadingCoupling() && this.isConnectedToCoupling();
    }

    public boolean isLeadingCoupling() {
        return this.couplings.get(true).isPresent();
    }

    public boolean isConnectedToCoupling() {
        return this.couplings.get(false).isPresent();
    }

    public boolean isCoupledThroughContraption() {
        for (boolean current : Iterate.trueAndFalse) {
            if (!this.hasContraptionCoupling(current)) continue;
            return true;
        }
        return false;
    }

    public boolean hasContraptionCoupling(boolean current) {
        Optional<CouplingData> optional = this.couplings.get(current);
        return optional.isPresent() && optional.get().contraption;
    }

    public float getCouplingLength(boolean leading) {
        Optional<CouplingData> optional = this.couplings.get(leading);
        if (optional.isPresent()) {
            return optional.get().length;
        }
        return 0.0f;
    }

    public void decouple() {
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> {
            UUID idOfOther = cd.idOfCart(main == false);
            MinecartController otherCart = CapabilityMinecartController.getIfPresent(this.getWorld(), idOfOther);
            if (otherCart == null) {
                return;
            }
            this.removeConnection((boolean)main);
            otherCart.removeConnection(main == false);
        }));
    }

    public void removeConnection(boolean main) {
        Entity entity;
        List passengers;
        if (this.hasContraptionCoupling(main) && !this.getWorld().f_46443_ && !(passengers = this.cart().m_20197_()).isEmpty() && (entity = (Entity)passengers.get(0)) instanceof AbstractContraptionEntity) {
            ((AbstractContraptionEntity)entity).disassemble();
        }
        this.couplings.set(main, Optional.empty());
        this.needsEntryRefresh |= main;
        this.sendData();
    }

    public void prepareForCoupling(boolean isLeading) {
        if (isLeading && this.isLeadingCoupling() || !isLeading && this.isConnectedToCoupling()) {
            ArrayList<MinecartController> cartsToFlip = new ArrayList<MinecartController>();
            MinecartController current = this;
            boolean forward = current.isLeadingCoupling();
            int safetyCount = 1000;
            do {
                if (safetyCount-- <= 0) {
                    Create.LOGGER.warn("Infinite loop in coupling iteration");
                    return;
                }
                cartsToFlip.add(current);
            } while ((current = CouplingHandler.getNextInCouplingChain(this.getWorld(), current, forward)) != null && current != EMPTY);
            Iterator iterator = cartsToFlip.iterator();
            while (iterator.hasNext()) {
                MinecartController minecartController;
                MinecartController mc = minecartController = (MinecartController)iterator.next();
                mc.couplings.forEachWithContext((opt, leading) -> opt.ifPresent(cd -> {
                    cd.flip();
                    if (!cd.contraption) {
                        return;
                    }
                    List passengers = mc.cart().m_20197_();
                    if (passengers.isEmpty()) {
                        return;
                    }
                    Entity entity = (Entity)passengers.get(0);
                    if (!(entity instanceof OrientedContraptionEntity)) {
                        return;
                    }
                    OrientedContraptionEntity contraption = (OrientedContraptionEntity)entity;
                    UUID couplingId = contraption.getCouplingId();
                    if (couplingId == cd.mainCartID) {
                        contraption.setCouplingId(cd.connectedCartID);
                        return;
                    }
                    if (couplingId == cd.connectedCartID) {
                        contraption.setCouplingId(cd.mainCartID);
                        return;
                    }
                }));
                mc.couplings = mc.couplings.swap();
                mc.needsEntryRefresh = true;
                if (mc == this) continue;
                mc.sendData();
            }
        }
    }

    public void coupleWith(boolean isLeading, UUID coupled, float length, boolean contraption) {
        UUID mainID = isLeading ? this.cart().m_142081_() : coupled;
        UUID connectedID = isLeading ? coupled : this.cart().m_142081_();
        this.couplings.set(isLeading, Optional.of(new CouplingData(mainID, connectedID, length, contraption)));
        this.needsEntryRefresh |= isLeading;
        this.sendData();
    }

    @Nullable
    public UUID getCoupledCart(boolean asMain) {
        Optional<CouplingData> optional = this.couplings.get(asMain);
        if (!optional.isPresent()) {
            return null;
        }
        CouplingData couplingData = optional.get();
        return asMain ? couplingData.connectedCartID : couplingData.mainCartID;
    }

    public boolean isStalled() {
        return this.isStalled(true) || this.isStalled(false);
    }

    private boolean isStalled(boolean internal) {
        return this.stallData.get(internal).isPresent();
    }

    public void setStalledExternally(boolean stall) {
        this.setStalled(stall, false);
    }

    private void setStalled(boolean stall, boolean internal) {
        if (this.isStalled(internal) == stall) {
            return;
        }
        AbstractMinecart cart = this.cart();
        if (stall) {
            this.stallData.set(internal, Optional.of(new StallData(cart)));
            this.sendData();
            return;
        }
        if (!this.isStalled(!internal)) {
            this.stallData.get(internal).get().release(cart);
        }
        this.stallData.set(internal, Optional.empty());
        this.sendData();
    }

    public void sendData() {
        if (this.getWorld().f_46443_) {
            return;
        }
        AllPackets.channel.send(PacketDistributor.TRACKING_ENTITY.with(this::cart), (Object)new MinecartControllerUpdatePacket(this));
    }

    public CompoundTag serializeNBT() {
        CompoundTag compoundNBT = new CompoundTag();
        this.stallData.forEachWithContext((opt, internal) -> opt.ifPresent(sd -> compoundNBT.m_128365_(internal != false ? "InternalStallData" : "StallData", (Tag)sd.serialize())));
        this.couplings.forEachWithContext((opt, main) -> opt.ifPresent(cd -> compoundNBT.m_128365_(main != false ? "MainCoupling" : "ConnectedCoupling", (Tag)cd.serialize())));
        return compoundNBT;
    }

    public void deserializeNBT(CompoundTag nbt) {
        Optional<Object> internalSD = Optional.empty();
        Optional<Object> externalSD = Optional.empty();
        Optional<Object> mainCD = Optional.empty();
        Optional<Object> connectedCD = Optional.empty();
        if (nbt.m_128441_("InternalStallData")) {
            internalSD = Optional.of(StallData.read(nbt.m_128469_("InternalStallData")));
        }
        if (nbt.m_128441_("StallData")) {
            externalSD = Optional.of(StallData.read(nbt.m_128469_("StallData")));
        }
        if (nbt.m_128441_("MainCoupling")) {
            mainCD = Optional.of(CouplingData.read(nbt.m_128469_("MainCoupling")));
        }
        if (nbt.m_128441_("ConnectedCoupling")) {
            connectedCD = Optional.of(CouplingData.read(nbt.m_128469_("ConnectedCoupling")));
        }
        this.stallData = Couple.create(internalSD, externalSD);
        this.couplings = Couple.create(mainCD, connectedCD);
        this.needsEntryRefresh = true;
    }

    public boolean isPresent() {
        return this.weakRef.get() != null && this.cart().m_6084_();
    }

    public AbstractMinecart cart() {
        return (AbstractMinecart)this.weakRef.get();
    }

    public static MinecartController empty() {
        return EMPTY != null ? EMPTY : (EMPTY = new MinecartController(null));
    }

    private Level getWorld() {
        return this.cart().m_20193_();
    }

    private static class CouplingData {
        private UUID mainCartID;
        private UUID connectedCartID;
        private float length;
        private boolean contraption;

        public CouplingData(UUID mainCartID, UUID connectedCartID, float length, boolean contraption) {
            this.mainCartID = mainCartID;
            this.connectedCartID = connectedCartID;
            this.length = length;
            this.contraption = contraption;
        }

        void flip() {
            UUID swap = this.mainCartID;
            this.mainCartID = this.connectedCartID;
            this.connectedCartID = swap;
        }

        CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Main", (Tag)NbtUtils.m_129226_((UUID)this.mainCartID));
            nbt.m_128365_("Connected", (Tag)NbtUtils.m_129226_((UUID)this.connectedCartID));
            nbt.m_128350_("Length", this.length);
            nbt.m_128379_("Contraption", this.contraption);
            return nbt;
        }

        static CouplingData read(CompoundTag nbt) {
            UUID mainCartID = NbtUtils.m_129233_((Tag)NBTHelper.getINBT(nbt, "Main"));
            UUID connectedCartID = NbtUtils.m_129233_((Tag)NBTHelper.getINBT(nbt, "Connected"));
            float length = nbt.m_128457_("Length");
            boolean contraption = nbt.m_128471_("Contraption");
            return new CouplingData(mainCartID, connectedCartID, length, contraption);
        }

        public UUID idOfCart(boolean main) {
            return main ? this.mainCartID : this.connectedCartID;
        }
    }

    private static class StallData {
        Vec3 position;
        Vec3 motion;
        float yaw;
        float pitch;

        private StallData() {
        }

        StallData(AbstractMinecart entity) {
            this.position = entity.m_20182_();
            this.motion = entity.m_20184_();
            this.yaw = entity.m_146908_();
            this.pitch = entity.m_146909_();
            this.tick(entity);
        }

        void tick(AbstractMinecart entity) {
            entity.m_6034_(this.position.f_82479_, this.position.f_82480_, this.position.f_82481_);
            entity.m_20256_(Vec3.f_82478_);
            entity.m_146922_(this.yaw);
            entity.m_146926_(this.pitch);
        }

        void release(AbstractMinecart entity) {
            entity.m_20256_(this.motion);
        }

        CompoundTag serialize() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("Pos", (Tag)VecHelper.writeNBT(this.position));
            nbt.m_128365_("Motion", (Tag)VecHelper.writeNBT(this.motion));
            nbt.m_128350_("Yaw", this.yaw);
            nbt.m_128350_("Pitch", this.pitch);
            return nbt;
        }

        static StallData read(CompoundTag nbt) {
            StallData stallData = new StallData();
            stallData.position = VecHelper.readNBT(nbt.m_128437_("Pos", 6));
            stallData.motion = VecHelper.readNBT(nbt.m_128437_("Motion", 6));
            stallData.yaw = nbt.m_128457_("Yaw");
            stallData.pitch = nbt.m_128457_("Pitch");
            return stallData;
        }
    }
}

