/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.deployer;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllRecipeTypes;
import com.simibubi.create.AllTags;
import com.simibubi.create.compat.jei.category.sequencedAssembly.SequencedAssemblySubCategory;
import com.simibubi.create.content.contraptions.itemAssembly.IAssemblyRecipe;
import com.simibubi.create.content.contraptions.processing.ItemApplicationRecipe;
import com.simibubi.create.content.contraptions.processing.ProcessingRecipeBuilder;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Lang;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DeployerApplicationRecipe
extends ItemApplicationRecipe
implements IAssemblyRecipe {
    public DeployerApplicationRecipe(ProcessingRecipeBuilder.ProcessingRecipeParams params) {
        super(AllRecipeTypes.DEPLOYING, params);
    }

    @Override
    protected int getMaxOutputCount() {
        return 2;
    }

    public static DeployerApplicationRecipe convert(Recipe<?> sandpaperRecipe) {
        return new ProcessingRecipeBuilder<DeployerApplicationRecipe>(DeployerApplicationRecipe::new, new ResourceLocation(sandpaperRecipe.m_6423_().m_135827_(), sandpaperRecipe.m_6423_().m_135815_() + "_using_deployer")).require((Ingredient)sandpaperRecipe.m_7527_().get(0)).require(AllTags.AllItemTags.SANDPAPER.tag).output(sandpaperRecipe.m_8043_()).build();
    }

    @Override
    public void addAssemblyIngredients(List<Ingredient> list) {
        list.add((Ingredient)this.ingredients.get(1));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Component getDescriptionForAssembly() {
        ItemStack[] matchingStacks = ((Ingredient)this.ingredients.get(1)).m_43908_();
        if (matchingStacks.length == 0) {
            return Components.literal("Invalid");
        }
        return Lang.translateDirect("recipe.assembly.deploying_item", Components.translatable(matchingStacks[0].m_41778_()).getString());
    }

    @Override
    public void addRequiredMachines(Set<ItemLike> list) {
        list.add((ItemLike)AllBlocks.DEPLOYER.get());
    }

    @Override
    public Supplier<Supplier<SequencedAssemblySubCategory>> getJEISubCategory() {
        return () -> SequencedAssemblySubCategory.AssemblyDeploying::new;
    }
}

