/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.item.smartfilter;

import java.util.Comparator;
import java.util.List;
import me.desht.modularrouters.ModularRouters;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.container.ContainerBulkItemFilter;
import me.desht.modularrouters.container.ContainerSmartFilter;
import me.desht.modularrouters.container.handler.BaseModuleHandler;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.logic.filter.Filter;
import me.desht.modularrouters.logic.filter.matchers.BulkItemMatcher;
import me.desht.modularrouters.logic.filter.matchers.IItemMatcher;
import me.desht.modularrouters.network.FilterSettingsMessage;
import me.desht.modularrouters.network.GuiSyncMessage;
import me.desht.modularrouters.util.InventoryUtils;
import me.desht.modularrouters.util.MFLocator;
import me.desht.modularrouters.util.SetofItemStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class BulkItemFilter
extends SmartFilterItem {
    public static final int FILTER_SIZE = 54;

    @Override
    public IItemMatcher compile(ItemStack filterStack, ItemStack moduleStack) {
        Filter.Flags flags = moduleStack.m_41619_() ? Filter.Flags.DEFAULT_FLAGS : new Filter.Flags(moduleStack);
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, flags);
        return new BulkItemMatcher(stacks, flags);
    }

    private static SetofItemStack getFilterItems(ItemStack filterStack, Filter.Flags flags) {
        if (filterStack.m_41782_()) {
            BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack, null);
            return SetofItemStack.fromItemHandler((IItemHandler)handler, flags);
        }
        return new SetofItemStack(Filter.Flags.DEFAULT_FLAGS);
    }

    @Override
    public void addExtraInformation(ItemStack itemstack, List<Component> list) {
        super.addExtraInformation(itemstack, list);
        list.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.bulkItemFilter.count", this.getSize(itemstack)));
    }

    @Override
    public ContainerSmartFilter createContainer(int windowId, Inventory invPlayer, MFLocator loc) {
        return new ContainerBulkItemFilter(windowId, invPlayer, loc);
    }

    public InteractionResult m_6225_(UseOnContext ctx) {
        Level world = ctx.m_43725_();
        Player player = ctx.m_43723_();
        ItemStack stack = ctx.m_43722_();
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.m_20161_()) {
            return InventoryUtils.getInventory(world, ctx.m_8083_(), ctx.m_43719_()).map(handler -> {
                int nAdded = this.mergeInventory(stack, (IItemHandler)handler);
                player.m_5661_((Component)new TranslatableComponent("modularrouters.chatText.misc.inventoryMerged", new Object[]{nAdded, stack.m_41786_()}), false);
                world.m_5594_(null, ctx.m_8083_(), (SoundEvent)ModSounds.SUCCESS.get(), SoundSource.MASTER, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }).orElse(super.m_6225_(ctx));
        }
        return InteractionResult.PASS;
    }

    @Override
    public GuiSyncMessage onReceiveSettingsMessage(Player player, FilterSettingsMessage message, ItemStack filterStack, ItemStack moduleStack) {
        AbstractContainerMenu abstractContainerMenu = player.f_36096_;
        if (abstractContainerMenu instanceof ContainerBulkItemFilter) {
            ContainerBulkItemFilter con = (ContainerBulkItemFilter)abstractContainerMenu;
            Filter.Flags flags = moduleStack.m_41619_() ? Filter.Flags.DEFAULT_FLAGS : new Filter.Flags(moduleStack);
            switch (message.getOp()) {
                case CLEAR_ALL: {
                    con.clearSlots();
                    break;
                }
                case MERGE: {
                    message.getTargetInventory().ifPresent(h -> con.mergeInventory((IItemHandler)h, flags, false));
                    break;
                }
                case LOAD: {
                    message.getTargetInventory().ifPresent(h -> con.mergeInventory((IItemHandler)h, flags, true));
                    break;
                }
                default: {
                    ModularRouters.LOGGER.warn("received unexpected message type " + message.getOp() + " for " + filterStack);
                }
            }
        }
        return null;
    }

    @Override
    public int getSize(ItemStack filterStack) {
        return BaseModuleHandler.getFilterSize(filterStack, "ModuleFilter");
    }

    private int mergeInventory(ItemStack filterStack, IItemHandler srcInventory) {
        SetofItemStack stacks = BulkItemFilter.getFilterItems(filterStack, Filter.Flags.DEFAULT_FLAGS);
        int origSize = stacks.size();
        for (int i = 0; i < srcInventory.getSlots() && stacks.size() < 54; ++i) {
            ItemStack stack = srcInventory.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            stacks.add(ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
        }
        BaseModuleHandler.BulkFilterHandler handler = new BaseModuleHandler.BulkFilterHandler(filterStack, null);
        int slot = 0;
        Comparator comp = (o1, o2) -> o1.m_41786_().toString().compareTo(o2.m_41786_().getString());
        for (ItemStack stack : stacks.stream().sorted(comp).toList()) {
            handler.setStackInSlot(slot++, stack);
        }
        handler.save();
        return stacks.size() - origSize;
    }
}

