/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public final Module module = new Module();
    public final Router router = new Router();
    public final EnergyCosts energyCosts = new EnergyCosts();

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Module");
        this.module.sender1BaseRange = builder.comment("Base range for Sender Mk1 (no range upgrades)").translation("modularrouters.gui.config.sender1BaseRange").defineInRange("sender1BaseRange", 8, 1, Integer.MAX_VALUE);
        this.module.sender1MaxRange = builder.comment("Max range for Sender Mk1").translation("modularrouters.gui.config.sender1MaxRange").defineInRange("sender1MaxRange", 16, 1, Integer.MAX_VALUE);
        this.module.sender2BaseRange = builder.comment("Base range for Sender Mk2 (no range upgrades)").translation("modularrouters.gui.config.sender2BaseRange").defineInRange("sender2BaseRange", 24, 1, Integer.MAX_VALUE);
        this.module.sender2MaxRange = builder.comment("Max range for Sender Mk2").translation("modularrouters.gui.config.sender2MaxRange").defineInRange("sender2MaxRange", 48, 1, Integer.MAX_VALUE);
        this.module.vacuumBaseRange = builder.comment("Base range for Vacuum (no range upgrades)").translation("modularrouters.gui.config.vacuumBaseRange").defineInRange("vacuumBaseRange", 6, 1, Integer.MAX_VALUE);
        this.module.vacuumMaxRange = builder.comment("Max range for Vacuum").translation("modularrouters.gui.config.vacuumMaxRange").defineInRange("vacuumMaxRange", 12, 1, Integer.MAX_VALUE);
        this.module.extruder1BaseRange = builder.comment("Base range for Extruder Mk1 (no range upgrades)").translation("gui.config.extruder1BaseRange").defineInRange("extruder1BaseRange", 16, 1, Integer.MAX_VALUE);
        this.module.extruder1MaxRange = builder.comment("Max range for Extruder Mk1").translation("gui.config.extruder1MaxRange").defineInRange("extruder1MaxRange", 32, 1, Integer.MAX_VALUE);
        this.module.extruder2BaseRange = builder.comment("Base range for Extruder Mk2 (no range upgrades)").translation("modularrouters.gui.config.extruder2BaseRange").defineInRange("extruder2BaseRange", 32, 1, Integer.MAX_VALUE);
        this.module.extruder2MaxRange = builder.comment("Max range for Extruder Mk2").translation("modularrouters.gui.config.extruder2MaxRange").defineInRange("extruder2MaxRange", 64, 1, Integer.MAX_VALUE);
        this.module.puller2BaseRange = builder.comment("Base range for Puller Mk2 (no range upgrades)").translation("modularrouters.gui.config.puller2BaseRange").defineInRange("puller2BaseRange", 12, 1, Integer.MAX_VALUE);
        this.module.puller2MaxRange = builder.comment("Max range for Puller Mk2").translation("modularrouters.gui.config.puller2MaxRange").defineInRange("puller2MaxRange", 24, 1, Integer.MAX_VALUE);
        this.module.fluid2BaseRange = builder.comment("Base range for Fluid Mk2 (no range upgrades)").translation("gui.config.fluid2BaseRange").defineInRange("fluid2BaseRange", 12, 1, Integer.MAX_VALUE);
        this.module.fluid2MaxRange = builder.comment("Max range for Fluid Mk2").translation("gui.config.fluid2MaxRange").defineInRange("fluid2MaxRange", 24, 1, Integer.MAX_VALUE);
        this.module.senderParticles = builder.comment("Should Sender modules show particle effects when working?").translation("modularrouters.gui.config.senderParticles").define("senderParticles", true);
        this.module.pullerParticles = builder.comment("Should Puller modules show particle effects when working?").translation("modularrouters.gui.config.pullerParticles").define("pullerParticles", true);
        this.module.placerParticles = builder.comment("Should Placer modules show particle effects when working?").translation("modularrouters.gui.config.placerParticles").define("placerParticles", true);
        this.module.breakerParticles = builder.comment("Should Breaker modules show particle effects when working?").translation("modularrouters.gui.config.breakerParticles").define("breakerParticles", true);
        this.module.vacuumParticles = builder.comment("Should Vacuum modules show particle effects when working?").translation("modularrouters.gui.config.vacuumParticles").define("vacuumParticles", true);
        this.module.flingerEffects = builder.comment("Should Flinger modules show smoke effects & play a sound when working?").translation("modularrouters.gui.config.flingerEffects").define("flingerEffects", true);
        this.module.extruderSound = builder.comment("Should Extruder Mk1/2 modules play a sound when placing/removing blocks?").translation("modularrouters.gui.config.extruderSound").define("extruderSound", true);
        this.module.extruderPushEntities = builder.comment("Should Extruder Mk1/2 modules push entities along when extruding blocks?").translation("modularrouters.gui.config.extruderPushEntities").define("extruderPushEntities", true);
        this.module.breakerHarvestLevelLimit = builder.comment("Should Breaker & Extruder Mk1 Modules respect the harvest level of the pickaxe used to craft them? (e.g. craft with an Iron Pickaxe => can't break Obsidian").translation("gui.config.breakerHarvestLevelLimit").define("breakerHarvestLevelLimit", true);
        builder.pop();
        builder.push("Router");
        this.router.baseTickRate = builder.comment("Base tick interval (in server ticks) for a router; router will run this often").translation("modularrouters.gui.config.baseTickRate").defineInRange("baseTickRate", 20, 1, Integer.MAX_VALUE);
        this.router.ticksPerUpgrade = builder.comment("Number of ticks by which 1 Speed Upgrade will reduce the router's tick interval").translation("modularrouters.gui.config.ticksPerUpgrade").defineInRange("ticksPerUpgrade", 2, 1, Integer.MAX_VALUE);
        this.router.hardMinTickRate = builder.comment("Hard minimum tick interval for a router regardless of Speed Upgrades").translation("gui.config.hardMinTickRate").defineInRange("hardMinTickRate", 2, 1, Integer.MAX_VALUE);
        this.router.ecoTimeout = builder.comment("Router with eco mode enabled will go into low-power mode if idle for this many server ticks").translation("modularrouters.gui.config.ecoTimeout").defineInRange("ecoTimeout", 100, 1, Integer.MAX_VALUE);
        this.router.lowPowerTickRate = builder.comment("Tick interval for an eco-mode router which has gone into low-power mode").translation("modularrouters.gui.config.lowPowerTickRate").defineInRange("lowPowerTickRate", 100, 1, Integer.MAX_VALUE);
        this.router.fluidBaseTransferRate = builder.comment("Base fluid transfer rate (mB/t in each direction) for a router").translation("gui.config.fluidBaseTransferRate").defineInRange("fluidBaseTransferRate", 50, 1, Integer.MAX_VALUE);
        this.router.fluidMaxTransferRate = builder.comment("Max fluid transfer rate (mB/t in each direction) for a router").translation("modularrouters.gui.config.baseTickRate").defineInRange("fluidMaxTransferRate", 400, 1, Integer.MAX_VALUE);
        this.router.mBperFluidUpgade = builder.comment("Fluid transfer rate increase per Fluid Transfer Upgrade").translation("gui.config.mBperFluidUpgade").defineInRange("mBperFluidUpgade", 10, 1, Integer.MAX_VALUE);
        this.router.fePerEnergyUpgrade = builder.comment("FE capacity per Energy Upgrade").translation("gui.config.fePerEnergyUpgrade").defineInRange("fePerEnergyUpgrade", 50000, 1, Integer.MAX_VALUE);
        this.router.feXferPerEnergyUpgrade = builder.comment("FE transfer rate (FE/t) per Energy Upgrade").translation("gui.config.feXferPerEnergyUpgrade").defineInRange("feXferPerEnergyUpgrade", 1000, 1, Integer.MAX_VALUE);
        this.router.blockBreakXPDrops = builder.comment("Should block-breaking modules drop XP where appropriate? (ore mining etc.)").translation("gui.config.blockBreakXPDrops").define("blockBreakXPDrops", true);
        builder.pop();
        builder.push("Energy Costs");
        this.energyCosts.activatorModuleEnergyCost = builder.comment("Energy cost (FE) to run one right-click operation for the Activator Module").translation("modularrouters.gui.config.activatorModuleEnergyCost").defineInRange("activatorModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.activatorModuleEnergyCostAttack = builder.comment("Energy cost (FE) to run one left-click (attack) operation for the Activator Module").translation("modularrouters.gui.config.activatorModuleEnergyCostAttack").defineInRange("activatorModuleEnergyCostAttack", 150, 0, Integer.MAX_VALUE);
        this.energyCosts.breakerModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Breaker Module").translation("modularrouters.gui.config.breakerModuleEnergyCost").defineInRange("breakerModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.detectorModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Detector Module").translation("modularrouters.gui.config.detectorModuleEnergyCost").defineInRange("detectorModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.distributorModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Distributor Module").translation("modularrouters.gui.config.distributorModuleEnergyCost").defineInRange("distributorModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.dropperModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Dropper Module").translation("modularrouters.gui.config.dropperModuleEnergyCost").defineInRange("dropperModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.energydistributorModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Energy Distributor Module").translation("modularrouters.gui.config.energydistributorModuleEnergyCost").defineInRange("energydistributorModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.energyoutputModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Energy Output Module").translation("modularrouters.gui.config.energyoutputModuleEnergyCost").defineInRange("energyoutputModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.extruderModule1EnergyCost = builder.comment("Energy cost (FE) to run one operation for the Extruder Module Mk1").translation("modularrouters.gui.config.extruderModule1EnergyCost").defineInRange("extruderModule1EnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.extruderModule2EnergyCost = builder.comment("Energy cost (FE) to run one operation for the Extruder Module Mk2").translation("modularrouters.gui.config.extruderModule2EnergyCost").defineInRange("extruderModule2EnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.flingerModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Flinger Module").translation("modularrouters.gui.config.flingerModuleEnergyCost").defineInRange("flingerModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.fluidModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Fluid Module Mk1").translation("modularrouters.gui.config.fluidModuleEnergyCost").defineInRange("fluidModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.fluidModule2EnergyCost = builder.comment("Energy cost (FE) to run one operation for the Fluid Module Mk2").translation("modularrouters.gui.config.fluidModule2EnergyCost").defineInRange("fluidModule2EnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.placerModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Placer Module").translation("modularrouters.gui.config.placerModuleEnergyCost").defineInRange("placerModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.playerModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Player Module").translation("modularrouters.gui.config.playerModuleEnergyCost").defineInRange("playerModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.pullerModule1EnergyCost = builder.comment("Energy cost (FE) to run one operation for the Puller Module Mk1").translation("modularrouters.gui.config.pullerModule1EnergyCost").defineInRange("pullerModule1EnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.pullerModule2EnergyCost = builder.comment("Energy cost (FE) to run one operation for the Puller Module Mk2").translation("modularrouters.gui.config.pullerModule2EnergyCost").defineInRange("pullerModule2EnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.senderModule1EnergyCost = builder.comment("Energy cost (FE) to run one operation for the Sender Module Mk1").translation("modularrouters.gui.config.senderModule1EnergyCost").defineInRange("senderModule1EnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.senderModule2EnergyCost = builder.comment("Energy cost (FE) to run one operation for the Sender Module Mk2").translation("modularrouters.gui.config.senderModule2EnergyCost").defineInRange("senderModule2EnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.senderModule3EnergyCost = builder.comment("Energy cost (FE) to run one operation for the Sender Module Mk3").translation("modularrouters.gui.config.senderModule3EnergyCost").defineInRange("senderModule3EnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.vacuumModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Vacuum Module").translation("modularrouters.gui.config.vacuumModuleEnergyCost").defineInRange("vacuumModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        this.energyCosts.voidModuleEnergyCost = builder.comment("Energy cost (FE) to run one operation for the Void Module").translation("modularrouters.gui.config.voidModuleEnergyCost").defineInRange("voidModuleEnergyCost", 0, 0, Integer.MAX_VALUE);
        builder.pop();
    }

    public static class Module {
        public ForgeConfigSpec.IntValue sender1BaseRange;
        public ForgeConfigSpec.IntValue sender1MaxRange;
        public ForgeConfigSpec.IntValue sender2BaseRange;
        public ForgeConfigSpec.IntValue sender2MaxRange;
        public ForgeConfigSpec.IntValue vacuumBaseRange;
        public ForgeConfigSpec.IntValue vacuumMaxRange;
        public ForgeConfigSpec.IntValue extruder1BaseRange;
        public ForgeConfigSpec.IntValue extruder1MaxRange;
        public ForgeConfigSpec.IntValue extruder2BaseRange;
        public ForgeConfigSpec.IntValue extruder2MaxRange;
        public ForgeConfigSpec.IntValue puller2BaseRange;
        public ForgeConfigSpec.IntValue puller2MaxRange;
        public ForgeConfigSpec.IntValue fluid2BaseRange;
        public ForgeConfigSpec.IntValue fluid2MaxRange;
        public ForgeConfigSpec.BooleanValue senderParticles;
        public ForgeConfigSpec.BooleanValue pullerParticles;
        public ForgeConfigSpec.BooleanValue placerParticles;
        public ForgeConfigSpec.BooleanValue breakerParticles;
        public ForgeConfigSpec.BooleanValue vacuumParticles;
        public ForgeConfigSpec.BooleanValue flingerEffects;
        public ForgeConfigSpec.BooleanValue extruderSound;
        public ForgeConfigSpec.BooleanValue extruderPushEntities;
        public ForgeConfigSpec.BooleanValue breakerHarvestLevelLimit;
    }

    public static class Router {
        public ForgeConfigSpec.BooleanValue blockBreakXPDrops;
        public ForgeConfigSpec.IntValue baseTickRate;
        public ForgeConfigSpec.IntValue ticksPerUpgrade;
        public ForgeConfigSpec.IntValue hardMinTickRate;
        public ForgeConfigSpec.IntValue ecoTimeout;
        public ForgeConfigSpec.IntValue lowPowerTickRate;
        public ForgeConfigSpec.IntValue fluidBaseTransferRate;
        public ForgeConfigSpec.IntValue fluidMaxTransferRate;
        public ForgeConfigSpec.IntValue mBperFluidUpgade;
        public ForgeConfigSpec.IntValue fePerEnergyUpgrade;
        public ForgeConfigSpec.IntValue feXferPerEnergyUpgrade;
    }

    public static class EnergyCosts {
        public ForgeConfigSpec.IntValue activatorModuleEnergyCost;
        public ForgeConfigSpec.IntValue activatorModuleEnergyCostAttack;
        public ForgeConfigSpec.IntValue breakerModuleEnergyCost;
        public ForgeConfigSpec.IntValue detectorModuleEnergyCost;
        public ForgeConfigSpec.IntValue distributorModuleEnergyCost;
        public ForgeConfigSpec.IntValue dropperModuleEnergyCost;
        public ForgeConfigSpec.IntValue energydistributorModuleEnergyCost;
        public ForgeConfigSpec.IntValue energyoutputModuleEnergyCost;
        public ForgeConfigSpec.IntValue extruderModule1EnergyCost;
        public ForgeConfigSpec.IntValue extruderModule2EnergyCost;
        public ForgeConfigSpec.IntValue flingerModuleEnergyCost;
        public ForgeConfigSpec.IntValue fluidModuleEnergyCost;
        public ForgeConfigSpec.IntValue fluidModule2EnergyCost;
        public ForgeConfigSpec.IntValue placerModuleEnergyCost;
        public ForgeConfigSpec.IntValue playerModuleEnergyCost;
        public ForgeConfigSpec.IntValue pullerModule1EnergyCost;
        public ForgeConfigSpec.IntValue pullerModule2EnergyCost;
        public ForgeConfigSpec.IntValue senderModule1EnergyCost;
        public ForgeConfigSpec.IntValue senderModule2EnergyCost;
        public ForgeConfigSpec.IntValue senderModule3EnergyCost;
        public ForgeConfigSpec.IntValue vacuumModuleEnergyCost;
        public ForgeConfigSpec.IntValue voidModuleEnergyCost;
    }
}

