/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.block;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import me.desht.modularrouters.block.BlockCamo;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.core.ModBlockEntities;
import me.desht.modularrouters.core.ModItems;
import me.desht.modularrouters.core.ModSounds;
import me.desht.modularrouters.logic.RouterRedstoneBehaviour;
import me.desht.modularrouters.network.PacketHandler;
import me.desht.modularrouters.network.RouterSettingsMessage;
import me.desht.modularrouters.network.RouterUpgradesSyncMessage;
import me.desht.modularrouters.util.InventoryUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;

public class ModularRouterBlock
extends BlockCamo
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionProperty.m_61546_((String)"facing", (Predicate)Direction.Plane.HORIZONTAL);
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final BooleanProperty CAN_EMIT = BooleanProperty.m_61465_((String)"can_emit");

    public ModularRouterBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)CAN_EMIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, ACTIVE, CAN_EMIT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction dir = ctx.m_43723_() == null ? ctx.m_43719_() : Direction.m_122364_((double)ctx.m_43723_().m_146908_()).m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)dir);
    }

    @Override
    public VoxelShape getUncamouflagedShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext ctx) {
        return Shapes.m_83144_();
    }

    public boolean shouldDisplayFluidOverlay(BlockState state, BlockAndTintGetter world, BlockPos pos, FluidState fluidState) {
        return true;
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            world.m_141902_(pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> {
                InventoryUtils.dropInventoryItems(world, pos, router.getBuffer());
                world.m_46717_(pos, (Block)this);
                super.m_6810_(state, world, pos, newState, isMoving);
            });
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level world, BlockPos pos) {
        return world.m_141902_(pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).map(router -> ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)router.getBuffer())).orElse(0);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter player, List<Component> tooltip, TooltipFlag advanced) {
        if (stack.m_41782_()) {
            CompoundTag compound = stack.m_41783_().m_128469_("BlockEntityTag");
            tooltip.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.routerConfigured", new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC}));
            if (compound.m_128441_("Modules")) {
                ArrayList<MutableComponent> moduleText = new ArrayList<MutableComponent>();
                ItemStackHandler modulesHandler = new ItemStackHandler(9);
                modulesHandler.deserializeNBT(compound.m_128469_("Modules"));
                for (int i = 0; i < modulesHandler.getSlots(); ++i) {
                    ItemStack moduleStack = modulesHandler.getStackInSlot(i);
                    if (moduleStack.m_41619_()) continue;
                    moduleText.add(new TextComponent("\u2022 ").m_7220_(moduleStack.m_41786_()).m_130940_(ChatFormatting.AQUA));
                }
                if (!moduleText.isEmpty()) {
                    tooltip.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.moduleCount", moduleText.size()).m_130940_(ChatFormatting.YELLOW));
                    tooltip.addAll(moduleText);
                }
            }
            if (compound.m_128441_("Upgrades")) {
                ItemStackHandler upgradesHandler = new ItemStackHandler();
                upgradesHandler.deserializeNBT(compound.m_128469_("Upgrades"));
                ArrayList<MutableComponent> upgradeText = new ArrayList<MutableComponent>();
                int nUpgrades = 0;
                for (int i = 0; i < upgradesHandler.getSlots(); ++i) {
                    ItemStack upgradeStack = upgradesHandler.getStackInSlot(i);
                    if (upgradeStack.m_41619_()) continue;
                    nUpgrades += upgradeStack.m_41613_();
                    upgradeText.add(new TextComponent("\u2022 " + upgradeStack.m_41613_() + " x ").m_7220_(upgradeStack.m_41786_()).m_130940_(ChatFormatting.AQUA));
                }
                if (!upgradeText.isEmpty()) {
                    tooltip.add((Component)ClientUtil.xlate("modularrouters.itemText.misc.upgradeCount", nUpgrades).m_130940_(ChatFormatting.YELLOW));
                    tooltip.addAll(upgradeText);
                }
            }
            if (compound.m_128441_("Redstone")) {
                try {
                    RouterRedstoneBehaviour rrb = RouterRedstoneBehaviour.valueOf(compound.m_128461_("Redstone"));
                    tooltip.add((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.redstone.label", new Object[0]).m_130946_(": ").m_130940_(ChatFormatting.YELLOW).m_7220_((Component)ClientUtil.xlate("modularrouters.guiText.tooltip.redstone." + rrb, new Object[0]).m_130940_(ChatFormatting.RED)));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult blockRayTraceResult) {
        if (!player.m_20161_()) {
            return world.m_141902_(pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).map(router -> {
                if (router.isPermitted(player) && !world.f_46443_) {
                    PacketHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new RouterSettingsMessage((ModularRouterBlockEntity)router));
                    PacketHandler.NETWORK.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new RouterUpgradesSyncMessage((ModularRouterBlockEntity)router));
                    NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)router, (BlockPos)pos);
                } else if (!router.isPermitted(player) && world.f_46443_) {
                    player.m_5661_((Component)ClientUtil.xlate("modularrouters.chatText.security.accessDenied", new Object[0]), false);
                    player.m_5496_((SoundEvent)ModSounds.ERROR.get(), 1.0f, 1.0f);
                }
                return InteractionResult.SUCCESS;
            }).orElse(InteractionResult.FAIL);
        }
        return InteractionResult.PASS;
    }

    @Override
    public boolean m_7899_(BlockState state) {
        return (Boolean)state.m_61143_((Property)CAN_EMIT);
    }

    @Override
    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.m_141902_(pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).map(router -> {
            int l = router.getRedstoneLevel(side, false);
            return l < 0 ? super.m_6378_(blockState, blockAccess, pos, side) : l;
        }).orElse(0);
    }

    @Override
    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return blockAccess.m_141902_(pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).map(router -> {
            int l = router.getRedstoneLevel(side, true);
            return l < 0 ? super.m_6376_(blockState, blockAccess, pos, side) : l;
        }).orElse(0);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean b) {
        worldIn.m_141902_(pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> {
            router.checkForRedstonePulse();
            router.notifyModules();
        });
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return world.m_141902_(pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).map(router -> router.getUpgradeCount((Item)ModItems.BLAST_UPGRADE.get()) <= 0 && super.canEntityDestroy(state, world, pos, entity)).orElse(true);
    }

    @Override
    public float getExplosionResistance(BlockState state, BlockGetter world, BlockPos pos, Explosion explosion) {
        return world.m_141902_(pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).map(router -> Float.valueOf(router.getUpgradeCount((Item)ModItems.BLAST_UPGRADE.get()) > 0 ? 20000.0f : this.f_60444_)).orElse(Float.valueOf(0.0f)).floatValue();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new ModularRouterBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return (level1, blockPos, blockState, t) -> {
            if (t instanceof ModularRouterBlockEntity) {
                ModularRouterBlockEntity router = (ModularRouterBlockEntity)t;
                if (level1.m_5776_()) {
                    router.clientTick();
                } else {
                    router.serverTick();
                }
            }
        };
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)mirror.m_54848_((Direction)state.m_61143_((Property)FACING)));
    }
}

