/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.lib.xz;

import java.io.InputStream;
import me.lucko.spark.lib.xz.ArrayCache;
import me.lucko.spark.lib.xz.BCJCoder;
import me.lucko.spark.lib.xz.FilterDecoder;
import me.lucko.spark.lib.xz.SimpleInputStream;
import me.lucko.spark.lib.xz.UnsupportedOptionsException;
import me.lucko.spark.lib.xz.simple.ARM;
import me.lucko.spark.lib.xz.simple.ARMThumb;
import me.lucko.spark.lib.xz.simple.IA64;
import me.lucko.spark.lib.xz.simple.PowerPC;
import me.lucko.spark.lib.xz.simple.SPARC;
import me.lucko.spark.lib.xz.simple.SimpleFilter;
import me.lucko.spark.lib.xz.simple.X86;

class BCJDecoder
extends BCJCoder
implements FilterDecoder {
    private final long filterID;
    private final int startOffset;

    BCJDecoder(long l, byte[] byArray) throws UnsupportedOptionsException {
        assert (BCJDecoder.isBCJFilterID(l));
        this.filterID = l;
        if (byArray.length == 0) {
            this.startOffset = 0;
        } else if (byArray.length == 4) {
            int n = 0;
            for (int i = 0; i < 4; ++i) {
                n |= (byArray[i] & 0xFF) << i * 8;
            }
            this.startOffset = n;
        } else {
            throw new UnsupportedOptionsException("Unsupported BCJ filter properties");
        }
    }

    public int getMemoryUsage() {
        return SimpleInputStream.getMemoryUsage();
    }

    public InputStream getInputStream(InputStream inputStream, ArrayCache arrayCache) {
        SimpleFilter simpleFilter = null;
        if (this.filterID == 4L) {
            simpleFilter = new X86(false, this.startOffset);
        } else if (this.filterID == 5L) {
            simpleFilter = new PowerPC(false, this.startOffset);
        } else if (this.filterID == 6L) {
            simpleFilter = new IA64(false, this.startOffset);
        } else if (this.filterID == 7L) {
            simpleFilter = new ARM(false, this.startOffset);
        } else if (this.filterID == 8L) {
            simpleFilter = new ARMThumb(false, this.startOffset);
        } else if (this.filterID == 9L) {
            simpleFilter = new SPARC(false, this.startOffset);
        } else assert (false);
        return new SimpleInputStream(inputStream, simpleFilter);
    }
}

