/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.network;

import com.codetaylor.mc.enercell.block.entity.EnercellBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class ClientboundEnercellChargeModeMessage {
    public final BlockPos blockPos;
    public final EnercellBlockEntity.ChargeMode chargeMode;

    public ClientboundEnercellChargeModeMessage(BlockPos blockPos, EnercellBlockEntity.ChargeMode chargeMode) {
        this.blockPos = blockPos;
        this.chargeMode = chargeMode;
    }

    public static void encode(ClientboundEnercellChargeModeMessage message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.blockPos);
        buffer.writeByte((int)message.chargeMode.getSerializationId());
    }

    public static ClientboundEnercellChargeModeMessage decode(FriendlyByteBuf buffer) {
        BlockPos blockPos = buffer.m_130135_();
        EnercellBlockEntity.ChargeMode chargeMode = EnercellBlockEntity.ChargeMode.from(buffer.readByte());
        return new ClientboundEnercellChargeModeMessage(blockPos, chargeMode);
    }

    public static void handle(ClientboundEnercellChargeModeMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            Minecraft minecraft = Minecraft.m_91087_();
            ClientLevel level = minecraft.f_91073_;
            if (level == null) {
                return;
            }
            BlockEntity blockEntity = level.m_7702_(message.blockPos);
            if (!(blockEntity instanceof EnercellBlockEntity)) {
                return;
            }
            EnercellBlockEntity enercellBlockEntity = (EnercellBlockEntity)blockEntity;
            enercellBlockEntity.setChargeMode(message.chargeMode);
        });
        context.setPacketHandled(true);
    }
}

