/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.config;

import com.codetaylor.mc.enercell.EnercellMod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public abstract class Config {
    private static final Gson GSON = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().enableComplexMapKeySerialization().setPrettyPrinting().create();
    protected String root = "config%s%s%s".formatted(File.separator, "enercell", File.separator);
    protected String extension = ".json";

    public void generateConfig() {
        this.reset();
        try {
            this.writeConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File getConfigFile() {
        return new File(this.root + this.getName() + this.extension);
    }

    public abstract String getName();

    public String toString() {
        return this.getName();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Config> T readConfig() {
        EnercellMod.LOGGER.info("Reading config: " + this.getName());
        try (FileReader reader = new FileReader(this.getConfigFile());){
            Config config = (Config)GSON.fromJson((Reader)reader, this.getClass());
            config.onLoad(this);
            if (!config.isValid()) {
                EnercellMod.LOGGER.error("Invalid config {}, using defaults", (Object)this);
                config.reset();
            }
            Config config2 = config;
            return (T)config2;
        }
        catch (Exception e2) {
            EnercellMod.LOGGER.warn("Config file {} not found, generating new", (Object)this);
            this.generateConfig();
            return (T)this;
        }
    }

    protected boolean isValid() {
        return true;
    }

    protected void onLoad(Config oldConfigInstance) {
    }

    protected abstract void reset();

    public void writeConfig() throws IOException {
        File cfgFile = this.getConfigFile();
        File dir = cfgFile.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            return;
        }
        if (!cfgFile.exists() && !cfgFile.createNewFile()) {
            return;
        }
        FileWriter writer = new FileWriter(cfgFile);
        GSON.toJson((Object)this, (Appendable)writer);
        writer.flush();
        writer.close();
    }
}

