/*
 * Decompiled with CFR 0.152.
 */
package com.codetaylor.mc.enercell.block;

import com.codetaylor.mc.enercell.block.entity.EnercellBlockEntity;
import com.codetaylor.mc.enercell.init.ModBlocks;
import com.codetaylor.mc.enercell.init.ModConfigs;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnercellBlock
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape)Block.m_49796_((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));

    public EnercellBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60999_().m_60913_(5.0f, 6.0f).m_60918_(SoundType.f_56743_).m_60955_());
    }

    @ParametersAreNonnullByDefault
    @Nonnull
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return ModBlocks.ENERCELL_BLOCK_ENTITY.m_155264_(blockPos, blockState);
    }

    @ParametersAreNonnullByDefault
    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        if (level.f_46443_ || blockEntityType != ModBlocks.ENERCELL_BLOCK_ENTITY) {
            return null;
        }
        return EnercellBlock.getTicker(blockEntityType, ModBlocks.ENERCELL_BLOCK_ENTITY, EnercellBlockEntity::tick);
    }

    @javax.annotation.Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> getTicker(BlockEntityType<A> type, BlockEntityType<E> targetType, BlockEntityTicker<? super E> ticker) {
        return targetType == type ? ticker : null;
    }

    @ParametersAreNonnullByDefault
    @NotNull
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        EnercellBlockEntity enercellBlockEntity;
        block5: {
            block4: {
                if (level.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                BlockEntity blockEntity = level.m_7702_(blockPos);
                if (!(blockEntity instanceof EnercellBlockEntity)) break block4;
                enercellBlockEntity = (EnercellBlockEntity)blockEntity;
                if (player instanceof ServerPlayer) break block5;
            }
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        NetworkHooks.openGui((ServerPlayer)serverPlayer, (MenuProvider)enercellBlockEntity, buffer -> buffer.m_130064_(blockPos));
        return InteractionResult.SUCCESS;
    }

    @ParametersAreNonnullByDefault
    public void m_5707_(Level level, BlockPos blockPos, BlockState state, Player player) {
        super.m_5707_(level, blockPos, state, player);
        if (level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(blockPos);
        if (blockEntity instanceof EnercellBlockEntity) {
            CompoundTag tag;
            ServerPlayer serverPlayer;
            EnercellBlockEntity enercellBlockEntity = (EnercellBlockEntity)blockEntity;
            ItemStackHandler stackHandler = enercellBlockEntity.getStackHandler();
            for (int i = 0; i < stackHandler.getSlots(); ++i) {
                Containers.m_18992_((Level)level, (double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), (ItemStack)stackHandler.getStackInSlot(i));
            }
            if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).m_7500_()) {
                return;
            }
            ItemStack itemstack = new ItemStack((ItemLike)this);
            if (ModConfigs.ENERCELL != null && !(tag = enercellBlockEntity.m_187482_()).m_128456_()) {
                itemstack.m_41700_("BlockEntityTag", (Tag)tag);
            }
            ItemEntity itementity = new ItemEntity(level, (double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5, itemstack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
        }
    }
}

