## Scaling

- [Attribute scaling](#attribute-scaling)
- [Supported mods](#supported-mods)

### Attribute Scaling
CPM can apply some scaling settings using [attributes](https://minecraft.wiki/w/Attribute). See the list below for the supported attributes per Minecraft version:  
| Scaling Option | 1.6 - 1.8 | 1.10 | 1.12 | 1.14 - 1.17 | 1.18 - 1.20.4 | 1.20.5 |
| --- | --- | --- | --- | --- | --- | --- |
| Entity Scaling |  No | No | No | No | No | Yes |
| Motion Scale |  Yes | Yes | Yes | Yes | Yes | Yes |
| Step Height |  No | No | No | No | Yes | Yes |
| Flight Speed |  No | No | Yes | Yes | Yes | Yes |
| Fall Damage Scale |  No | No | No | No | No | Yes |
| Reach |  No | No | Yes | Yes | Yes | Yes |
| Mining Speed |  No | No | No | No | No | Yes |
| Attack Speed |  No | Yes | Yes | Yes | Yes | Yes |
| Attack Knockback |  No | No | No | Yes | Yes | Yes |
| Attack Damage Scale |  Yes | Yes | Yes | Yes | Yes | Yes |
| Defense Scale |  No | Yes | Yes | Yes | Yes | Yes |
| Health |  Yes | Yes | Yes | Yes | Yes | Yes |
| Mob Visibility |  Yes | Yes | Yes | Yes | Yes | Yes |
| Jump Height |  No | No | No | No | No | Yes |
| Knockback Resist Scale |  Yes | Yes | Yes | Yes | Yes | Yes |
| Safe Fall Distance Scale |  No | No | No | No | No | Yes |
| Scaling Option | 1.6 - 1.8 | 1.10 | 1.12 | 1.14 - 1.17 | 1.18 - 1.20.4 | 1.20.5 |

Method name: `attribute`  

### Supported mods

#### Pehkui
Only on 1.14+  
Player size, health, movement, and various attributes can be scaled:  
Method name: `pehkui`  
[CurseForge](https://www.curseforge.com/minecraft/mc-mods/pehkui), [Modrinth](https://modrinth.com/mod/pehkui)  

#### Chiseled Me
Only on 1.10.2 and 1.12.2  
Only supports Entity Scaling  
Method name: `chiseledme`  
[CurseForge](https://www.curseforge.com/minecraft/mc-mods/chiseled-me)  

#### ArtemisLib
Only on 1.12.2  
Only supports Entity Scaling, Width, Height  
Method name: `artemislib`  
[CurseForge](https://www.curseforge.com/minecraft/mc-mods/artemislib)  

## Server settings
Some attributes' scaling is disabled by default and have to be enabled using the [/cpm command](https://github.com/tom5454/CustomPlayerModels/wiki/The--cpm-command#scaling) on the server.  

