/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.gui;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.gui.util.FlowLayout;
import com.tom.cpl.gui.util.TabFocusHandler;
import com.tom.cpl.math.Box;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.interpolator.InterpolatorType;
import com.tom.cpm.shared.editor.Editor;
import com.tom.cpm.shared.editor.anim.AnimationProperties;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.gui.popup.AnimationSettingsPopup;
import com.tom.cpmoscc.OSCMapping;
import com.tom.cpmoscc.gui.OSCDataPanel;
import com.tom.cpmoscc.gui.OSCSelectPopup;

public class OSCWizardPopup
extends PopupPanel {
    private TextField pathField;
    private TextField firstArgField;
    private Spinner argId;
    private Spinner min;
    private Spinner max;
    private Checkbox chbxValRange;
    private Button editSel;

    public OSCWizardPopup(EditorGui eg) {
        super(eg.getGui());
        TabFocusHandler tabHandler = new TabFocusHandler(this.gui);
        this.setBounds(new Box(0, 0, 240, 300));
        FlowLayout layout = new FlowLayout((Panel)this, 5, 1);
        Button selectFromIn = new Button(this.gui, this.gui.i18nFormat("osc-button.cpmosc.selectFromInputs", new Object[0]), () -> eg.openPopup((PopupPanel)new OSCSelectPopup((Frame)eg, this::loadChannel)));
        selectFromIn.setBounds(new Box(5, 0, 180, 20));
        this.addElement((GuiElement)selectFromIn);
        Button importFromSelected = new Button(this.gui, this.gui.i18nFormat("osc-button.cpmosc.importFromSelected", new Object[0]), () -> {
            OSCMapping mapping;
            EditorAnim anim = eg.getEditor().selectedAnim;
            if (anim != null && (mapping = new OSCMapping(anim.displayName)).getOscPacketId() != null) {
                this.loadChannel(mapping.toChannel());
            }
        });
        importFromSelected.setBounds(new Box(5, 0, 180, 20));
        importFromSelected.setEnabled(eg.getEditor().selectedAnim != null);
        this.addElement((GuiElement)importFromSelected);
        this.addElement(new Label(this.gui, this.gui.i18nFormat("osc-label.cpmosc.oscPath", new Object[0])).setBounds(new Box(5, 0, 200, 10)));
        this.pathField = new TextField(this.gui);
        this.pathField.setBounds(new Box(5, 0, 160, 20));
        this.addElement((GuiElement)this.pathField);
        tabHandler.add((TabFocusHandler.Focusable)this.pathField);
        Label lblFirstArg = new Label(this.gui, this.gui.i18nFormat("osc-label.cpmosc.oscFirstArg", new Object[0]));
        lblFirstArg.setBounds(new Box(5, 0, 200, 10));
        lblFirstArg.setTooltip(new Tooltip((Frame)eg, this.gui.i18nFormat("osc-tooltip.cpmosc.oscFirstArg", new Object[0])));
        this.addElement((GuiElement)lblFirstArg);
        this.firstArgField = new TextField(this.gui);
        this.firstArgField.setBounds(new Box(5, 0, 160, 20));
        this.addElement((GuiElement)this.firstArgField);
        tabHandler.add((TabFocusHandler.Focusable)this.firstArgField);
        this.addElement(new Label(this.gui, this.gui.i18nFormat("osc-label.cpmosc.oscArgId", new Object[0])).setBounds(new Box(5, 0, 200, 10)));
        this.argId = new Spinner(this.gui);
        this.argId.setBounds(new Box(5, 10, 160, 20));
        this.argId.setDp(0);
        this.argId.addChangeListener(() -> {
            if (this.argId.getValue() < 0.0f) {
                this.argId.setValue(0.0f);
            }
        });
        this.addElement((GuiElement)this.argId);
        tabHandler.add((TabFocusHandler.Focusable)this.argId);
        this.chbxValRange = new Checkbox(this.gui, this.gui.i18nFormat("osc-label.cpmosc.valueRange", new Object[0]));
        this.chbxValRange.setBounds(new Box(5, 0, 160, 20));
        this.addElement((GuiElement)this.chbxValRange);
        Panel p = new Panel(this.gui);
        p.setBounds(new Box(0, 0, 160, 20));
        this.addElement((GuiElement)p);
        this.min = new Spinner(this.gui);
        this.min.setBounds(new Box(5, 0, 70, 20));
        this.min.setDp(2);
        p.addElement((GuiElement)this.min);
        tabHandler.add((TabFocusHandler.Focusable)this.min);
        this.min.setEnabled(false);
        p.addElement(new Label(this.gui, "~").setBounds(new Box(77, 5, 10, 10)));
        this.max = new Spinner(this.gui);
        this.max.setBounds(new Box(85, 0, 70, 20));
        this.max.setDp(2);
        p.addElement((GuiElement)this.max);
        tabHandler.add((TabFocusHandler.Focusable)this.max);
        this.max.setEnabled(false);
        this.max.setValue(1.0f);
        this.chbxValRange.setAction(() -> {
            boolean v = !this.chbxValRange.isSelected();
            this.chbxValRange.setSelected(v);
            this.min.setEnabled(v);
            this.max.setEnabled(v);
        });
        p = new Panel(this.gui);
        p.setBounds(new Box(0, 0, 240, 20));
        this.addElement((GuiElement)p);
        FlowLayout blayout = new FlowLayout(p, 5, 0);
        Button ok = new Button(this.gui, this.gui.i18nFormat("osc-button.cpmosc.createNew", new Object[0]), () -> {
            this.close();
            eg.getEditor().addNewAnim(new AnimationProperties(null, this.createPath(), AnimationType.LAYER, true, false, InterpolatorType.POLY_LOOP, true, false));
            eg.openPopup((PopupPanel)new AnimationSettingsPopup(this.gui, eg.getEditor(), true));
        });
        ok.setBounds(new Box(0, 0, 80, 20));
        p.addElement((GuiElement)ok);
        if (eg.getEditor().selectedAnim != null) {
            Button editSel = new Button(this.gui, this.gui.i18nFormat("osc-button.cpmosc.editSelected", new Object[0]), () -> {
                this.close();
                Editor e = eg.getEditor();
                if (e.selectedAnim != null) {
                    eg.getEditor().action("edit", "action.cpm.anim").updateValueOp((Object)e.selectedAnim, (Object)e.selectedAnim.displayName, (Object)this.createPath(), (a, b) -> {
                        a.displayName = b;
                    }).execute();
                }
            });
            editSel.setBounds(new Box(0, 0, 80, 20));
            p.addElement((GuiElement)editSel);
        }
        Button copyName = new Button(this.gui, this.gui.i18nFormat("osc-button.cpmosc.copyName", new Object[0]), () -> {
            this.close();
            this.gui.setClipboardText(this.createPath());
        });
        copyName.setBounds(new Box(0, 0, 80, 20));
        p.addElement((GuiElement)copyName);
        blayout.setSize(240);
        layout.run();
        this.addElement((GuiElement)tabHandler);
    }

    private void loadChannel(OSCDataPanel.OSCChannel c) {
        this.pathField.setText(c.address);
        if (c.arg1 != null) {
            this.firstArgField.setText(c.arg1);
        } else {
            this.firstArgField.setText("");
        }
        this.argId.setValue((float)c.argId);
        this.min.setValue(c.min);
        this.max.setValue(c.max);
        this.chbxValRange.setSelected(true);
        this.min.setEnabled(true);
        this.max.setEnabled(true);
    }

    private String createPath() {
        StringBuilder sb = new StringBuilder("osc:");
        sb.append(this.pathField.getText());
        if (this.argId.getValue() != 0.0f || !this.firstArgField.getText().isEmpty()) {
            sb.append('[');
            boolean col = false;
            if (this.argId.getValue() != 0.0f) {
                sb.append((int)this.argId.getValue());
                col = true;
            }
            if (!this.firstArgField.getText().isEmpty()) {
                if (col) {
                    sb.append(':');
                }
                sb.append(this.firstArgField.getText());
            }
            sb.append(']');
        }
        if (this.chbxValRange.isSelected()) {
            sb.append('(');
            sb.append(String.format("%.2f", Float.valueOf(this.min.getValue())));
            sb.append(':');
            sb.append(String.format("%.2f", Float.valueOf(this.max.getValue())));
            sb.append(')');
        }
        return sb.toString();
    }

    public String getTitle() {
        return this.gui.i18nFormat("osc-button.cpmosc.oscWizard", new Object[0]);
    }
}

