/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.gui;

import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Checkbox;
import com.tom.cpl.gui.elements.GuiElement;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Spinner;
import com.tom.cpl.gui.elements.TextField;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpmoscc.CPMOSC;
import com.tom.cpmoscc.gui.OSCDataPanel;

public class OSCSettingsPopup
extends PopupPanel {
    private OSCDataPanel data;

    public OSCSettingsPopup(EditorGui eg) {
        super(eg.getGui());
        Box b = eg.getBounds();
        this.setBounds(new Box(0, 0, b.w - 50, b.h - 50));
        Checkbox chbxEn = new Checkbox(this.gui, this.gui.i18nFormat("osc-label.cpmosc.oscEnable", new Object[0]));
        chbxEn.setBounds(new Box(5, 5, 100, 18));
        chbxEn.setSelected(ModConfig.getCommonConfig().getBoolean("cpmosc_enable", false));
        this.addElement((GuiElement)chbxEn);
        this.addElement(new Label(this.gui, this.gui.i18nFormat("osc-label.cpmosc.oscPort", new Object[0])).setBounds(new Box(106, 10, 20, 10)));
        Spinner oscPort = new Spinner(this.gui);
        oscPort.setValue((float)ModConfig.getCommonConfig().getInt("cpmosc_receive_port", 9000));
        oscPort.setDp(0);
        oscPort.setEnabled(chbxEn.isSelected());
        chbxEn.setAction(() -> {
            boolean v = !chbxEn.isSelected();
            chbxEn.setSelected(v);
            oscPort.setEnabled(v);
        });
        oscPort.setBounds(new Box(140, 4, 50, 20));
        oscPort.addChangeListener(() -> {
            int r = MathHelper.clamp((int)((int)oscPort.getValue()), (int)1, (int)65535);
            if (Math.abs(oscPort.getValue() - (float)r) > 0.1f) {
                oscPort.setValue((float)r);
            }
        });
        this.addElement((GuiElement)oscPort);
        Checkbox chbxEnT = new Checkbox(this.gui, this.gui.i18nFormat("osc-label.cpmosc.oscEnableTransmit", new Object[0]));
        chbxEnT.setBounds(new Box(195, 5, 100, 18));
        chbxEnT.setSelected(ModConfig.getCommonConfig().getBoolean("cpmosc_enable_transmit", false));
        this.addElement((GuiElement)chbxEnT);
        this.addElement(new Label(this.gui, this.gui.i18nFormat("osc-label.cpmosc.oscTransmitAddr", new Object[0])).setBounds(new Box(316, 10, 20, 10)));
        TextField oscTrAddr = new TextField(this.gui);
        oscTrAddr.setText(ModConfig.getCommonConfig().getString("cpmosc_transmit_port", "localhost:9001"));
        oscTrAddr.setBounds(new Box(360, 4, 100, 20));
        oscTrAddr.setEnabled(chbxEnT.isSelected());
        this.addElement((GuiElement)oscTrAddr);
        chbxEnT.setAction(() -> {
            boolean v = !chbxEnT.isSelected();
            chbxEnT.setSelected(v);
            oscTrAddr.setEnabled(v);
        });
        this.data = new OSCDataPanel(this.gui, null, b.w - 60);
        Button save = new Button(this.gui, this.gui.i18nFormat("button.cpm.saveCfg", new Object[0]), () -> {
            ModConfigFile f = ModConfig.getCommonConfig();
            f.setBoolean("cpmosc_enable", chbxEn.isSelected());
            f.setInt("cpmosc_receive_port", (int)oscPort.getValue());
            f.setBoolean("cpmosc_enable_transmit", chbxEnT.isSelected());
            f.setString("cpmosc_transmit_port", oscTrAddr.getText());
            f.save();
            CPMOSC.resetOsc();
            this.data.reset();
        });
        save.setBounds(new Box(465, 4, 50, 20));
        this.addElement((GuiElement)save);
        ScrollPanel scp = new ScrollPanel(this.gui);
        scp.setDisplay((Panel)this.data);
        scp.setBounds(new Box(5, 25, b.w - 60, b.h - 80));
        this.addElement((GuiElement)scp);
    }

    public String getTitle() {
        return this.gui.i18nFormat("osc-button.cpmosc.oscSettings", new Object[0]);
    }

    public void onClosed() {
        this.data.close();
    }
}

