/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.gui;

import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.MathHelper;
import com.tom.cpmoscc.CPMOSC;
import com.tom.cpmoscc.OSCReceiver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public class OSCDataPanel
extends Panel
implements OSCReceiver.OSCListener {
    private static final int SIZE = 128;
    private Map<String, List<OSCValue>> values = new ConcurrentHashMap<String, List<OSCValue>>();
    private Box hoveredBox;
    private OSCChannel hoveredChannel;
    private Consumer<OSCChannel> select;
    private int w;
    private boolean oscEn;

    public OSCDataPanel(IGui gui, Consumer<OSCChannel> select, int w) {
        super(gui);
        this.select = select;
        this.w = w;
        if (CPMOSC.isEnabled()) {
            CPMOSC.getOsc().setListener(this);
            this.oscEn = true;
        }
        this.setBounds(new Box(0, 0, w, 128));
    }

    public void draw(MouseEvent event, float partialTicks) {
        HashMap<String, List<OSCValue>> values = new HashMap<String, List<OSCValue>>(this.values);
        ArrayList keys = new ArrayList(values.keySet());
        int cols = this.w / 133;
        int rows = MathHelper.ceil((float)((float)keys.size() / (float)cols));
        this.setBounds(new Box(0, 0, cols * 133, Math.max(1, rows) * 143));
        this.gui.pushMatrix();
        this.gui.setPosOffset(this.getBounds());
        this.gui.setupCut();
        if (!this.oscEn) {
            String[] sp = this.gui.i18nFormat("osc-label.cpmosc.oscDisabled", new Object[0]).split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                this.gui.drawText(2, 2 + i * 10, sp[i], this.gui.getColors().label_text_color);
            }
        } else if (values.isEmpty()) {
            String[] sp = this.gui.i18nFormat("osc-label.cpmosc.noOscData", new Object[0]).split("\\\\");
            for (int i = 0; i < sp.length; ++i) {
                this.gui.drawText(2, 2 + i * 10, sp[i], this.gui.getColors().label_text_color);
            }
        } else {
            long time = System.currentTimeMillis();
            for (int i = 0; i < keys.size(); ++i) {
                String key = (String)keys.get(i);
                List args = (List)values.get(key);
                int x = i % cols * 133;
                int y = i / cols * 143;
                this.gui.drawBox(x + 1, y + 1, 128, 128, this.gui.getColors().button_disabled);
                if (args.size() == 1 && ((OSCValue)args.get(0)).binary) {
                    this.gui.drawBox(x + 32, y + 32, 64, 64, this.gui.getColors().button_hover);
                    if (((OSCValue)args.get(0)).value > 0.0f) {
                        this.gui.drawBox(x + 40, y + 40, 48, 48, this.gui.getColors().button_text_color);
                    }
                    int update = 128 - (int)(MathHelper.clamp((float)(time - ((OSCValue)args.get(0)).updateTime), (float)0.0f, (float)500.0f) / 500.0f * 128.0f);
                    Box b = new Box(x + 1, y + 1, 128, 128);
                    if (this.select != null && event.isHovered(b)) {
                        update = 64;
                        this.hoveredBox = b;
                        this.hoveredChannel = new OSCChannel(key, 0, 0.0f, 1.0f);
                    }
                    this.gui.drawBox(x + 1, y + 1, 128, 128, update << 24 | 0xFFFFFF);
                } else if (!args.isEmpty()) {
                    int h = 124 / args.size();
                    for (int j = 0; j < args.size(); ++j) {
                        OSCValue oscValue = (OSCValue)args.get(j);
                        this.gui.drawBox(x + 2, y + 2 + j * h, 126, h, this.gui.getColors().slider_bar);
                        int len = 0;
                        int start = 0;
                        if (oscValue.min == oscValue.max) {
                            len = 126;
                        } else {
                            float zero = -oscValue.min / (oscValue.max - oscValue.min);
                            len = zero < 0.0f || zero > 1.0f ? (int)((oscValue.value - oscValue.min) / (oscValue.max - oscValue.min) * 126.0f) : MathHelper.clamp((int)((int)(Math.abs(oscValue.value / (oscValue.max - oscValue.min)) * 126.0f)), (int)0, (int)126);
                            start = (int)(MathHelper.clamp((float)zero, (float)0.0f, (float)1.0f) * 126.0f);
                            if (oscValue.value < 0.0f) {
                                start -= len;
                            }
                        }
                        this.gui.drawBox(x + 2 + start, y + 2 + j * h, len, h, this.gui.getColors().button_hover);
                        int update = 128 - (int)(MathHelper.clamp((float)(time - oscValue.updateTime), (float)0.0f, (float)500.0f) / 500.0f * 128.0f);
                        Box b = new Box(x + 2, y + 2 + j * h, 126, h);
                        if (this.select != null && event.isHovered(b)) {
                            update = 64;
                            this.hoveredBox = b;
                            this.hoveredChannel = new OSCChannel(key, j, oscValue.min, oscValue.max);
                        }
                        this.gui.drawBox(x + 2, y + 2 + j * h, 126, h, update << 24 | 0xFFFFFF);
                        this.gui.drawText(x + 2, y + 2 + j * h + h / 2, String.format("%.1f", Float.valueOf(oscValue.min)), this.gui.getColors().label_text_color);
                        String v = String.format("%.1f", Float.valueOf(oscValue.value));
                        this.gui.drawText(x + 64 - this.gui.textWidth(v) / 2, y + 2 + j * h + h / 2, v, this.gui.getColors().label_text_color);
                        v = String.format("%.1f", Float.valueOf(oscValue.max));
                        this.gui.drawText(x + 128 - this.gui.textWidth(v), y + 2 + j * h + h / 2, v, this.gui.getColors().label_text_color);
                    }
                }
                if (this.gui.textWidth(key) > 120 && event.isHovered(new Box(x + 3, y + 128 + 2, 128, 10))) {
                    new Tooltip(this.gui.getFrame(), key).set();
                }
                this.gui.drawText(x + 3, y + 128 + 2, key, this.gui.getColors().label_text_color);
            }
        }
        this.gui.popMatrix();
        this.gui.setupCut();
    }

    public void mouseClick(MouseEvent event) {
        if (this.select != null && this.hoveredBox != null && event.isHovered(this.hoveredBox)) {
            event.consume();
            this.select.accept(this.hoveredChannel);
        }
    }

    public void close() {
        if (this.oscEn) {
            CPMOSC.getOsc().setListener(null);
        }
    }

    @Override
    public void onReceive(String address, List<Object> args) {
        if ((args = new ArrayList<Object>(args)).size() > 0 && args.get(0) instanceof String) {
            address = address + " " + args.get(0);
            args.remove(0);
        }
        List as = args.stream().map(a -> {
            if (a instanceof Boolean) {
                return Float.valueOf((Boolean)a != false ? 1.0f : 0.0f);
            }
            if (a instanceof Number) {
                return Float.valueOf(((Number)a).floatValue());
            }
            return null;
        }).filter(a -> a != null).collect(Collectors.toList());
        this.values.compute(address, (__, old) -> {
            if (old == null || old.size() != as.size()) {
                return as.stream().map(OSCValue::new).collect(Collectors.toList());
            }
            for (int i = 0; i < as.size(); ++i) {
                ((OSCValue)old.get(i)).setValue(((Float)as.get(i)).floatValue());
            }
            return old;
        });
    }

    public void reset() {
        this.values.clear();
        if (CPMOSC.isEnabled()) {
            CPMOSC.getOsc().setListener(this);
            this.oscEn = true;
        } else {
            this.oscEn = false;
        }
    }

    public static class OSCChannel {
        public final String address;
        public final String arg1;
        public final int argId;
        public final float min;
        public final float max;

        public OSCChannel(String address, int argId, float min, float max) {
            String[] sp = address.split(" ", 2);
            this.address = sp[0];
            this.arg1 = sp.length > 1 ? sp[1] : null;
            this.argId = argId;
            this.min = min;
            this.max = max;
        }

        public OSCChannel(String address, String arg1, int argId, float min, float max) {
            this.address = address;
            this.arg1 = arg1;
            this.argId = argId;
            this.min = min;
            this.max = max;
        }
    }

    public static class OSCValue {
        private float value;
        private float min;
        private float max;
        private boolean binary;
        private long updateTime;

        public OSCValue(float v) {
            this.value = v;
            if (v == 0.0f || v == 1.0f) {
                this.binary = true;
            }
            this.min = v;
            this.max = v;
            this.updateTime = System.currentTimeMillis();
        }

        public void setValue(float value) {
            this.value = value;
            if (this.binary && value != 0.0f && value != 1.0f) {
                this.binary = false;
            }
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            this.updateTime = System.currentTimeMillis();
        }
    }
}

