/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc.transport;

import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializerAndParserBuilder;
import com.tom.cpmoscc.external.com.illposed.osc.transport.NetworkProtocol;
import com.tom.cpmoscc.external.com.illposed.osc.transport.OSCPort;
import com.tom.cpmoscc.external.com.illposed.osc.transport.OSCPortOut;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class OSCPortOutBuilder {
    private OSCSerializerAndParserBuilder serializerBuilder;
    private SocketAddress remote;
    private SocketAddress local;
    private NetworkProtocol networkProtocol = NetworkProtocol.UDP;

    public OSCPortOut build() throws IOException {
        if (this.remote == null) {
            throw new IllegalArgumentException("Missing remote socket address / port.");
        }
        if (this.local == null) {
            this.local = new InetSocketAddress(OSCPort.generateWildcard(this.remote), 0);
        }
        if (this.serializerBuilder == null) {
            this.serializerBuilder = new OSCSerializerAndParserBuilder();
        }
        return new OSCPortOut(this.serializerBuilder, this.remote, this.local, this.networkProtocol);
    }

    public OSCPortOutBuilder setPort(int port) {
        InetSocketAddress address = new InetSocketAddress(port);
        this.local = address;
        this.remote = address;
        return this;
    }

    public OSCPortOutBuilder setRemotePort(int port) {
        this.remote = new InetSocketAddress(port);
        return this;
    }

    public OSCPortOutBuilder setLocalPort(int port) {
        this.local = new InetSocketAddress(port);
        return this;
    }

    public OSCPortOutBuilder setSocketAddress(SocketAddress address) {
        this.local = address;
        this.remote = address;
        return this;
    }

    public OSCPortOutBuilder setLocalSocketAddress(SocketAddress address) {
        this.local = address;
        return this;
    }

    public OSCPortOutBuilder setRemoteSocketAddress(SocketAddress address) {
        this.remote = address;
        return this;
    }

    public OSCPortOutBuilder setNetworkProtocol(NetworkProtocol protocol) {
        this.networkProtocol = protocol;
        return this;
    }
}

