/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc.transport;

import com.tom.cpmoscc.external.com.illposed.osc.OSCPacket;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializeException;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializerAndParserBuilder;
import com.tom.cpmoscc.external.com.illposed.osc.transport.NetworkProtocol;
import com.tom.cpmoscc.external.com.illposed.osc.transport.OSCPort;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class OSCPortOut
extends OSCPort {
    public OSCPortOut(OSCSerializerAndParserBuilder serializerBuilder, SocketAddress remote, SocketAddress local, NetworkProtocol protocol) throws IOException {
        super(local, remote, serializerBuilder, protocol);
    }

    public OSCPortOut(OSCSerializerAndParserBuilder serializerBuilder, SocketAddress remote, SocketAddress local) throws IOException {
        this(serializerBuilder, remote, local, NetworkProtocol.UDP);
    }

    public OSCPortOut(OSCSerializerAndParserBuilder serializerFactory, SocketAddress remote) throws IOException {
        this(serializerFactory, remote, new InetSocketAddress(OSCPort.generateWildcard(remote), 0));
    }

    public OSCPortOut(SocketAddress remote) throws IOException {
        this(new OSCSerializerAndParserBuilder(), remote);
    }

    public OSCPortOut(InetAddress remote, int port) throws IOException {
        this(new InetSocketAddress(remote, port));
    }

    public OSCPortOut(InetAddress remote) throws IOException {
        this(remote, 57110);
    }

    public OSCPortOut() throws IOException {
        this(new InetSocketAddress(InetAddress.getLocalHost(), 57110));
    }

    public void send(OSCPacket packet) throws IOException, OSCSerializeException {
        this.getTransport().send(packet);
    }
}

