/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc.transport;

import com.tom.cpmoscc.OSCLog;
import com.tom.cpmoscc.external.com.illposed.osc.OSCBadDataEvent;
import com.tom.cpmoscc.external.com.illposed.osc.OSCPacket;
import com.tom.cpmoscc.external.com.illposed.osc.OSCPacketDispatcher;
import com.tom.cpmoscc.external.com.illposed.osc.OSCPacketEvent;
import com.tom.cpmoscc.external.com.illposed.osc.OSCPacketListener;
import com.tom.cpmoscc.external.com.illposed.osc.OSCParseException;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializerAndParserBuilder;
import com.tom.cpmoscc.external.com.illposed.osc.transport.NetworkProtocol;
import com.tom.cpmoscc.external.com.illposed.osc.transport.OSCPort;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class OSCPortIn
extends OSCPort
implements Runnable {
    private final OSCLog log = OSCLog.getLogger(OSCPortIn.class);
    private volatile boolean listening = false;
    private boolean daemonListener = true;
    private boolean resilient = true;
    private Thread listeningThread;
    private final List<OSCPacketListener> packetListeners;

    public static OSCPacketDispatcher getDispatcher(List<OSCPacketListener> listeners) {
        return listeners.stream().filter(OSCPacketDispatcher.class::isInstance).findFirst().map(OSCPacketDispatcher.class::cast).orElse(null);
    }

    public static OSCPacketListener defaultPacketListener() {
        OSCPacketDispatcher dispatcher = new OSCPacketDispatcher();
        dispatcher.setAlwaysDispatchingImmediately(false);
        return dispatcher;
    }

    public static List<OSCPacketListener> defaultPacketListeners() {
        ArrayList<OSCPacketListener> listeners = new ArrayList<OSCPacketListener>();
        listeners.add(OSCPortIn.defaultPacketListener());
        return listeners;
    }

    public OSCPortIn(OSCSerializerAndParserBuilder parserBuilder, List<OSCPacketListener> packetListeners, SocketAddress local, SocketAddress remote, NetworkProtocol protocol) throws IOException {
        super(local, remote, parserBuilder, protocol);
        this.packetListeners = packetListeners;
    }

    public OSCPortIn(OSCSerializerAndParserBuilder parserBuilder, List<OSCPacketListener> packetListeners, SocketAddress local, SocketAddress remote) throws IOException {
        this(parserBuilder, packetListeners, local, remote, NetworkProtocol.UDP);
    }

    public OSCPortIn(OSCSerializerAndParserBuilder parserBuilder, List<OSCPacketListener> packetListeners, SocketAddress local) throws IOException {
        this(parserBuilder, packetListeners, local, new InetSocketAddress(OSCPort.generateWildcard(local), 0));
    }

    public OSCPortIn(OSCSerializerAndParserBuilder parserBuilder, SocketAddress local) throws IOException {
        this(parserBuilder, OSCPortIn.defaultPacketListeners(), local);
    }

    public OSCPortIn(OSCSerializerAndParserBuilder parserBuilder, int port) throws IOException {
        this(parserBuilder, new InetSocketAddress(port));
    }

    public OSCPortIn(SocketAddress local) throws IOException {
        this(new OSCSerializerAndParserBuilder(), local);
    }

    public OSCPortIn(int port) throws IOException {
        this(new InetSocketAddress(port));
    }

    public OSCPortIn() throws IOException {
        this(OSCPortIn.defaultSCOSCPort());
    }

    @Override
    public void run() {
        while (this.listening) {
            try {
                OSCPacket oscPacket = this.getTransport().receive();
                OSCPacketEvent event = new OSCPacketEvent(this, oscPacket);
                for (OSCPacketListener listener : this.packetListeners) {
                    listener.handlePacket(event);
                }
            }
            catch (IOException ex) {
                if (this.isListening()) {
                    this.stopListening(ex);
                    continue;
                }
                this.stopListening();
            }
            catch (OSCParseException ex) {
                this.badPacketReceived(ex);
            }
        }
    }

    private void stopListening(Exception exception) {
        String errorMsg = "Error while listening on " + this.toString() + "...";
        this.log.error(errorMsg);
        if (exception instanceof OSCParseException) {
            this.log.error(errorMsg);
        } else {
            this.log.error(errorMsg, exception);
        }
        this.stopListening();
    }

    private void badPacketReceived(OSCParseException exception) {
        ByteBuffer data = exception.getData();
        OSCBadDataEvent badDataEvt = new OSCBadDataEvent(this, data, exception);
        for (OSCPacketListener listener : this.packetListeners) {
            listener.handleBadData(badDataEvt);
        }
        if (!this.isResilient()) {
            this.stopListening(exception);
        }
    }

    public void startListening() {
        if (!this.isListening()) {
            this.listening = true;
            this.listeningThread = new Thread(this);
            this.listeningThread.setDaemon(this.daemonListener);
            this.listeningThread.start();
        }
    }

    public void stopListening() {
        this.listening = false;
        if (this.getTransport().isBlocking()) {
            try {
                this.getTransport().close();
            }
            catch (IOException ex) {
                this.log.error("Failed to close OSC transport", ex);
            }
        }
    }

    public boolean isListening() {
        return this.listening;
    }

    public boolean isDaemonListener() {
        return this.daemonListener;
    }

    public void setDaemonListener(boolean daemonListener) {
        if (this.isListening()) {
            this.listeningThread.setDaemon(daemonListener);
        }
        this.daemonListener = daemonListener;
    }

    public boolean isResilient() {
        return this.resilient;
    }

    public void setResilient(boolean resilient) {
        this.resilient = resilient;
    }

    @Override
    public void close() throws IOException {
        if (this.isListening()) {
            this.stopListening();
        }
        super.close();
    }

    @Override
    public String toString() {
        StringBuilder rep = new StringBuilder(32);
        rep.append('[').append(this.getClass().getSimpleName()).append(": ");
        if (this.isListening()) {
            rep.append("listening via \"").append(this.getTransport().toString()).append('\"');
        } else {
            rep.append("stopped");
        }
        rep.append(']');
        return rep.toString();
    }

    public OSCPacketDispatcher getDispatcher() {
        OSCPacketDispatcher dispatcher = OSCPortIn.getDispatcher(this.packetListeners);
        if (dispatcher == null) {
            throw new IllegalStateException("OSCPortIn packet listeners do not include a dispatcher.");
        }
        return dispatcher;
    }

    public List<OSCPacketListener> getPacketListeners() {
        return this.packetListeners;
    }

    public void addPacketListener(OSCPacketListener listener) {
        this.packetListeners.add(listener);
    }

    public void removePacketListener(OSCPacketListener listener) {
        this.packetListeners.remove(listener);
    }
}

