/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc.messageselector;

import com.tom.cpmoscc.external.com.illposed.osc.MessageSelector;
import com.tom.cpmoscc.external.com.illposed.osc.OSCMessageEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class OSCPatternAddressMessageSelector
implements MessageSelector {
    private final List<String> patternParts;

    public OSCPatternAddressMessageSelector(String selector) {
        this.patternParts = OSCPatternAddressMessageSelector.splitIntoParts(selector);
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof OSCPatternAddressMessageSelector) {
            OSCPatternAddressMessageSelector otherSelector = (OSCPatternAddressMessageSelector)other;
            equal = this.patternParts.equals(otherSelector.patternParts);
        }
        return equal;
    }

    public int hashCode() {
        return this.patternParts.hashCode();
    }

    @Override
    public boolean isInfoRequired() {
        return false;
    }

    @Override
    public boolean matches(OSCMessageEvent messageEvent) {
        List<String> messageAddressParts = OSCPatternAddressMessageSelector.splitIntoParts(messageEvent.getMessage().getAddress());
        return OSCPatternAddressMessageSelector.matches(this.patternParts, 0, messageAddressParts, 0);
    }

    private static List<String> splitIntoParts(String addressOrPattern) {
        ArrayList<String> parts = new ArrayList<String>(Arrays.asList(addressOrPattern.split("/", -1)));
        if (addressOrPattern.startsWith("/")) {
            parts.remove(0);
        }
        if (addressOrPattern.endsWith("/")) {
            parts.remove(parts.size() - 1);
        }
        return Collections.unmodifiableList(parts);
    }

    private static boolean matches(List<String> patternParts, int patternPartIndex, List<String> messageAddressParts, int addressPartIndex) {
        int api = addressPartIndex;
        for (int ppi = patternPartIndex; ppi < patternParts.size(); ++ppi) {
            boolean pathTraverser = false;
            while (ppi < patternParts.size() && patternParts.get(ppi).isEmpty()) {
                ++ppi;
                pathTraverser = true;
            }
            if (pathTraverser) {
                if (ppi == patternParts.size()) {
                    return true;
                }
                while (api < messageAddressParts.size()) {
                    if (OSCPatternAddressMessageSelector.matches(messageAddressParts.get(api), patternParts.get(ppi)) && OSCPatternAddressMessageSelector.matches(patternParts, ppi + 1, messageAddressParts, api + 1)) {
                        return true;
                    }
                    ++api;
                }
                return false;
            }
            if (ppi == patternParts.size() != (api == messageAddressParts.size())) {
                return false;
            }
            if (!OSCPatternAddressMessageSelector.matches(messageAddressParts.get(api), patternParts.get(ppi))) {
                return false;
            }
            ++api;
        }
        return api == messageAddressParts.size();
    }

    public static boolean matches(String str, String p) {
        int si = 0;
        int pi = 0;
        while (pi < p.length()) {
            if (si == str.length() && p.charAt(pi) != '*') {
                return false;
            }
            char c = p.charAt(pi++);
            block0 : switch (c) {
                case '*': {
                    while (pi < p.length() && p.charAt(pi) == '*' && p.charAt(pi) != '/') {
                        ++pi;
                    }
                    if (pi == p.length()) {
                        return true;
                    }
                    if (p.charAt(pi) != '?' && p.charAt(pi) != '[' && p.charAt(pi) != '{') {
                        while (si < str.length() && p.charAt(pi) != str.charAt(si)) {
                            ++si;
                        }
                    }
                    while (si < str.length()) {
                        if (OSCPatternAddressMessageSelector.matches(str.substring(si), p.substring(pi))) {
                            return true;
                        }
                        ++si;
                    }
                    return false;
                }
                case '?': {
                    if (si < str.length()) break;
                    return false;
                }
                case '[': {
                    boolean negate;
                    if (p.charAt(pi) == '!') {
                        negate = true;
                        ++pi;
                    } else {
                        negate = false;
                    }
                    boolean match = false;
                    while (!match && pi < p.length()) {
                        c = p.charAt(pi++);
                        if (pi == p.length()) {
                            return false;
                        }
                        if (p.charAt(pi) == '-') {
                            if (++pi == p.length()) {
                                return false;
                            }
                            if (p.charAt(pi) != ']') {
                                if (str.charAt(si) != c && str.charAt(si) != p.charAt(pi) && (str.charAt(si) <= c || str.charAt(si) >= p.charAt(pi))) continue;
                                match = true;
                                continue;
                            }
                            if (str.charAt(si) < c) break;
                            match = true;
                            break;
                        }
                        if (c == str.charAt(si)) {
                            match = true;
                        }
                        if (p.charAt(pi) == ']') break;
                        if (p.charAt(pi) != str.charAt(si)) continue;
                        match = true;
                    }
                    if (negate == match) {
                        return false;
                    }
                    while (pi < p.length() && p.charAt(pi) != ']') {
                        ++pi;
                    }
                    if (pi++ != p.length()) break;
                    return false;
                }
                case '{': {
                    int remainder;
                    int place = si;
                    for (remainder = pi; remainder < p.length() && p.charAt(remainder) != '}'; ++remainder) {
                    }
                    if (remainder == p.length()) {
                        return false;
                    }
                    ++remainder;
                    c = p.charAt(pi++);
                    while (pi <= p.length()) {
                        if (c == ',') {
                            if (OSCPatternAddressMessageSelector.matches(str.substring(si), p.substring(remainder))) {
                                return true;
                            }
                            si = place;
                            if (pi++ == p.length()) {
                                return false;
                            }
                        } else {
                            if (c == '}') {
                                if (pi == p.length() && si == str.length()) {
                                    return true;
                                }
                                --si;
                                break block0;
                            }
                            if (c == str.charAt(si)) {
                                if (++si == str.length() && remainder < p.length()) {
                                    return false;
                                }
                            } else {
                                si = place;
                                while (pi < p.length() && p.charAt(pi) != ',' && p.charAt(pi) != '}') {
                                    ++pi;
                                }
                                if (pi < p.length() && p.charAt(pi) != ',' && p.charAt(pi) == '}') {
                                    return false;
                                }
                            }
                        }
                        int n = ++pi;
                        ++pi;
                        c = p.charAt(n);
                    }
                    break;
                }
                default: {
                    if (c == str.charAt(si)) break;
                    return false;
                }
            }
            ++si;
        }
        return si == str.length();
    }
}

