/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc.argument.handler;

import com.tom.cpmoscc.external.com.illposed.osc.BytesReceiver;
import com.tom.cpmoscc.external.com.illposed.osc.OSCParseException;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializeException;
import com.tom.cpmoscc.external.com.illposed.osc.argument.ArgumentHandler;
import com.tom.cpmoscc.external.com.illposed.osc.argument.OSCTimeTag64;
import com.tom.cpmoscc.external.com.illposed.osc.argument.handler.TimeTag64ArgumentHandler;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;

public class DateTimeStampArgumentHandler
implements ArgumentHandler<Date>,
Cloneable {
    public static final ArgumentHandler<Date> INSTANCE = new DateTimeStampArgumentHandler();
    public static final String PROP_NAME_EPOCH_INDICATOR_TIME = "epoch-indicator";
    private Long epochIndicatorTime = new Date().getTime();

    protected DateTimeStampArgumentHandler() {
    }

    @Override
    public char getDefaultIdentifier() {
        return 't';
    }

    @Override
    public Class<Date> getJavaClass() {
        return Date.class;
    }

    public void setEpochIndicatorTime(Long epochIndicatorTime) {
        this.epochIndicatorTime = epochIndicatorTime;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        Long newEpochIndicatorTime = (Long)properties.get(PROP_NAME_EPOCH_INDICATOR_TIME);
        if (newEpochIndicatorTime != null) {
            this.setEpochIndicatorTime(newEpochIndicatorTime);
        }
    }

    @Override
    public boolean isMarkerOnly() {
        return false;
    }

    public DateTimeStampArgumentHandler clone() throws CloneNotSupportedException {
        return (DateTimeStampArgumentHandler)super.clone();
    }

    @Override
    public Date parse(ByteBuffer input) throws OSCParseException {
        return TimeTag64ArgumentHandler.INSTANCE.parse(input).toDate(this.epochIndicatorTime);
    }

    @Override
    public void serialize(BytesReceiver output, Date value) throws OSCSerializeException {
        TimeTag64ArgumentHandler.INSTANCE.serialize(output, OSCTimeTag64.valueOf(value));
    }
}

