/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc.argument.handler;

import com.tom.cpmoscc.external.com.illposed.osc.BytesReceiver;
import com.tom.cpmoscc.external.com.illposed.osc.OSCParseException;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializeException;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializer;
import com.tom.cpmoscc.external.com.illposed.osc.argument.ArgumentHandler;
import com.tom.cpmoscc.external.com.illposed.osc.argument.handler.IntegerArgumentHandler;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;

public class BlobArgumentHandler
implements ArgumentHandler<ByteBuffer>,
Cloneable {
    public static final ArgumentHandler<ByteBuffer> INSTANCE = new BlobArgumentHandler();

    protected BlobArgumentHandler() {
    }

    @Override
    public char getDefaultIdentifier() {
        return 'b';
    }

    @Override
    public Class<ByteBuffer> getJavaClass() {
        return ByteBuffer.class;
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
    }

    @Override
    public boolean isMarkerOnly() {
        return false;
    }

    public BlobArgumentHandler clone() throws CloneNotSupportedException {
        return (BlobArgumentHandler)super.clone();
    }

    @Override
    public ByteBuffer parse(ByteBuffer input) throws OSCParseException {
        int blobLen = IntegerArgumentHandler.INSTANCE.parse(input);
        int previousLimit = input.limit();
        ((Buffer)input).limit(input.position() + blobLen);
        ByteBuffer value = input.slice();
        ((Buffer)input).limit(previousLimit);
        return value;
    }

    @Override
    public void serialize(BytesReceiver output, ByteBuffer value) throws OSCSerializeException {
        int numBytes = value.remaining();
        IntegerArgumentHandler.INSTANCE.serialize(output, numBytes);
        output.put(value);
        OSCSerializer.align(output);
    }
}

