/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc.argument;

import java.io.Serializable;

public class OSCMidiMessage
implements Cloneable,
Serializable,
Comparable<OSCMidiMessage> {
    public static final int NUM_CONTENT_BYTES = 4;
    private static final long serialVersionUID = 1L;
    private final byte portId;
    private final byte status;
    private final byte data1;
    private final byte data2;

    public OSCMidiMessage(byte portId, byte status, byte data1, byte data2) {
        this.portId = portId;
        this.status = status;
        this.data1 = data1;
        this.data2 = data2;
    }

    public byte[] toContentArray() {
        return new byte[]{this.getPortId(), this.getStatus(), this.getData1(), this.getData2()};
    }

    public byte getPortId() {
        return this.portId;
    }

    public byte getStatus() {
        return this.status;
    }

    public byte getData1() {
        return this.data1;
    }

    public byte getData2() {
        return this.data2;
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if (other instanceof OSCMidiMessage) {
            OSCMidiMessage otherMidiMsg = (OSCMidiMessage)other;
            if (this.portId == otherMidiMsg.portId && this.status == otherMidiMsg.status && this.data1 == otherMidiMsg.data1 && this.data2 == otherMidiMsg.data2) {
                equal = true;
            }
        }
        return equal;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.portId;
        hash = 97 * hash + this.status;
        hash = 97 * hash + this.data1;
        hash = 97 * hash + this.data2;
        return hash;
    }

    @Override
    public int compareTo(OSCMidiMessage other) {
        return Integer.compare(this.hashCode(), other.hashCode());
    }

    public OSCMidiMessage clone() throws CloneNotSupportedException {
        return (OSCMidiMessage)super.clone();
    }

    public static OSCMidiMessage valueOf(byte[] content) {
        if (content.length != 4) {
            throw new IllegalArgumentException("The content has to be exactly 4 bytes");
        }
        int contentByteIndex = 0;
        return new OSCMidiMessage(content[contentByteIndex++], content[contentByteIndex++], content[contentByteIndex++], content[contentByteIndex]);
    }
}

