/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc;

import com.tom.cpmoscc.external.com.illposed.osc.BytesReceiver;
import com.tom.cpmoscc.external.com.illposed.osc.OSCParser;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializer;
import com.tom.cpmoscc.external.com.illposed.osc.argument.ArgumentHandler;
import com.tom.cpmoscc.external.com.illposed.osc.argument.handler.Activator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OSCSerializerAndParserBuilder {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<Character, ArgumentHandler> identifierToType = new HashMap<Character, ArgumentHandler>();
    private boolean usingDefaultHandlers = true;

    public Map<Character, ArgumentHandler> getIdentifierToTypeMapping() {
        return Collections.unmodifiableMap(this.identifierToType);
    }

    public OSCSerializer buildSerializer(BytesReceiver output) {
        Map<String, Object> currentProperties = this.getProperties();
        ArrayList<ArgumentHandler> typeCopies = new ArrayList<ArgumentHandler>(this.identifierToType.size());
        for (ArgumentHandler type : this.identifierToType.values()) {
            ArgumentHandler typeClone;
            try {
                typeClone = type.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException("Does not support cloning: " + type.getClass(), ex);
            }
            typeClone.setProperties(currentProperties);
            typeCopies.add(typeClone);
        }
        if (this.usingDefaultHandlers) {
            List<ArgumentHandler> defaultParserTypes = Activator.createSerializerTypes();
            typeCopies.addAll(defaultParserTypes);
        }
        return new OSCSerializer(typeCopies, currentProperties, output);
    }

    public OSCParser buildParser() {
        HashMap<Character, ArgumentHandler> identifierToTypeCopy = new HashMap<Character, ArgumentHandler>(this.identifierToType.size());
        Map<String, Object> currentProperties = this.getProperties();
        for (Map.Entry<Character, ArgumentHandler> typeEntry : this.identifierToType.entrySet()) {
            ArgumentHandler typeClone;
            try {
                typeClone = typeEntry.getValue().clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new IllegalStateException("Does not support cloning: " + typeEntry.getValue().getClass(), ex);
            }
            identifierToTypeCopy.put(typeEntry.getKey(), typeClone);
            typeClone.setProperties(currentProperties);
        }
        if (this.usingDefaultHandlers) {
            Map<Character, ArgumentHandler> defaultParserTypes = Activator.createParserTypes();
            identifierToTypeCopy.putAll(defaultParserTypes);
        }
        return new OSCParser(identifierToTypeCopy, currentProperties);
    }

    public OSCSerializerAndParserBuilder setUsingDefaultHandlers(boolean newUsingDefaultHandlers) {
        this.usingDefaultHandlers = newUsingDefaultHandlers;
        return this;
    }

    public Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public OSCSerializerAndParserBuilder setProperties(Map<String, Object> newProperties) {
        this.clearProperties();
        this.addProperties(newProperties);
        return this;
    }

    public OSCSerializerAndParserBuilder addProperties(Map<String, Object> additionalProperties) {
        this.properties.putAll(additionalProperties);
        return this;
    }

    public OSCSerializerAndParserBuilder clearProperties() {
        this.properties.clear();
        return this;
    }

    public OSCSerializerAndParserBuilder registerArgumentHandler(ArgumentHandler argumentHandler) {
        this.registerArgumentHandler(argumentHandler, argumentHandler.getDefaultIdentifier());
        return this;
    }

    public OSCSerializerAndParserBuilder registerArgumentHandler(ArgumentHandler argumentHandler, char typeIdentifier) {
        ArgumentHandler previousArgumentHandler = this.identifierToType.get(Character.valueOf(typeIdentifier));
        if (previousArgumentHandler != null) {
            throw new IllegalStateException("Type identifier '" + typeIdentifier + "' is already used for type " + previousArgumentHandler.getClass().getCanonicalName());
        }
        this.identifierToType.put(Character.valueOf(typeIdentifier), argumentHandler);
        return this;
    }

    public OSCSerializerAndParserBuilder unregisterArgumentHandler(ArgumentHandler argumentHandler) {
        this.unregisterArgumentHandler(argumentHandler.getDefaultIdentifier());
        return this;
    }

    public OSCSerializerAndParserBuilder unregisterArgumentHandler(char typeIdentifier) {
        this.identifierToType.remove(Character.valueOf(typeIdentifier));
        return this;
    }
}

