/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc;

import com.tom.cpmoscc.OSCLog;
import com.tom.cpmoscc.external.com.illposed.osc.BufferBytesReceiver;
import com.tom.cpmoscc.external.com.illposed.osc.BytesReceiver;
import com.tom.cpmoscc.external.com.illposed.osc.OSCBundle;
import com.tom.cpmoscc.external.com.illposed.osc.OSCMessage;
import com.tom.cpmoscc.external.com.illposed.osc.OSCPacket;
import com.tom.cpmoscc.external.com.illposed.osc.OSCParseException;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializeException;
import com.tom.cpmoscc.external.com.illposed.osc.argument.ArgumentHandler;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OSCSerializer {
    private static final int MAX_IMPLEMENTED_ARGUMENT_TYPES = 1;
    private static final Integer PACKET_SIZE_PLACEHOLDER = -1;
    private final OSCLog log = OSCLog.getLogger(OSCSerializer.class);
    private final BytesReceiver output;
    private final Set<Class> unsupportedTypes;
    private final Map<Class, Class> subToSuperTypes;
    private final Map<Class, Boolean> classToMarker;
    private final Map<Class, ArgumentHandler> classToType;
    private final Map<Object, ArgumentHandler> markerValueToType;
    private final Map<String, Object> properties;

    public OSCSerializer(List<ArgumentHandler> types, Map<String, Object> properties, BytesReceiver output) {
        HashMap classToMarkerTmp = new HashMap(types.size());
        HashMap classToTypeTmp = new HashMap();
        HashMap markerValueToTypeTmp = new HashMap();
        for (ArgumentHandler type : types) {
            Class typeJava = type.getJavaClass();
            Boolean registeredIsMarker = (Boolean)classToMarkerTmp.get(typeJava);
            if (registeredIsMarker != null && registeredIsMarker.booleanValue() != type.isMarkerOnly()) {
                throw new IllegalStateException(ArgumentHandler.class.getSimpleName() + " implementations disagree on the marker nature of their class: " + typeJava);
            }
            classToMarkerTmp.put(typeJava, type.isMarkerOnly());
            if (type.isMarkerOnly()) {
                try {
                    Object markerValue = type.parse(null);
                    ArgumentHandler previousType = (ArgumentHandler)markerValueToTypeTmp.get(markerValue);
                    if (previousType != null) {
                        throw new IllegalStateException("Marker value \"" + markerValue + "\" is already used for type " + previousType.getClass().getCanonicalName());
                    }
                    markerValueToTypeTmp.put(markerValue, type);
                    continue;
                }
                catch (OSCParseException ex) {
                    throw new IllegalStateException("Developer error; this should never happen", ex);
                }
            }
            ArgumentHandler previousType = (ArgumentHandler)classToTypeTmp.get(typeJava);
            if (previousType != null) {
                throw new IllegalStateException("Java argument type " + typeJava.getCanonicalName() + " is already used for type " + previousType.getClass().getCanonicalName());
            }
            classToTypeTmp.put(typeJava, type);
        }
        this.output = output;
        this.unsupportedTypes = new HashSet<Class>(4);
        this.subToSuperTypes = new HashMap<Class, Class>(4);
        this.classToMarker = Collections.unmodifiableMap(new HashMap(classToMarkerTmp));
        this.classToType = Collections.unmodifiableMap(new HashMap(classToTypeTmp));
        this.markerValueToType = Collections.unmodifiableMap(new HashMap(markerValueToTypeTmp));
        this.properties = Collections.unmodifiableMap(new HashMap<String, Object>(properties));
    }

    public Map<Class, ArgumentHandler> getClassToTypeMapping() {
        return this.classToType;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    public static void terminate(BytesReceiver output) {
        output.put((byte)0);
    }

    public static void align(BytesReceiver output) {
        int alignmentOverlap = output.position() % 4;
        int padLen = (4 - alignmentOverlap) % 4;
        for (int pci = 0; pci < padLen; ++pci) {
            output.put((byte)0);
        }
    }

    public static void terminateAndAlign(BytesReceiver output) {
        OSCSerializer.terminate(output);
        OSCSerializer.align(output);
    }

    private void write(OSCBundle bundle) throws OSCSerializeException {
        this.write("#bundle");
        this.write(bundle.getTimestamp());
        for (OSCPacket pkg : bundle.getPackets()) {
            this.writeSizeAndData(pkg);
        }
    }

    private void writeAddress(OSCMessage message) throws OSCSerializeException {
        this.write(message.getAddress());
    }

    private void writeArguments(OSCMessage message) throws OSCSerializeException {
        this.output.put((byte)44);
        this.writeTypeTags(message.getArguments());
        for (Object argument : message.getArguments()) {
            this.write(argument);
        }
    }

    private void write(OSCMessage message) throws OSCSerializeException {
        this.writeAddress(message);
        this.writeArguments(message);
    }

    private void writeSizeAndData(OSCPacket packet) throws OSCSerializeException {
        ByteBuffer serializedPacketBuffer = ByteBuffer.allocate(4);
        BufferBytesReceiver serializedPacketSize = new BufferBytesReceiver(serializedPacketBuffer);
        ArgumentHandler type = this.findType(PACKET_SIZE_PLACEHOLDER);
        int sizePosition = this.output.position();
        type.serialize(serializedPacketSize, PACKET_SIZE_PLACEHOLDER);
        BytesReceiver.PlaceHolder packetSizePlaceholder = this.output.putPlaceHolder(serializedPacketBuffer.array());
        this.writePacket(packet);
        int afterPacketPosition = this.output.position();
        int packetSize = afterPacketPosition - sizePosition - 4;
        serializedPacketSize.clear();
        type.serialize(serializedPacketSize, packetSize);
        packetSizePlaceholder.replace(serializedPacketBuffer.array());
    }

    private void writePacket(OSCPacket packet) throws OSCSerializeException {
        if (packet instanceof OSCBundle) {
            this.write((OSCBundle)packet);
        } else if (packet instanceof OSCMessage) {
            this.write((OSCMessage)packet);
        } else {
            throw new UnsupportedOperationException("We do not support writing packets of type: " + packet.getClass());
        }
    }

    public void write(OSCPacket packet) throws OSCSerializeException {
        this.output.clear();
        try {
            this.writePacket(packet);
        }
        catch (BufferOverflowException ex) {
            throw new OSCSerializeException("Packet is too large for the buffer in use", ex);
        }
    }

    public void writeOnlyTypeTags(List<?> arguments) throws OSCSerializeException {
        this.output.clear();
        try {
            this.writeTypeTagsRaw(arguments);
        }
        catch (BufferOverflowException ex) {
            throw new OSCSerializeException("Type tags are too large for the buffer in use", ex);
        }
    }

    private Set<ArgumentHandler> findSuperTypes(Class argumentClass) {
        HashSet<ArgumentHandler> matchingSuperTypes = new HashSet<ArgumentHandler>();
        for (Map.Entry<Class, ArgumentHandler> baseClassAndType : this.classToType.entrySet()) {
            Class baseClass = baseClassAndType.getKey();
            if (baseClass == Object.class || !baseClass.isAssignableFrom(argumentClass)) continue;
            matchingSuperTypes.add(baseClassAndType.getValue());
        }
        return matchingSuperTypes;
    }

    private Class findSuperType(Class argumentClass) throws OSCSerializeException {
        Class superType = this.subToSuperTypes.get(argumentClass);
        if (superType == null && !this.unsupportedTypes.contains(argumentClass)) {
            Set<ArgumentHandler> matchingSuperTypes = this.findSuperTypes(argumentClass);
            if (matchingSuperTypes.isEmpty()) {
                this.unsupportedTypes.add(argumentClass);
            } else {
                if (matchingSuperTypes.size() > 1) {
                    this.log.warn("Java class {} is a sub-class of multiple supported argument types:", argumentClass.getCanonicalName());
                    for (ArgumentHandler matchingSuperType : matchingSuperTypes) {
                        this.log.warn("\t{} (supported by {})", matchingSuperType.getJavaClass().getCanonicalName(), matchingSuperType.getClass().getCanonicalName());
                    }
                }
                ArgumentHandler matchingSuperType = matchingSuperTypes.iterator().next();
                this.log.info("Java class {} will be mapped to {} (supported by {})", argumentClass.getCanonicalName(), matchingSuperType.getJavaClass().getCanonicalName(), matchingSuperType.getClass().getCanonicalName());
                Class matchingSuperClass = matchingSuperType.getJavaClass();
                this.subToSuperTypes.put(argumentClass, matchingSuperClass);
                superType = matchingSuperClass;
            }
        }
        if (superType == null) {
            throw new OSCSerializeException("No type handler registered for serializing class " + argumentClass.getCanonicalName());
        }
        return superType;
    }

    private ArgumentHandler findType(Object argumentValue, Class argumentClass) throws OSCSerializeException {
        Boolean markerType = this.classToMarker.get(argumentClass);
        ArgumentHandler type = markerType == null ? this.findType(argumentValue, this.findSuperType(argumentClass)) : (markerType != false ? this.markerValueToType.get(argumentValue) : this.classToType.get(argumentClass));
        return type;
    }

    private ArgumentHandler findType(Object argumentValue) throws OSCSerializeException {
        return this.findType(argumentValue, OSCSerializer.extractTypeClass(argumentValue));
    }

    private void write(Object anObject) throws OSCSerializeException {
        if (anObject instanceof Collection) {
            Collection theArray = (Collection)anObject;
            for (Object entry : theArray) {
                this.write(entry);
            }
        } else {
            ArgumentHandler type = this.findType(anObject);
            type.serialize(this.output, anObject);
        }
    }

    private static Class extractTypeClass(Object value) {
        return value == null ? Object.class : value.getClass();
    }

    private void writeType(Object value) throws OSCSerializeException {
        ArgumentHandler type = this.findType(value);
        this.output.put((byte)type.getDefaultIdentifier());
    }

    private void writeTypeTagsRaw(List<?> arguments) throws OSCSerializeException {
        for (Object argument : arguments) {
            if (argument instanceof List) {
                List argumentsArray = (List)argument;
                this.output.put((byte)91);
                this.writeTypeTagsRaw(argumentsArray);
                this.output.put((byte)93);
                continue;
            }
            this.writeType(argument);
        }
    }

    private void writeTypeTags(List<?> arguments) throws OSCSerializeException {
        this.writeTypeTagsRaw(arguments);
        OSCSerializer.terminateAndAlign(this.output);
    }
}

