/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc.external.com.illposed.osc;

import com.tom.cpmoscc.external.com.illposed.osc.BufferBytesReceiver;
import com.tom.cpmoscc.external.com.illposed.osc.BytesReceiver;
import com.tom.cpmoscc.external.com.illposed.osc.MessageSelector;
import com.tom.cpmoscc.external.com.illposed.osc.OSCBadDataEvent;
import com.tom.cpmoscc.external.com.illposed.osc.OSCBadDataListener;
import com.tom.cpmoscc.external.com.illposed.osc.OSCBundle;
import com.tom.cpmoscc.external.com.illposed.osc.OSCMessage;
import com.tom.cpmoscc.external.com.illposed.osc.OSCMessageEvent;
import com.tom.cpmoscc.external.com.illposed.osc.OSCMessageInfo;
import com.tom.cpmoscc.external.com.illposed.osc.OSCMessageListener;
import com.tom.cpmoscc.external.com.illposed.osc.OSCPacket;
import com.tom.cpmoscc.external.com.illposed.osc.OSCPacketEvent;
import com.tom.cpmoscc.external.com.illposed.osc.OSCPacketListener;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializeException;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializer;
import com.tom.cpmoscc.external.com.illposed.osc.OSCSerializerAndParserBuilder;
import com.tom.cpmoscc.external.com.illposed.osc.argument.OSCTimeTag64;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class OSCPacketDispatcher
implements OSCPacketListener {
    public static final int MAX_ARGUMENTS = 64;
    private static final int DEFAULT_CORE_THREADS = 3;
    private final BytesReceiver argumentTypesOutput;
    private final OSCSerializer serializer;
    private final Charset typeTagsCharset;
    private final List<SelectiveMessageListener> selectiveMessageListeners;
    private final List<OSCBadDataListener> badDataListeners;
    private boolean metaInfoRequired;
    private boolean alwaysDispatchingImmediately;
    private final ScheduledExecutorService dispatchScheduler;

    public OSCPacketDispatcher(OSCSerializerAndParserBuilder serializerBuilder, ScheduledExecutorService dispatchScheduler) {
        OSCSerializerAndParserBuilder nonNullSerializerBuilder;
        ByteBuffer argumentTypesBuffer;
        if (serializerBuilder == null) {
            argumentTypesBuffer = ByteBuffer.allocate(0);
            nonNullSerializerBuilder = new NullOSCSerializerBuilder();
        } else {
            argumentTypesBuffer = ByteBuffer.allocate(64);
            nonNullSerializerBuilder = serializerBuilder;
        }
        this.argumentTypesOutput = new BufferBytesReceiver(argumentTypesBuffer);
        this.serializer = nonNullSerializerBuilder.buildSerializer(this.argumentTypesOutput);
        Map<String, Object> serializationProperties = nonNullSerializerBuilder.getProperties();
        Charset propertiesCharset = (Charset)serializationProperties.get("charset");
        this.typeTagsCharset = propertiesCharset == null ? Charset.defaultCharset() : propertiesCharset;
        this.selectiveMessageListeners = new ArrayList<SelectiveMessageListener>();
        this.badDataListeners = new ArrayList<OSCBadDataListener>();
        this.metaInfoRequired = false;
        this.alwaysDispatchingImmediately = false;
        this.dispatchScheduler = dispatchScheduler;
    }

    public OSCPacketDispatcher(OSCSerializerAndParserBuilder serializerBuilder) {
        this(serializerBuilder, OSCPacketDispatcher.createDefaultDispatchScheduler());
    }

    public OSCPacketDispatcher() {
        this(null);
    }

    public static ScheduledExecutorService createDefaultDispatchScheduler() {
        return Executors.newScheduledThreadPool(3, new DaemonThreadFactory());
    }

    public void setAlwaysDispatchingImmediately(boolean alwaysDispatchingImmediately) {
        this.alwaysDispatchingImmediately = alwaysDispatchingImmediately;
    }

    public boolean isAlwaysDispatchingImmediately() {
        return this.alwaysDispatchingImmediately;
    }

    public boolean isMetaInfoRequired() {
        return this.metaInfoRequired;
    }

    public void addListener(MessageSelector messageSelector, OSCMessageListener listener) {
        this.selectiveMessageListeners.add(new SelectiveMessageListener(messageSelector, listener));
        if (messageSelector.isInfoRequired()) {
            this.metaInfoRequired = true;
        }
    }

    public void removeListener(MessageSelector messageSelector, OSCMessageListener listener) {
        this.selectiveMessageListeners.remove(new SelectiveMessageListener(messageSelector, listener));
        if (this.metaInfoRequired) {
            this.metaInfoRequired = this.selectiveMessageListeners.stream().anyMatch(selMsgListener -> selMsgListener.getSelector().isInfoRequired());
        }
    }

    public void addBadDataListener(OSCBadDataListener listener) {
        this.badDataListeners.add(listener);
    }

    public void removeBadDataListener(OSCBadDataListener listener) {
        this.badDataListeners.remove(listener);
    }

    @Override
    public void handleBadData(OSCBadDataEvent event) {
        for (OSCBadDataListener listener : this.badDataListeners) {
            listener.badDataReceived(event);
        }
    }

    private void dispatchPacket(Object source, OSCPacket packet, OSCTimeTag64 timeStamp) {
        if (packet instanceof OSCBundle) {
            this.dispatchBundle(source, (OSCBundle)packet);
        } else {
            this.dispatchMessageNow(new OSCMessageEvent(source, timeStamp, (OSCMessage)packet));
        }
    }

    @Override
    public void handlePacket(OSCPacketEvent event) {
        this.dispatchPacket(event.getSource(), event.getPacket(), OSCTimeTag64.IMMEDIATE);
    }

    private long calculateDelayFromNow(OSCTimeTag64 timeStamp) {
        return timeStamp.toDate(null).getTime() - System.currentTimeMillis();
    }

    private void dispatchBundle(Object source, OSCBundle bundle) {
        OSCTimeTag64 timeStamp = bundle.getTimestamp();
        if (this.isAlwaysDispatchingImmediately() || timeStamp.isImmediate()) {
            this.dispatchBundleNow(source, bundle);
        } else {
            long delayMs = this.calculateDelayFromNow(timeStamp);
            this.dispatchScheduler.schedule(new BundleDispatcher(source, bundle), delayMs, TimeUnit.MILLISECONDS);
        }
    }

    private void dispatchBundleNow(Object source, OSCBundle bundle) {
        OSCTimeTag64 timeStamp = bundle.getTimestamp();
        List<OSCPacket> packets = bundle.getPackets();
        for (OSCPacket packet : packets) {
            this.dispatchPacket(source, packet, timeStamp);
        }
    }

    private CharSequence generateTypeTagsString(List<?> arguments) {
        try {
            this.serializer.writeOnlyTypeTags(arguments);
        }
        catch (OSCSerializeException ex) {
            throw new IllegalArgumentException("Failed generating Arguments Type Tag string while dispatching", ex);
        }
        return new String(this.argumentTypesOutput.toByteArray(), this.typeTagsCharset);
    }

    private void ensureMetaInfo(OSCMessage message) {
        if (this.isMetaInfoRequired() && !message.isInfoSet()) {
            CharSequence generateTypeTagsString = this.generateTypeTagsString(message.getArguments());
            OSCMessageInfo messageInfo = new OSCMessageInfo(generateTypeTagsString);
            message.setInfo(messageInfo);
        }
    }

    private void dispatchMessageNow(OSCMessageEvent event) {
        this.ensureMetaInfo(event.getMessage());
        for (SelectiveMessageListener selectiveMessageListener : this.selectiveMessageListeners) {
            if (!selectiveMessageListener.getSelector().matches(event)) continue;
            selectiveMessageListener.getListener().acceptMessage(event);
        }
    }

    private class BundleDispatcher
    implements Runnable {
        private final Object source;
        private final OSCBundle bundle;

        BundleDispatcher(Object source, OSCBundle bundle) {
            this.source = source;
            this.bundle = bundle;
        }

        @Override
        public void run() {
            OSCPacketDispatcher.this.dispatchBundleNow(this.source, this.bundle);
        }
    }

    private static class NullOSCSerializerBuilder
    extends OSCSerializerAndParserBuilder {
        private NullOSCSerializerBuilder() {
        }

        @Override
        public OSCSerializer buildSerializer(BytesReceiver output) {
            return new NullOSCSerializer();
        }
    }

    private static class NullOSCSerializer
    extends OSCSerializer {
        NullOSCSerializer() {
            super(Collections.emptyList(), Collections.emptyMap(), null);
        }

        @Override
        public void writeOnlyTypeTags(List<?> arguments) {
            throw new IllegalStateException("You need to either dispatch only packets containing meta-info, or supply a serialization factory to the dispatcher");
        }
    }

    private static final class SelectiveMessageListener {
        private final MessageSelector selector;
        private final OSCMessageListener listener;

        public SelectiveMessageListener(MessageSelector selector, OSCMessageListener listener) {
            this.selector = selector;
            this.listener = listener;
        }

        public MessageSelector getSelector() {
            return this.selector;
        }

        public OSCMessageListener getListener() {
            return this.listener;
        }

        public boolean equals(Object other) {
            boolean equal = false;
            if (other instanceof SelectiveMessageListener) {
                SelectiveMessageListener otherSelector = (SelectiveMessageListener)other;
                equal = this.selector.equals(otherSelector.selector) && this.listener.equals(otherSelector.listener);
            }
            return equal;
        }

        public int hashCode() {
            int hash = 7;
            hash = 89 * hash + this.selector.hashCode();
            hash = 89 * hash + this.listener.hashCode();
            return hash;
        }
    }

    public static class DaemonThreadFactory
    implements ThreadFactory {
        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

