/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc;

import com.tom.cpmoscc.CPMOSC;
import com.tom.cpmoscc.external.com.illposed.osc.MessageSelector;
import com.tom.cpmoscc.external.com.illposed.osc.OSCMessageEvent;
import com.tom.cpmoscc.external.com.illposed.osc.OSCMessageListener;
import com.tom.cpmoscc.external.com.illposed.osc.transport.OSCPortIn;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;

public class OSCReceiver
implements MessageSelector,
OSCMessageListener,
Closeable {
    private final OSCPortIn oscIn;
    private Exception error;
    private OSCListener listener;

    public OSCReceiver(int port) {
        OSCPortIn oscIn;
        try {
            oscIn = new OSCPortIn(port);
            oscIn.setDaemonListener(true);
            oscIn.getDispatcher().addListener(this, this);
        }
        catch (IOException e) {
            oscIn = null;
            this.error = e;
        }
        this.oscIn = oscIn;
    }

    public void start() {
        if (this.oscIn != null) {
            this.oscIn.startListening();
        }
    }

    @Override
    public void close() throws IOException {
        if (this.oscIn != null) {
            this.oscIn.close();
        }
    }

    @Override
    public void acceptMessage(OSCMessageEvent event) {
        CPMOSC.manager.acceptOsc(event.getMessage().getAddress(), event.getMessage().getArguments());
        if (this.listener != null) {
            this.listener.onReceive(event.getMessage().getAddress(), event.getMessage().getArguments());
        }
    }

    @Override
    public boolean isInfoRequired() {
        return false;
    }

    @Override
    public boolean matches(OSCMessageEvent messageEvent) {
        return true;
    }

    public Exception getError() {
        return this.error;
    }

    public boolean canStart() {
        return this.oscIn != null;
    }

    public void setListener(OSCListener listener) {
        this.listener = listener;
    }

    public static interface OSCListener {
        public void onReceive(String var1, List<Object> var2);
    }
}

