/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc;

import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpmoscc.CPMOSC;
import com.tom.cpmoscc.OSCMapping;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

public class OSCMessageManager {
    private Map<String, Set<OSCMapping>> mappings = new ConcurrentHashMap<String, Set<OSCMapping>>();

    public void update(ModelDefinition def) {
        this.mappings.clear();
        HashSet mappings = new HashSet();
        AnimationRegistry ar = def.getAnimations();
        ar.getCustomPoses().values().stream().filter(CustomPose::isCommand).filter(p -> p.getName().startsWith("osc:/")).forEach(p -> {
            OSCMapping m = new OSCMapping((CustomPose)p);
            if (m.getOscPacketId() != null) {
                mappings.add(m);
            }
        });
        ar.getGestures().values().stream().filter(Gesture::isCommand).filter(p -> p.getName().startsWith("osc:/")).forEach(p -> {
            OSCMapping m = new OSCMapping((Gesture)p);
            if (m.getOscPacketId() != null) {
                mappings.add(m);
            }
        });
        this.mappings.putAll(mappings.stream().collect(Collectors.groupingBy(OSCMapping::getOscPacketId, Collectors.toSet())));
        CPMOSC.LOGGER.info("Loaded OSC mappings: " + this.mappings.keySet(), new Object[0]);
    }

    public void acceptOsc(String address, List<Object> arguments) {
        Set<OSCMapping> ms = this.mappings.get(address);
        if (ms != null) {
            ms.forEach(m -> m.applyOsc(arguments));
        }
    }

    public void tick() {
        this.mappings.values().forEach(s -> s.forEach(OSCMapping::tick));
    }
}

