/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc;

import com.tom.cpl.math.MathHelper;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpmoscc.CPMOSC;
import com.tom.cpmoscc.gui.OSCDataPanel;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OSCMapping {
    private static final Pattern PATH_PARSER = Pattern.compile("osc:([\\w/]+)(?:\\[?(\\d)*:?(\\w*)\\])?(?:\\(([-\\.\\,\\d]+):([-\\.\\,\\d]+)\\))?");
    private final String animationId;
    private String oscPacketId;
    private String argMatcher;
    private int argumentId;
    private float min;
    private float max;
    private boolean boolOnly;
    private int previousValue;
    private int currentValue;

    public OSCMapping(CustomPose pose) {
        this.animationId = pose.getName();
        this.boolOnly = true;
        this.parseName();
    }

    public OSCMapping(Gesture gesture) {
        this.animationId = gesture.getName();
        this.boolOnly = gesture.type != AnimationType.VALUE_LAYER;
        this.parseName();
    }

    public OSCMapping(String displayName) {
        this.animationId = displayName;
        this.parseName();
    }

    private void parseName() {
        Matcher m = PATH_PARSER.matcher(this.animationId);
        try {
            if (m.matches()) {
                String v = m.group(2);
                this.argumentId = v == null || v.isEmpty() ? 0 : Integer.parseInt(v);
                this.argMatcher = m.group(3);
                if (this.argMatcher != null) {
                    if (this.argMatcher.isEmpty()) {
                        this.argMatcher = null;
                    } else if (this.argumentId == 0) {
                        ++this.argumentId;
                    }
                }
                this.min = (v = m.group(4)) == null || v.isEmpty() ? 0.0f : Float.parseFloat(v.replace(',', '.'));
                v = m.group(5);
                this.max = v == null || v.isEmpty() ? 0.0f : Float.parseFloat(v.replace(',', '.'));
                this.oscPacketId = m.group(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getOscPacketId() {
        return this.oscPacketId;
    }

    public String toString() {
        return String.format("OSCMapping [animationId=%s, oscPacketId=%s, argMatcher=%s, argumentId=%s, min=%s, max=%s, boolOnly=%s]", this.animationId, this.oscPacketId, this.argMatcher, this.argumentId, Float.valueOf(this.min), Float.valueOf(this.max), this.boolOnly);
    }

    public void applyOsc(List<Object> args) {
        if (args != null && args.size() > this.argumentId && (this.argMatcher == null || this.argMatcher.equals(args.get(0)))) {
            Object arg = args.get(this.argumentId);
            int newVal = -1;
            if (arg instanceof Boolean) {
                boolean b = (Boolean)arg;
                newVal = b ? 255 : 0;
            } else if (arg instanceof Integer) {
                int a = (Integer)arg;
                if (this.min == this.max) {
                    newVal = MathHelper.clamp((int)a, (int)0, (int)255);
                } else {
                    float v = ((float)a - this.min) / (this.max - this.min);
                    newVal = (int)(MathHelper.clamp((float)v, (float)0.0f, (float)1.0f) * 255.0f);
                }
            } else if (arg instanceof Number) {
                float a = ((Number)arg).floatValue();
                if (this.min == this.max) {
                    newVal = (int)(MathHelper.clamp((float)a, (float)0.0f, (float)1.0f) * 255.0f);
                } else {
                    float v = (a - this.min) / (this.max - this.min);
                    newVal = (int)(MathHelper.clamp((float)v, (float)0.0f, (float)1.0f) * 255.0f);
                }
            }
            this.currentValue = this.boolOnly ? (newVal > 127 ? 1 : 0) : newVal;
        }
    }

    public void tick() {
        if (this.currentValue != this.previousValue) {
            this.previousValue = this.currentValue;
            CPMOSC.api.playAnimation(this.animationId, this.currentValue);
        }
    }

    public OSCDataPanel.OSCChannel toChannel() {
        return new OSCDataPanel.OSCChannel(this.oscPacketId, this.argMatcher, this.argumentId, this.min, this.max);
    }
}

