/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc;

import com.tom.cpmoscc.CPMOSC;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class CPMOSCClientForge {
    public static final CPMOSCClientForge INSTANCE = new CPMOSCClientForge();
    private static final String[] IS_PAUSED = new String[]{"isPaused", "func_147113_T", "m_91104_"};
    private static final String[] PLAYER = new String[]{"player", "field_71439_g", "f_91074_"};
    private static BooleanSupplier isPaused;
    private static Supplier<Object> getPlayer;

    public void init() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        CPMOSC.LOGGER.info("CPM OSC initialized", new Object[0]);
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent evt) {
        if (evt.phase == TickEvent.Phase.START || isPaused.getAsBoolean()) {
            return;
        }
        CPMOSC.tick(getPlayer.get());
    }

    static {
        Minecraft inst = null;
        try {
            for (Method method : Minecraft.class.getDeclaredMethods()) {
                if (!Modifier.isStatic(method.getModifiers()) || method.getReturnType() != Minecraft.class) continue;
                inst = (Minecraft)method.invoke(null, new Object[0]);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        if (inst == null) {
            throw new NoSuchMethodError("Failed to find Minecraft.getInstance()");
        }
        try {
            Method isPausedM = null;
            for (String m : IS_PAUSED) {
                try {
                    isPausedM = Minecraft.class.getDeclaredMethod(m, new Class[0]);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (isPausedM == null) {
                throw new RuntimeException("Failed to find Minecraft.isPaused()");
            }
            Field playerF = null;
            for (String m : PLAYER) {
                try {
                    playerF = Minecraft.class.getDeclaredField(m);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (playerF == null) {
                throw new RuntimeException("Failed to find Minecraft.player");
            }
            Method ip = isPausedM;
            Field pf = playerF;
            Minecraft i = inst;
            isPaused = () -> {
                try {
                    return (Boolean)ip.invoke((Object)i, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    return false;
                }
            };
            getPlayer = () -> {
                try {
                    return pf.get(i);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    return false;
                }
            };
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

