/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpmoscc;

import com.tom.cpl.block.Biome;
import com.tom.cpl.block.BlockState;
import com.tom.cpl.block.World;
import com.tom.cpl.item.Inventory;
import com.tom.cpl.item.NamedSlot;
import com.tom.cpl.item.Stack;
import com.tom.cpl.tag.TagManager;
import com.tom.cpm.api.IClientAPI;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationRegistry;
import com.tom.cpm.shared.animation.AnimationState;
import com.tom.cpm.shared.animation.AnimationType;
import com.tom.cpm.shared.animation.CustomPose;
import com.tom.cpm.shared.animation.Gesture;
import com.tom.cpm.shared.animation.ServerAnimationState;
import com.tom.cpm.shared.animation.VanillaPose;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.network.ServerCaps;
import com.tom.cpm.shared.util.ErrorLog;
import com.tom.cpmoscc.OSCLog;
import com.tom.cpmoscc.OSCMessageManager;
import com.tom.cpmoscc.OSCReceiver;
import com.tom.cpmoscc.OSCTransmitter;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CPMOSC {
    public static final OSCLog LOGGER = OSCLog.getLogger("OSC");
    public static final String OSC_ENABLE = "cpmosc_enable";
    public static final String OSC_ENABLE_TRANSMIT = "cpmosc_enable_transmit";
    public static final String OSC_PORT_KEY = "cpmosc_receive_port";
    public static final String OSC_OUT_KEY = "cpmosc_transmit_port";
    public static final String MOD_ID = "cpmoscc";
    public static final String VERSION_CHECK_URL = "https://raw.githubusercontent.com/tom5454/CustomPlayerModels/master/CPM-OSC-Compat/version-check.json";
    public static IClientAPI api;
    private static OSCReceiver osc;
    private static OSCTransmitter transmit;
    public static WeakReference<ModelDefinition> currentDefinition;
    public static OSCMessageManager manager;
    private static final Field[] outputFields;
    private static final Field[] outputFields2;

    public static void tick(Object playerIn) {
        if (MinecraftClientAccess.get() != null && MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED && api != null && CPMOSC.isEnabled()) {
            CPMOSC.getOsc();
            Player player = MinecraftClientAccess.get().getCurrentClientPlayer();
            if (player != null) {
                ModelDefinition def = player.getModelDefinition();
                if (def != null && currentDefinition.get() != def) {
                    manager.update(def);
                    currentDefinition = new WeakReference<ModelDefinition>(def);
                }
                manager.tick();
                if (ModConfig.getCommonConfig().getBoolean(OSC_ENABLE_TRANSMIT, false)) {
                    String outputAddr;
                    if (transmit == null && !(transmit = new OSCTransmitter(outputAddr = ModConfig.getCommonConfig().getString(OSC_OUT_KEY, "localhost:9001"))).canSend()) {
                        ErrorLog.addLog((ErrorLog.LogLevel)ErrorLog.LogLevel.WARNING, (String)"OSC Transmitter error", (Throwable)transmit.getError());
                    }
                    player.updatePlayer(playerIn);
                    long time = MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().getTime();
                    AnimationState st = player.animState;
                    try {
                        for (Field f : outputFields) {
                            CPMOSC.send(st, f);
                        }
                        for (Field f : outputFields2) {
                            CPMOSC.send(st.localState, f);
                        }
                        if (def != null) {
                            World w;
                            AnimationRegistry reg = def.getAnimations();
                            reg.forEachLayer((g, id) -> {
                                if (g.command) {
                                    return;
                                }
                                String gid = g.getName().replaceAll("[^a-zA-Z0-9\\.\\-]", "");
                                if (gid.isEmpty()) {
                                    gid = "unnamed" + id;
                                }
                                try {
                                    if (st.gestureData.length > id) {
                                        if (g.type == AnimationType.VALUE_LAYER) {
                                            transmit.send("/cpm/layer/" + gid + "/value", st.gestureData[id]);
                                        } else {
                                            transmit.send("/cpm/layer/" + gid + "/toggle", st.gestureData[id] != 0);
                                        }
                                    } else if (g.type == AnimationType.VALUE_LAYER) {
                                        transmit.send("/cpm/layer/" + gid + "/value", g.defVal);
                                    } else {
                                        transmit.send("/cpm/layer/" + gid + "/toggle", g.defVal != 0);
                                    }
                                }
                                catch (IOException iOException) {
                                    // empty catch block
                                }
                            });
                            int gesture = st.encodedState;
                            Gesture g2 = null;
                            g2 = MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES) && st.gestureData != null && st.gestureData.length > 1 ? reg.getGesture((int)st.gestureData[1]) : reg.getGesture(gesture);
                            transmit.send("/cpm/gesture", g2 != null ? g2.getName().replaceAll("[^a-zA-Z0-9\\.\\-]", "") : "null");
                            VanillaPose pose = st.getMainPose(time, reg);
                            CPMOSC.sendEnum("/cpm/vanilla_pose", pose);
                            VanillaPose currentPose = pose;
                            if (MinecraftClientAccess.get().getNetHandler().hasServerCap(ServerCaps.GESTURES) && st.gestureData != null && st.gestureData.length > 1) {
                                if (st.gestureData[0] != 0) {
                                    currentPose = reg.getPose((int)st.gestureData[0], player.currentPose);
                                }
                            } else {
                                currentPose = reg.getPose(gesture, player.currentPose);
                            }
                            if (currentPose instanceof VanillaPose) {
                                VanillaPose e2 = currentPose;
                                CPMOSC.sendEnum("/cpm/pose", e2);
                            } else if (currentPose instanceof CustomPose) {
                                CustomPose p = (CustomPose)currentPose;
                                transmit.send("/cpm/pose/name", p.getId());
                                transmit.send("/cpm/pose/id", -1);
                            }
                            if (st.playerInventory != null) {
                                Inventory i = st.playerInventory;
                                CPMOSC.sendItem(def, "held_item", CPMOSC.getStackTemp(i, i.getNamedSlotId(NamedSlot.MAIN_HAND)));
                                CPMOSC.sendItem(def, "armor/helmet", CPMOSC.getStackTemp(i, i.getNamedSlotId(NamedSlot.ARMOR_HELMET)));
                                CPMOSC.sendItem(def, "armor/chestplate", CPMOSC.getStackTemp(i, i.getNamedSlotId(NamedSlot.ARMOR_CHESTPLATE)));
                                CPMOSC.sendItem(def, "armor/leggings", CPMOSC.getStackTemp(i, i.getNamedSlotId(NamedSlot.ARMOR_LEGGINGS)));
                                CPMOSC.sendItem(def, "armor/boots", CPMOSC.getStackTemp(i, i.getNamedSlotId(NamedSlot.ARMOR_BOOTS)));
                                CPMOSC.sendItem(def, "off_hand", CPMOSC.getStackTemp(i, i.getNamedSlotId(NamedSlot.OFF_HAND)));
                                transmit.send("/cpm/heldSlot", i.getNamedSlotId(NamedSlot.MAIN_HAND));
                            }
                            if ((w = st.world) != null) {
                                CPMOSC.sendBlock(def, "below", w.getBlock(0, -1, 0));
                                CPMOSC.sendBlock(def, "feet", w.getBlock(0, 0, 0));
                                CPMOSC.sendBlock(def, "head", w.getBlock(0, 1, 0));
                                transmit.send("/cpm/world/canSeeSky", w.isCovered());
                                CPMOSC.sendEnum("/cpm/world/weather", w.getWeather());
                                transmit.send("/cpm/world/y", Float.valueOf((float)(w.getYHeight() - w.getMinHeight()) / (float)(w.getMaxHeight() - w.getMinHeight())), w.getYHeight(), w.getMinHeight(), w.getMaxHeight());
                                Biome b = w.getBiome();
                                transmit.send("/cpm/world/biome/id", b.getBiomeId());
                                transmit.send("/cpm/world/biome/tags", CPMOSC.listTags(def.modelTagManager.getBiomeTags(), b));
                                CPMOSC.sendEnum("/cpm/world/biome/rainType", b.getRainType());
                                transmit.send("/cpm/world/biome/temperature", Float.valueOf(b.getTemperature()));
                                transmit.send("/cpm/world/biome/humidity", Float.valueOf(b.getHumidity()));
                            }
                            if (st.vehicle != null) {
                                transmit.send("/cpm/vehicle/id", st.vehicle.getId());
                                transmit.send("/cpm/vehicle/tags", CPMOSC.listTags(def.modelTagManager.getEntityTags(), st.vehicle));
                            } else {
                                transmit.send("/cpm/vehicle/id", "null");
                                transmit.send("/cpm/vehicle/tags", new Object[0]);
                            }
                            transmit.send("/cpm/potion", st.allEffects.stream().flatMap(e -> Stream.of(e.effectId, e.amplifier, e.duration, e.hidden)).toArray());
                        }
                        transmit.send("/cpm/gameTime", time);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
    }

    private static Stack getStackTemp(Inventory t, int i) {
        if (i >= 0 && i < t.size()) {
            return t.getInSlot(i);
        }
        return Stack.EMPTY;
    }

    private static <T> List<String> listTags(TagManager<T> mngr, T e) {
        return mngr.listStackTags(e).stream().map(t -> t.getId()).collect(Collectors.toList());
    }

    private static void sendBlock(ModelDefinition def, String name, BlockState st) throws IOException {
        transmit.send("/cpm/world/" + name + "/id", st.getBlockId());
        transmit.send("/cpm/world/" + name + "/tags", CPMOSC.listTags(def.modelTagManager.getBlockTags(), st));
    }

    private static void sendItem(ModelDefinition def, String name, Stack stack) throws IOException {
        transmit.send("/cpm/" + name + "/id", stack.getItemId());
        transmit.send("/cpm/" + name + "/count", stack.getCount(), stack.getMaxCount());
        transmit.send("/cpm/" + name + "/damage", stack.getDamage(), stack.getMaxDamage());
        transmit.send("/cpm/" + name + "/tags", CPMOSC.listTags(def.modelTagManager.getItemTags(), stack));
    }

    private static void send(Object inst, Field f) throws Exception {
        Object v = f.get(inst);
        if (v instanceof Enum) {
            Enum e = (Enum)v;
            CPMOSC.sendEnum("/cpm/" + f.getName(), e);
        } else if (v instanceof Number || v instanceof Boolean) {
            transmit.send("/cpm/" + f.getName(), v);
        }
    }

    private static void sendEnum(String name, Enum<?> e) throws IOException {
        transmit.send(name + "/name", e.name());
        transmit.send(name + "/id", e.ordinal());
    }

    public static boolean isEnabled() {
        return ModConfig.getCommonConfig().getBoolean(OSC_ENABLE, false);
    }

    public static void resetOsc() {
        if (osc != null) {
            try {
                osc.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (transmit != null) {
            try {
                transmit.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        osc = null;
        transmit = null;
    }

    public static OSCReceiver getOsc() {
        if (osc == null) {
            osc = new OSCReceiver(ModConfig.getCommonConfig().getInt(OSC_PORT_KEY, 9000));
            if (osc.canStart()) {
                osc.start();
                LOGGER.info("Started OSC listener", new Object[0]);
            } else {
                ErrorLog.addLog((ErrorLog.LogLevel)ErrorLog.LogLevel.WARNING, (String)"OSC Receiver error", (Throwable)osc.getError());
            }
        }
        return osc;
    }

    static {
        currentDefinition = new WeakReference<Object>(null);
        manager = new OSCMessageManager();
        outputFields = AnimationState.class.getDeclaredFields();
        outputFields2 = ServerAnimationState.class.getDeclaredFields();
    }
}

