/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.MinimapLogs;
import xaero.common.icon.XaeroIcon;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconCache;
import xaero.common.minimap.render.radar.EntityIconKey;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.armor.EntityIconArmor;
import xaero.common.minimap.render.radar.armor.EntityIconArmorHandler;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.common.minimap.render.radar.resource.EntityIconDefinitionManager;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;
import xaero.common.minimap.render.radar.variant.EntityIconVariantHandler;

public class EntityIconManager {
    public static final XaeroIcon FAILED = new XaeroIcon(null, 0, 0);
    public static final XaeroIcon DOT = new XaeroIcon(null, 0, 0);
    private EntityIconPrerenderer prerenderer;
    private final IXaeroMinimap modMain;
    private Map<EntityType<?>, EntityIconCache> cachedIcons;
    private boolean canPrerender;
    private EntityIconModelConfig defaultModelConfig;
    private final EntityIconDefinitionManager definitionManager;
    private final EntityIconVariantHandler variantHandler;
    private final EntityIconArmorHandler armorHandler;

    public EntityIconManager(IXaeroMinimap modMain, EntityIconPrerenderer prerenderer) {
        this.modMain = modMain;
        this.prerenderer = prerenderer;
        this.definitionManager = new EntityIconDefinitionManager();
        this.variantHandler = new EntityIconVariantHandler();
        this.cachedIcons = new HashMap();
        this.definitionManager.reloadResources();
        this.defaultModelConfig = new EntityIconModelConfig();
        this.armorHandler = new EntityIconArmorHandler();
    }

    protected EntityIconCache getVariantIconCache(EntityType<?> entityType) {
        EntityIconCache result = this.cachedIcons.get(entityType);
        if (result == null) {
            result = new EntityIconCache(entityType);
            this.cachedIcons.put(entityType, result);
        }
        return result;
    }

    public <T extends Entity> XaeroIcon getEntityIcon(GuiGraphics guiGraphics, T entity, RenderTarget defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean debug, boolean debugEntityVariantIds) {
        EntityType entityType = entity.m_6095_();
        EntityIconDefinition iconDefinition = this.definitionManager.get(EntityType.m_20613_((EntityType)entityType));
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        EntityRenderer entityRenderer = renderManager.m_114382_(entity);
        Object variant = this.variantHandler.getEntityVariant(iconDefinition, entity, entityRenderer);
        while (GL11.glGetError() != 0) {
        }
        if (variant == null) {
            return null;
        }
        EntityIconArmor armor = null;
        if (entity instanceof LivingEntity && !(entity instanceof Player)) {
            armor = this.armorHandler.getArmor((LivingEntity)entity);
        }
        EntityIconCache entityIconCache = this.getVariantIconCache(entityType);
        EntityIconKey iconKey = new EntityIconKey(variant, armor);
        XaeroIcon cachedValue = entityIconCache.get(iconKey);
        if (entityIconCache.isInvalidVariantClass()) {
            return FAILED;
        }
        if (cachedValue == null) {
            ResourceLocation iconType;
            String entityVariantString;
            String variantMapKey = entityVariantString = entityIconCache.getVariantString(iconKey);
            if (iconDefinition != null) {
                ResourceLocation resourceLocation = iconType = variantMapKey == null ? null : iconDefinition.getVariantType(variantMapKey);
                if (iconType == null) {
                    variantMapKey = "default";
                    iconType = iconDefinition.getVariantType(variantMapKey);
                }
            } else {
                ResourceLocation resourceLocation = iconType = entity instanceof LivingEntity ? EntityIconDefinition.MODEL_TYPE : EntityIconDefinition.DOT_TYPE;
            }
            if (debugEntityVariantIds && entityVariantString != null && (this.canPrerender || iconType == EntityIconDefinition.DOT_TYPE)) {
                Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)entityVariantString));
            }
            if (iconType == EntityIconDefinition.MODEL_TYPE) {
                if (this.canPrerender) {
                    EntityIconModelConfig variantModelConfig;
                    EntityIconModelConfig modelConfig = this.defaultModelConfig;
                    EntityIconModelConfig entityIconModelConfig = variantModelConfig = iconDefinition == null ? null : iconDefinition.getModelConfig(variantMapKey);
                    if (variantModelConfig != null) {
                        modelConfig = variantModelConfig;
                    }
                    cachedValue = this.prerenderer.prerender(guiGraphics, variant, entityRenderer, entity, defaultFramebuffer, helper, scale, modelConfig, this.defaultModelConfig, null, true, false, debug);
                    entityIconCache.add(iconKey, cachedValue);
                    this.canPrerender = false;
                } else {
                    cachedValue = null;
                }
            } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                cachedValue = DOT;
                entityIconCache.add(iconKey, cachedValue);
            } else if (this.canPrerender) {
                ResourceLocation sprite = iconDefinition.getSprite(variantMapKey);
                boolean isOutlined = iconType == EntityIconDefinition.OUTLINED_SPRITE;
                boolean isFlipped = !isOutlined && iconType != EntityIconDefinition.NORMAL_SPRITE;
                cachedValue = this.prerenderer.prerender(guiGraphics, variant, entityRenderer, entity, defaultFramebuffer, helper, scale, null, this.defaultModelConfig, sprite, isOutlined, isFlipped, debug);
                entityIconCache.add(iconKey, cachedValue);
                this.canPrerender = false;
            } else {
                cachedValue = null;
            }
        }
        return cachedValue;
    }

    public void reset() {
        this.prerenderer.clearAtlases();
        this.cachedIcons.clear();
        MinimapLogs.LOGGER.info("Entity icon manager reset!");
    }

    public void resetResources() {
        this.definitionManager.reloadResources();
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelRenderDetection(EntityModel<?> model, VertexConsumer vertexConsumer, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelRenderDetection(model, vertexConsumer, red, green, blue, alpha);
    }

    public void onModelPartRenderDetection(ModelPart modelRenderer, float red, float green, float blue, float alpha) {
        this.prerenderer.onModelPartRenderDetection(modelRenderer, red, green, blue, alpha);
    }
}

