/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.interfaces.render;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.graphics.CustomVertexConsumers;
import xaero.common.graphics.shader.MinimapShaders;
import xaero.common.gui.GuiEditMode;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.pushbox.PushBox;
import xaero.common.misc.Misc;

public class InterfaceRenderer {
    public static final ResourceLocation guiTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final ResourceLocation minimapFrameTextures = new ResourceLocation("xaerobetterpvp", "gui/minimap_frame.png");
    private CustomVertexConsumers customVertexConsumers;
    private IXaeroMinimap modMain;
    private final int disabled = 1354612157;
    private final int enabled = 0x64FFFFFF;
    private final int selected = -2097152001;

    public InterfaceRenderer(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.customVertexConsumers = new CustomVertexConsumers();
    }

    public void renderInterfaces(XaeroMinimapSession minimapSession, GuiGraphics guiGraphics, float partial) {
        guiGraphics.m_280262_();
        while (GL11.glGetError() != 0) {
        }
        GlStateManager._clearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        MinimapShaders.ensureShaders();
        Minecraft mc = Minecraft.m_91087_();
        int width = mc.m_91268_().m_85445_();
        int height = mc.m_91268_().m_85446_();
        double scale = mc.m_91268_().m_85449_();
        int mouseX = (int)(Misc.getMouseX(mc, false) * (double)width / (double)mc.m_91268_().m_85441_());
        int mouseY = (int)(Misc.getMouseY(mc, false) * (double)height / (double)mc.m_91268_().m_85442_());
        InterfaceManager interfaceManager = this.modMain.getInterfaces();
        interfaceManager.updateInterfaces(minimapSession, mouseX, mouseY, width, height, scale);
        Iterator<Interface> iter = this.modMain.getInterfaces().getInterfaceIterator();
        while (iter.hasNext()) {
            Interface l = iter.next();
            InterfaceInstance ii = minimapSession.getInterfaceInstances().get(l);
            ii.prePotentialRender();
            if (!this.modMain.getSettings().getBooleanValue(l.getOption())) continue;
            int xBU = l.getX();
            int yBU = l.getY();
            interfaceManager.pushInterface(l, ii, scale, width, height);
            ii.render(guiGraphics, width, height, scale, partial, this.customVertexConsumers);
            l.setX(xBU);
            l.setY(yBU);
        }
        for (PushBox pb : interfaceManager.pushBoxes) {
            pb.postUpdate();
        }
        RenderSystem.enableDepthTest();
    }

    public void renderBoxes(GuiGraphics guiGraphics, int mouseX, int mouseY, int width, int height, double d) {
        if (this.modMain.getEvents().getLastGuiOpen() instanceof GuiEditMode) {
            XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
            int mouseOverId = this.modMain.getInterfaces().getInterfaceId(minimapSession, mouseX, mouseY, width, height, d);
            InterfaceManager interfaces = this.modMain.getInterfaces();
            Iterator<Interface> iter = interfaces.getInterfaceIterator();
            int i = -1;
            while (iter.hasNext()) {
                ++i;
                Interface l = iter.next();
                if (!this.modMain.getSettings().getBooleanValue(l.getOption())) continue;
                InterfaceInstance li = minimapSession.getInterfaceInstances().get(l);
                int x = l.getX();
                int y = l.getY();
                int w = li.getW(d);
                int h = li.getH(d);
                int x2 = x + w;
                int y2 = y + h;
                if (interfaces.getSelectedId() == i || !interfaces.overAButton(mouseX, mouseY) && mouseX >= x && mouseX <= x2 && mouseY >= y && mouseY <= y2 || i == interfaces.getDraggingId()) {
                    guiGraphics.m_280509_(x, y, x2, y2, interfaces.getSelectedId() == i ? -2097152001 : 0x64FFFFFF);
                    if (interfaces.getDraggingId() != -1 || i != mouseOverId) continue;
                    l.getcBox().drawBox(guiGraphics, mouseX, mouseY, width, height);
                    continue;
                }
                guiGraphics.m_280509_(x, y, x2, y2, 1354612157);
            }
        }
    }

    public CustomVertexConsumers getCustomVertexConsumers() {
        return this.customVertexConsumers;
    }
}

