/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.interfaces;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiEditMode;
import xaero.common.interfaces.IInterfaceLoader;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceInstance;
import xaero.common.interfaces.Preset;
import xaero.common.interfaces.pushbox.BossHealthPushBox;
import xaero.common.interfaces.pushbox.BossHealthShiftPushBox;
import xaero.common.interfaces.pushbox.IBossHealthPushBox;
import xaero.common.interfaces.pushbox.IPotionEffectsPushBox;
import xaero.common.interfaces.pushbox.PotionEffectsPushBox;
import xaero.common.interfaces.pushbox.PotionEffectsShiftPushBox;
import xaero.common.interfaces.pushbox.PushBox;
import xaero.common.minimap.MinimapInterface;

public class InterfaceManager {
    private IXaeroMinimap modMain;
    private Minecraft mc;
    private ArrayList<Preset> presets;
    private ArrayList<Interface> list;
    public ArrayList<PushBox> pushBoxes;
    private int actionTimer;
    private int selectedId;
    private int draggingId;
    private int draggingOffX;
    private int draggingOffY;
    private long lastFlip;
    public PotionEffectsPushBox normalPotionEffectsPushBox;
    public PotionEffectsShiftPushBox shiftPotionEffectsPushBox;
    private BossHealthPushBox normalBossHealthPushBox;
    private BossHealthShiftPushBox shiftBossHealthPushBox;

    public InterfaceManager(IXaeroMinimap modMain, IInterfaceLoader loader) throws IOException {
        this.modMain = modMain;
        this.presets = new ArrayList();
        this.list = new ArrayList();
        this.mc = Minecraft.m_91087_();
        this.selectedId = -1;
        this.draggingId = -1;
        this.normalPotionEffectsPushBox = new PotionEffectsPushBox();
        this.shiftPotionEffectsPushBox = new PotionEffectsShiftPushBox();
        this.normalBossHealthPushBox = new BossHealthPushBox();
        this.shiftBossHealthPushBox = new BossHealthShiftPushBox();
        this.pushBoxes = Lists.newArrayList((Object[])new PushBox[]{this.normalPotionEffectsPushBox, this.shiftPotionEffectsPushBox, this.normalBossHealthPushBox, this.shiftBossHealthPushBox});
        loader.loadPresets(this);
        loader.load(modMain, this);
    }

    public IPotionEffectsPushBox getPotionEffectPushBox() {
        int boxType = this.modMain.getSettings().potionEffectPushBox;
        return boxType == 0 ? null : (boxType == 2 ? this.shiftPotionEffectsPushBox : this.normalPotionEffectsPushBox);
    }

    public IBossHealthPushBox getBossHealthPushBox() {
        int boxType = this.modMain.getSettings().bossHealthPushBox;
        return boxType == 0 ? null : (boxType == 2 ? this.shiftBossHealthPushBox : this.normalBossHealthPushBox);
    }

    public MinimapInterface getMinimapInterface() {
        return (MinimapInterface)this.list.get(4);
    }

    public boolean overAButton(int mouseX, int mouseY) {
        if (this.mc.f_91080_ instanceof GuiEditMode) {
            for (GuiEventListener el : this.mc.f_91080_.m_6702_()) {
                Button b;
                if (!(el instanceof Button) || mouseX < (b = (Button)el).m_252754_() || mouseY < b.m_252907_() || mouseX >= b.m_252754_() + 150 || mouseY >= b.m_252907_() + 20) continue;
                return true;
            }
        }
        return false;
    }

    protected void updateBlinkingOverridable() {
    }

    public void updateInterfaces(XaeroMinimapSession minimapSession, int mouseX, int mouseY, int width, int height, double scale) {
        Screen screen = (Screen)this.modMain.getEvents().getLastGuiOpen();
        if (this.actionTimer <= 0) {
            this.updateBlinkingOverridable();
            if (screen instanceof GuiEditMode) {
                int i;
                GuiEditMode editModeScreen = (GuiEditMode)screen;
                if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)256)) {
                    this.selectedId = -1;
                }
                if ((i = this.getInterfaceId(minimapSession, mouseX, mouseY, width, height, scale)) == -1) {
                    i = this.selectedId;
                }
                if (i != -1) {
                    if (editModeScreen.mouseDown && this.draggingId == -1) {
                        this.draggingId = i;
                        this.selectedId = i;
                        this.draggingOffX = this.list.get(i).getX() - mouseX;
                        this.draggingOffY = this.list.get(i).getY() - mouseY;
                    } else if (!editModeScreen.mouseDown && this.draggingId != -1) {
                        this.draggingId = -1;
                        this.draggingOffX = 0;
                        this.draggingOffY = 0;
                    }
                    if (this.selectedId != -1) {
                        i = this.selectedId;
                    }
                    if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)70) && System.currentTimeMillis() - this.lastFlip > 300L) {
                        this.lastFlip = System.currentTimeMillis();
                        this.list.get(i).setFlipped(!this.list.get(i).isFlipped());
                    }
                    if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)67) && System.currentTimeMillis() - this.lastFlip > 300L) {
                        this.lastFlip = System.currentTimeMillis();
                        this.list.get(i).setCentered(!this.list.get(i).isCentered());
                    }
                    if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)83)) {
                        this.selectedId = -1;
                        this.draggingId = -1;
                        this.modMain.getGuiHelper().openInterfaceSettings(i);
                    }
                }
                if (this.draggingId != -1) {
                    Interface dragged = this.list.get(this.draggingId);
                    if (!dragged.isCentered()) {
                        dragged.setActualx(mouseX + this.draggingOffX);
                        if (dragged.isFromRight()) {
                            dragged.setActualx(width - dragged.getActualx());
                        }
                    }
                    int centerX = dragged.getActualx() + dragged.getW() / 2 * (dragged.isFromRight() ? -1 : 1);
                    if (dragged.isFromRight() && (width & 1) == 0) {
                        ++centerX;
                    }
                    if (centerX > width / 2) {
                        dragged.setFromRight(!dragged.isFromRight());
                        dragged.setActualx(width - dragged.getActualx());
                    }
                    dragged.setActualy(mouseY + this.draggingOffY);
                    if (dragged.isFromBottom()) {
                        dragged.setActualy(height - dragged.getActualy());
                    }
                    int centerY = dragged.getActualy() + dragged.getH() / 2 * (dragged.isFromBottom() ? -1 : 1);
                    if (dragged.isFromBottom() && (height & 1) == 0) {
                        ++centerY;
                    }
                    if (centerY > height / 2) {
                        dragged.setFromBottom(!dragged.isFromBottom());
                        dragged.setActualy(height - dragged.getActualy());
                    }
                }
            }
        } else {
            --this.actionTimer;
        }
        for (Interface j : this.list) {
            InterfaceInstance ji = minimapSession.getInterfaceInstances().get(j);
            j.setX(j.getActualx());
            j.setY(j.getActualy());
            if (j.isFromRight()) {
                j.setX(width - j.getX());
            }
            if (j.isFromBottom()) {
                j.setY(height - j.getY());
            }
            if (j.isCentered()) {
                if (j.isMulti()) {
                    j.setW(ji.getWC(scale));
                    j.setH(ji.getHC(scale));
                }
                j.setX(width / 2 - ji.getW(scale) / 2);
            } else if (j.isMulti()) {
                j.setW(ji.getW0(scale));
                j.setH(ji.getH0(scale));
            }
            if (j.getX() < 5) {
                j.setX(0);
            }
            if (j.getY() < 5) {
                j.setY(0);
            }
            if (j.getX() + ji.getW(scale) > width - 5) {
                j.setX(width - ji.getW(scale));
            }
            if (j.getY() + ji.getH(scale) <= height - 5) continue;
            j.setY(height - ji.getH(scale));
        }
        for (PushBox pb : this.pushBoxes) {
            pb.update();
        }
    }

    public void pushInterface(Interface j, InterfaceInstance ji, double scale, int width, int height) {
        for (PushBox pb : this.pushBoxes) {
            boolean bottomBlocked;
            boolean rightBlocked;
            if (!pb.isActive()) continue;
            int interfaceX = j.getX();
            int interfaceY = j.getY();
            int interfaceW = ji.getW(scale);
            int interfaceH = ji.getH(scale);
            int pushBoxX = (int)((float)width * pb.getAnchorX()) + pb.getX(width, height);
            int pushBoxY = (int)((float)height * pb.getAnchorY()) + pb.getY(width, height);
            int pushBoxW = pb.getW(width, height);
            int pushBoxH = pb.getH(width, height);
            int minPushX = 0;
            int minPushY = 0;
            int overLeftSide = interfaceX + interfaceW - pushBoxX;
            int overRightSide = interfaceX - (pushBoxX + pushBoxW);
            int overTopSide = interfaceY + interfaceH - pushBoxY;
            int overBottomSide = interfaceY - (pushBoxY + pushBoxH);
            if (overLeftSide <= 0 || overRightSide >= 0 || overTopSide <= 0 || overBottomSide >= 0) continue;
            boolean leftBlocked = interfaceX - overLeftSide < 0;
            boolean bl = rightBlocked = interfaceX - overRightSide + interfaceW > width;
            minPushX = leftBlocked == rightBlocked ? (-overRightSide < overLeftSide ? overRightSide : overLeftSide) : (leftBlocked ? overRightSide : overLeftSide);
            boolean topBlocked = interfaceY - overTopSide < 0;
            boolean bl2 = bottomBlocked = interfaceY - overBottomSide + interfaceH > height;
            if (topBlocked == bottomBlocked) {
                minPushY = -overBottomSide < overTopSide ? overBottomSide : overTopSide;
            } else {
                int n = minPushY = topBlocked ? overBottomSide : overTopSide;
            }
            if ((!leftBlocked || !rightBlocked || topBlocked && bottomBlocked) && Math.abs(minPushX) < Math.abs(minPushY) - pb.getVerticalBias()) {
                pb.push(ji, j, interfaceX, interfaceY, interfaceW, interfaceH, -minPushX, 0, width, height);
                continue;
            }
            pb.push(ji, j, interfaceX, interfaceY, interfaceW, interfaceH, 0, -minPushY, width, height);
        }
    }

    public int getInterfaceId(XaeroMinimapSession minimapSession, int mouseX, int mouseY, int width, int height, double scale) {
        int toReturn = -1;
        int size = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            Interface l = this.list.get(i);
            if (!this.modMain.getSettings().getBooleanValue(l.getOption())) continue;
            InterfaceInstance li = minimapSession.getInterfaceInstances().get(l);
            int x = l.getX();
            int y = l.getY();
            int x2 = x + li.getW(scale);
            int y2 = y + li.getH(scale);
            int isize = li.getSize();
            if (l.getIname().equals("dummy") || size != 0 && isize >= size || this.overAButton(mouseX, mouseY) || mouseX < x || mouseX >= x2 || mouseY < y || mouseY >= y2) continue;
            size = isize;
            toReturn = i;
        }
        return toReturn;
    }

    public void add(Interface i) {
        this.list.add(i);
    }

    public Preset getDefaultPreset() {
        return this.presets.get(0);
    }

    public Preset getPreset(int id) {
        return this.presets.get(id);
    }

    public int getNextId() {
        return this.list.size();
    }

    public void addPreset(Preset preset) {
        this.presets.add(preset);
    }

    public int getSelectedId() {
        return this.selectedId;
    }

    public void setSelectedId(int selectedId) {
        this.selectedId = selectedId;
    }

    public int getDraggingId() {
        return this.draggingId;
    }

    public void setDraggingId(int draggingId) {
        this.draggingId = draggingId;
    }

    public Iterator<Interface> getInterfaceIterator() {
        return this.list.iterator();
    }

    public Iterator<Preset> getPresetsIterator() {
        return this.presets.iterator();
    }

    public int getActionTimer() {
        return this.actionTimer;
    }

    public void setActionTimer(int actionTimer) {
        this.actionTimer = actionTimer;
    }

    public void onPostGameOverlay() {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession != null) {
            for (Interface inter : this.list) {
                InterfaceInstance ii = minimapSession.getInterfaceInstances().get(inter);
                ii.onPostGameOverlay();
            }
        }
    }
}

