/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.network.packet;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.nbt.NBTTagCompound;
import com.tom.cpl.text.FormatText;
import com.tom.cpl.text.KeybindText;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.ConfigChangeRequest;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.network.NetH;
import com.tom.cpm.shared.network.NetHandler;
import com.tom.cpm.shared.network.packet.HelloC2S;
import com.tom.cpm.shared.network.packet.NBTS2C;
import com.tom.cpm.shared.util.ScalingOptions;
import java.util.EnumMap;

public class HelloS2C
extends NBTS2C {
    public HelloS2C(NBTTagCompound data) {
        super(data);
    }

    public HelloS2C() {
    }

    @Override
    public void handle(NetHandler<?, ?, ?> handler, NetH net) {
        NBTTagCompound scaling = this.tag.getCompoundTag("scaling");
        EnumMap<ScalingOptions, Float> scalingMap = new EnumMap<ScalingOptions, Float>(ScalingOptions.class);
        for (ScalingOptions o : ScalingOptions.VALUES) {
            float v = scaling.getFloat(o.getNetKey());
            scalingMap.put(o, Float.valueOf(v));
        }
        handler.handleServerCaps(this.tag.getCompoundTag("caps"));
        String server = MinecraftClientAccess.get().getConnectedServer();
        ModConfigFile cc = ModConfig.getCommonConfig();
        ConfigEntry ss = cc.getEntry("serverSettings");
        if (server != null && ss.hasEntry(server) && ss.getEntry(server).getBoolean("disableNet", false)) {
            int kickTime = this.tag.getInteger("kickTime");
            if (kickTime > 0) {
                handler.getRecommendedSettingChanges().clear();
                handler.getRecommendedSettingChanges().add(new ConfigChangeRequest<String, Boolean>("disableNet", true, false));
                handler.displayText(new FormatText("chat.cpm.serverRequiresCPM", new KeybindText("key.cpm.gestureMenu", "gestureMenu")));
            }
            return;
        }
        net.cpm$setHasMod(true);
        MinecraftClientAccess.get().getDefinitionLoader().clearServerData();
        handler.sendPacketToServer(new HelloC2S(0));
        MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().setServerScaling(scalingMap);
    }
}

