/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui.panel;

import com.tom.cpl.gui.Frame;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.MouseEvent;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.ConfirmPopup;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpl.gui.elements.Panel;
import com.tom.cpl.gui.elements.ScrollPanel;
import com.tom.cpl.gui.elements.Tooltip;
import com.tom.cpl.math.Box;
import com.tom.cpl.math.Vec2i;
import com.tom.cpl.util.Image;
import com.tom.cpl.util.ImageIO;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.animation.AnimationEngine;
import com.tom.cpm.shared.animation.AnimationHandler;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.Player;
import com.tom.cpm.shared.definition.ModelDefinition;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.gui.SelectSkinPopup;
import com.tom.cpm.shared.gui.SkinUploadPopup;
import com.tom.cpm.shared.gui.ViewportCamera;
import com.tom.cpm.shared.gui.panel.ModelDisplayPanel;
import com.tom.cpm.shared.io.IOHelper;
import com.tom.cpm.shared.io.ModelFile;
import com.tom.cpm.shared.model.SkinType;
import com.tom.cpm.shared.skin.TextureProvider;
import com.tom.cpm.shared.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;

public class ModelsPanel
extends Panel
implements ModelDisplayPanel.IModelDisplayPanel {
    private ViewportCamera camera;
    private Frame frm;
    private ScrollPanel list;
    private ModelDisplayPanel display;
    private ModelDefinition selectedDef;
    private String selected;
    private List<ListPanel> panels;
    private List<Consumer<Vec2i>> sizeSetters;
    private Button set;
    private Button upload;
    private Button simpleSkin;
    private boolean doRender = true;
    private AnimationHandler animHandler;
    private String selectedFolder = "";
    private Vec2i size = new Vec2i(0, 0);

    public ModelsPanel(Frame frm, ViewportCamera camera) {
        super(frm.getGui());
        this.frm = frm;
        this.camera = camera;
        this.sizeSetters = new ArrayList<Consumer<Vec2i>>();
        this.animHandler = new AnimationHandler(this::getSelectedDefinition, AnimationEngine.AnimationMode.GUI);
        this.list = new ScrollPanel(this.gui);
        this.list.setBounds(new Box(0, 0, 0, 0));
        this.loadModelList();
        this.addElement(this.list);
        this.display = new ModelDisplayPanel(frm, this);
        this.display.setLoadingText(this.gui.i18nFormat("label.cpm.loading", new Object[0]));
        this.addElement(this.display);
        this.set = new Button(this.gui, this.gui.i18nFormat("button.cpm.applySkin", new Object[0]), this::applySelected);
        this.set.setEnabled(false);
        this.addElement(this.set);
        if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.OFFLINE) {
            this.upload = new Button(this.gui, this.gui.i18nFormat("button.cpm.uploadSkin", new Object[0]), this::uploadSelected);
            this.upload.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.uploadSkin", new Object[0])));
            this.upload.setEnabled(false);
            this.addElement(this.upload);
            this.simpleSkin = new Button(this.gui, this.gui.i18nFormat("button.cpm.changeSkin", new Object[0]), () -> {
                SelectSkinPopup ssp = new SelectSkinPopup(frm, SkinType.DEFAULT, (type, img) -> frm.openPopup(new ConfirmPopup(frm, this.gui.i18nFormat("label.cpm.export.upload", new Object[0]), this.gui.i18nFormat("label.cpm.export.upload.desc", new Object[0]), () -> this.upload((SkinType)((Object)((Object)type)), (Image)img), null)));
                ssp.setOnClosed(() -> {
                    this.doRender = true;
                });
                this.doRender = false;
                frm.openPopup(ssp);
            });
            this.simpleSkin.setTooltip(new Tooltip(frm, this.gui.i18nFormat("tooltip.cpm.changeSkin", new Object[0])));
            this.addElement(this.simpleSkin);
        }
        Player<?> player = MinecraftClientAccess.get().getCurrentClientPlayer();
        player.getDefinitionFuture().thenAccept(d -> {
            if (this.selectedDef == null) {
                this.selectedDef = d;
            }
            this.animHandler.clear();
        });
        if (player.forcedSkin) {
            Label lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.skinForced", new Object[0]));
            lbl.setColor(-65536);
            lbl.setBounds(new Box(40, 30, 0, 0));
            this.addElement(lbl);
        }
    }

    private void loadModelList() {
        this.sizeSetters.clear();
        Panel panel = new Panel(this.gui);
        File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models/" + this.selectedFolder);
        File[] fs = modelsDir.exists() ? modelsDir.listFiles((f, n) -> n.endsWith(".cpmmodel") || new File(f, n).isDirectory()) : null;
        String model = ModConfig.getCommonConfig().getString("selectedModel", null);
        if (!this.selectedFolder.isEmpty()) {
            Button moveUp = new Button(this.gui, ".. (" + this.selectedFolder + ")", () -> {
                if (this.selectedFolder.contains("/")) {
                    int i = this.selectedFolder.lastIndexOf(47);
                    this.selectedFolder = this.selectedFolder.substring(0, i);
                } else {
                    this.selectedFolder = "";
                }
                this.loadModelList();
            });
            this.sizeSetters.add(s -> moveUp.setBounds(new Box(0, 0, s.x, 20)));
            panel.addElement(moveUp);
        } else {
            Button reset = new Button(this.gui, this.gui.i18nFormat(model == null ? "button.cpm.reset_skin.sel" : "button.cpm.reset_skin", new Object[0]), () -> {
                ModConfig.getCommonConfig().clearValue("selectedModel");
                ModConfig.getCommonConfig().save();
                if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
                    MinecraftClientAccess.get().sendSkinUpdate();
                }
                this.loadModelList();
            });
            this.sizeSetters.add(s -> reset.setBounds(new Box(0, 0, s.x, 20)));
            panel.addElement(reset);
        }
        this.sizeSetters.add(s -> panel.setBounds(new Box(0, 0, s.x, 40)));
        this.panels = new ArrayList<ListPanel>();
        if (fs == null || fs.length == 0) {
            lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.no_models", new Object[0]));
            lbl.setBounds(new Box(5, 25, 0, 0));
            panel.addElement(lbl);
        } else {
            lbl = new Label(this.gui, this.gui.i18nFormat("label.cpm.loading", new Object[0]));
            lbl.setBounds(new Box(5, 25, 0, 0));
            MinecraftClientAccess.get().getDefinitionLoader().execute(() -> {
                int y = 20;
                for (int i = 0; i < fs.length; ++i) {
                    if (fs[i].getName().equals(".temp.cpmmodel") || fs[i].getName().equals("autosaves")) continue;
                    try {
                        ListPanel p = fs[i].isDirectory() ? new FolderPanel(this.gui, fs[i], y) : new ModelPanel(this.gui, ModelFile.load(fs[i]), model != null && this.getFullPath(fs[i].getName()).equals(model), y);
                        y += ((ListPanel)p).getHeight();
                        this.panels.add(p);
                        continue;
                    }
                    catch (Exception e) {
                        Log.warn("Error loading model: " + fs[i].getName(), e);
                    }
                }
                int fy = y;
                MinecraftClientAccess.get().executeOnGameThread(() -> {
                    this.panels.forEach(panel::addElement);
                    if (panel.getBounds() != null) {
                        int w = panel.getBounds().w;
                        this.panels.forEach(p -> p.setSize(w));
                        panel.setBounds(new Box(0, 0, w, fy));
                    }
                    this.sizeSetters.add(s -> {
                        panel.setBounds(new Box(0, 0, s.x, fy));
                        this.panels.forEach(p -> p.setSize(s.x));
                    });
                    panel.getElements().remove(lbl);
                });
            });
        }
        this.list.setDisplay(panel);
        panel.setBackgroundColor(this.gui.getColors().panel_background & 0xFFFFFF | Integer.MIN_VALUE);
        this.sizeSetters.forEach(c -> c.accept(this.size));
        this.list.setScrollY(0);
    }

    private String getFullPath(String name) {
        return this.selectedFolder.isEmpty() ? name : this.selectedFolder + "/" + name;
    }

    public void setSize(int width, int height) {
        Vec2i s = new Vec2i(width / 2 - 30, height - 50);
        this.list.setBounds(new Box(20, 40, s.x, s.y));
        this.size = s;
        this.sizeSetters.forEach(c -> c.accept(s));
        int dispSize = Math.min(width / 2 - 40, height - 100);
        if (this.upload != null) {
            this.set.setBounds(new Box(width / 2 + dispSize / 2 - 102, height / 2 + dispSize / 2 + 10, 100, 20));
            this.upload.setBounds(new Box(width / 2 + dispSize / 2 + 2, height / 2 + dispSize / 2 + 10, 100, 20));
            this.simpleSkin.setBounds(new Box(width / 2 + dispSize / 2 - 50, 5, 100, 20));
        } else {
            this.set.setBounds(new Box(width / 2 + dispSize / 2 - 50, height / 2 + dispSize / 2 + 10, 100, 20));
        }
        this.display.setBounds(new Box(width / 2 + 10, height / 2 - dispSize / 2, dispSize, dispSize));
        this.setBounds(new Box(0, 0, width, height));
    }

    @Override
    public ModelDefinition getSelectedDefinition() {
        if (this.selectedDef != null) {
            if (this.selectedDef.getResolveState() == ModelDefinition.ModelLoadingState.NEW) {
                this.selectedDef.startResolve();
            } else if (this.selectedDef.getResolveState() == ModelDefinition.ModelLoadingState.LOADED) {
                return this.selectedDef;
            }
        }
        return null;
    }

    @Override
    public void preRender() {
        if (this.getSelectedDefinition() != null) {
            MinecraftClientAccess.get().getPlayerRenderManager().getAnimationEngine().handleGuiAnimation(this.animHandler, this.getSelectedDefinition());
        }
    }

    private void applySelected() {
        ModConfig.getCommonConfig().setString("selectedModel", this.selected);
        ModConfig.getCommonConfig().save();
        if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
            MinecraftClientAccess.get().sendSkinUpdate();
        }
        this.loadModelList();
    }

    private void uploadSelected() {
        if (this.selected != null) {
            ModelFile file;
            File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models");
            File modelF = new File(modelsDir, this.selected);
            try {
                file = ModelFile.load(modelF);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            if (!file.convertable()) {
                this.frm.openPopup(new MessagePopup(this.frm, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.skinUpload.fail", this.gui.i18nFormat("label.cpm.modelNotSkinCompatible", new Object[0]))));
                return;
            }
            SelectSkinPopup ssp = new SelectSkinPopup(this.frm, SkinType.DEFAULT, (type, img) -> this.frm.openPopup(new ConfirmPopup(this.frm, this.gui.i18nFormat("label.cpm.export.upload", new Object[0]), this.gui.i18nFormat("label.cpm.export.upload.desc", new Object[0]), () -> Exporter.convert(file, img, type, out -> this.upload((SkinType)((Object)type), (Image)out), () -> this.frm.openPopup(new MessagePopup(this.frm, this.gui.i18nFormat("label.cpm.error", new Object[0]), this.gui.i18nFormat("label.cpm.skinUpload.fail", this.gui.i18nFormat("label.cpm.convertFail", new Object[0]))))), null)));
            ssp.setOnClosed(() -> {
                this.doRender = true;
            });
            this.doRender = false;
            this.frm.openPopup(ssp);
        }
    }

    private void upload(SkinType type, Image img) {
        new SkinUploadPopup(this.frm, type, img).start();
    }

    public void onClosed() {
        this.panels.forEach(ListPanel::onClosed);
    }

    @Override
    public ViewportCamera getCamera() {
        return this.camera;
    }

    @Override
    public boolean doRender() {
        return this.doRender;
    }

    public void filesDropped(List<File> files) {
        File modelsDir = new File(MinecraftClientAccess.get().getGameDir(), "player_models/" + this.selectedFolder);
        modelsDir.mkdirs();
        for (int i = 0; i < files.size(); ++i) {
            File model = files.get(i);
            if (!model.getName().endsWith(".cpmmodel")) continue;
            File m = new File(modelsDir, model.getName());
            Random r = new Random();
            String name = model.getName();
            name = name.substring(0, name.length() - 9);
            while (m.exists()) {
                m = new File(modelsDir, name + "_" + Integer.toHexString(r.nextInt()) + ".cpmmodel");
            }
            try (FileInputStream in = new FileInputStream(model);
                 FileOutputStream out = new FileOutputStream(m);){
                IOHelper.copy(in, out);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.loadModelList();
    }

    private class FolderPanel
    extends ListPanel {
        private TextureProvider icon;
        private Button select;
        private int linesC;
        private int y;

        public FolderPanel(IGui gui, File folder, int y) throws IOException {
            super(gui);
            Label lbl = new Label(gui, folder.getName());
            lbl.setBounds(new Box(68, 5, 100, 10));
            this.addElement(lbl);
            File descFile = new File(folder, "description.txt");
            if (descFile.exists()) {
                int i = 0;
                try (BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(descFile), StandardCharsets.UTF_8));){
                    this.addElement(new Label(gui, rd.readLine()).setBounds(new Box(68, 20 + i++ * 10, 0, 0)));
                }
                this.linesC = i;
            }
            this.y = y;
            this.select = new Button(gui, gui.i18nFormat("button.cpm.models.openFolder", new Object[0]), () -> {
                ModelsPanel.this.selectedFolder = ModelsPanel.this.getFullPath(folder.getName());
                ModelsPanel.this.loadModelList();
            });
            this.addElement(this.select);
            File iconFile = new File(folder, "icon.png");
            if (iconFile.exists()) {
                MinecraftClientAccess.get().getDefinitionLoader().execute(() -> {
                    try (FileInputStream fin = new FileInputStream(iconFile);){
                        this.icon = new TextureProvider(ImageIO.read(fin), null);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }

        @Override
        public int getHeight() {
            return Math.max(64, this.linesC * 10 + 30);
        }

        @Override
        protected void setSize(int w) {
            this.select.setBounds(new Box(w - 50, 2, 40, 20));
            this.setBounds(new Box(0, this.y, w, this.getHeight()));
        }

        @Override
        protected void onClosed() {
            if (this.icon != null) {
                this.icon.free();
            }
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon != null) {
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + 1, this.bounds.y + 1, 64, 64, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
    }

    private class ModelPanel
    extends ListPanel {
        private TextureProvider icon;
        private Button select;
        private int linesC;
        private int y;

        public ModelPanel(IGui gui, ModelFile file, boolean sel, int y) {
            super(gui);
            Label lbl = new Label(gui, file.getName());
            lbl.setBounds(new Box(68, 5, 100, 10));
            if (sel) {
                lbl.setColor(gui.getColors().button_hover);
            }
            this.addElement(lbl);
            String[] lines = file.getDesc().split("\\\\");
            for (int i = 0; i < lines.length; ++i) {
                this.addElement(new Label(gui, lines[i]).setBounds(new Box(68, 20 + i * 10, 0, 0)));
            }
            this.linesC = lines.length;
            this.y = y;
            this.select = new Button(gui, gui.i18nFormat("button.cpm.select", new Object[0]), () -> {
                ModelsPanel.this.selected = ModelsPanel.this.getFullPath(file.getFileName());
                ModelsPanel.this.selectedDef = MinecraftClientAccess.get().getDefinitionLoader().loadModel(file.getDataBlock(), MinecraftClientAccess.get().getClientPlayer());
                file.registerLocalCache(MinecraftClientAccess.get().getDefinitionLoader());
                ModelsPanel.this.set.setEnabled(true);
                if (ModelsPanel.this.upload != null) {
                    ModelsPanel.this.upload.setEnabled(true);
                }
            });
            this.addElement(this.select);
            if (file.getIcon() != null && file.getIcon().getWidth() > 0) {
                MinecraftClientAccess.get().getDefinitionLoader().execute(() -> {
                    IOHelper.ImageBlock block = file.getIcon();
                    try {
                        block.doReadImage();
                        if (block.getImage() != null) {
                            this.icon = new TextureProvider(block.getImage(), null);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
            }
        }

        @Override
        public void setSize(int w) {
            this.select.setBounds(new Box(w - 50, 2, 40, 20));
            this.setBounds(new Box(0, this.y, w, this.getHeight()));
        }

        @Override
        public int getHeight() {
            return Math.max(64, this.linesC * 10 + 30);
        }

        @Override
        public void draw(MouseEvent event, float partialTicks) {
            super.draw(event, partialTicks);
            if (this.icon != null) {
                this.icon.bind();
                this.gui.drawTexture(this.bounds.x + 1, this.bounds.y + 1, 64, 64, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }

        @Override
        protected void onClosed() {
            if (this.icon != null) {
                this.icon.free();
            }
        }
    }

    private abstract class ListPanel
    extends Panel {
        public ListPanel(IGui gui) {
            super(gui);
        }

        protected abstract void setSize(int var1);

        protected abstract int getHeight();

        protected abstract void onClosed();
    }
}

