/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor.anim;

import com.tom.cpl.math.Vec3f;
import com.tom.cpm.shared.animation.InterpolatorChannel;
import com.tom.cpm.shared.editor.FormatLimits;
import com.tom.cpm.shared.editor.actions.ActionBuilder;
import com.tom.cpm.shared.editor.anim.EditorAnim;
import com.tom.cpm.shared.editor.anim.IElem;
import com.tom.cpm.shared.editor.elements.ElementType;
import com.tom.cpm.shared.editor.elements.ModelElement;
import com.tom.cpm.shared.editor.tree.VecType;
import com.tom.cpm.shared.model.PartValues;
import com.tom.cpm.shared.model.render.VanillaModelPart;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class AnimFrame {
    private final Map<ModelElement, FrameData> components = new HashMap<ModelElement, FrameData>();
    private EditorAnim anim;
    private FrameData draggingElem;
    private boolean applyDrag;

    public AnimFrame(EditorAnim anim) {
        this.anim = anim;
    }

    public AnimFrame(AnimFrame cpy) {
        this(cpy.anim, cpy);
    }

    public AnimFrame(EditorAnim anim, AnimFrame cpy) {
        this.anim = anim;
        for (Map.Entry<ModelElement, FrameData> e : cpy.components.entrySet()) {
            this.components.put(e.getKey(), new FrameData(e.getValue()));
        }
    }

    public void importFrameData(ActionBuilder ab, ModelElement elem, FrameData from) {
        ab.addToMap(this.components, elem, new FrameData(elem, from));
    }

    public FrameData copy(ModelElement elem) {
        FrameData f = this.components.get(elem);
        if (f == null) {
            return null;
        }
        return new FrameData(f);
    }

    public void setPos(ModelElement elem, Vec3f v) {
        FrameData dt = this.components.get(elem);
        ActionBuilder ab = this.anim.editor.action("setAnim", "label.cpm.position");
        if (dt == null) {
            dt = new FrameData(elem);
            ab.addToMap(this.components, elem, dt);
        }
        ab.updateValueOp(dt, dt.pos, v, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false, (a, b) -> {
            a.pos = b;
        }, this.anim.editor.setAnimPos);
        ab.execute();
    }

    public void setRot(ModelElement elem, Vec3f v) {
        FrameData dt = this.components.get(elem);
        ActionBuilder ab = this.anim.editor.action("setAnim", "label.cpm.rotation");
        if (dt == null) {
            dt = new FrameData(elem);
            ab.addToMap(this.components, elem, dt);
        }
        ab.updateValueOp(dt, dt.rot, v, 0, 360, true, (a, b) -> {
            a.rot = b;
        }, this.anim.editor.setAnimRot);
        ab.execute();
    }

    public void setScale(ModelElement elem, Vec3f v) {
        FrameData dt = this.components.get(elem);
        ActionBuilder ab = this.anim.editor.action("setAnim", "label.cpm.render_scale");
        if (dt == null) {
            dt = new FrameData(elem);
            ab.addToMap(this.components, elem, dt);
        }
        ab.updateValueOp(dt, dt.scale, v, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false, (a, b) -> {
            a.scale = b;
        }, this.anim.editor.setAnimScale);
        ab.execute();
    }

    public void setColor(ModelElement elem, int rgb) {
        FrameData dt = this.components.get(elem);
        ActionBuilder ab = this.anim.editor.action("setAnim", "label.cpm.rotation");
        if (dt == null) {
            dt = new FrameData(elem);
            ab.addToMap(this.components, elem, dt);
        }
        int r = (rgb & 0xFF0000) >> 16;
        int g = (rgb & 0xFF00) >> 8;
        int b = rgb & 0xFF;
        ab.updateValueOp(dt, dt.color, new Vec3f(r, g, b), (a, v) -> {
            a.color = v;
        });
        ab.execute();
    }

    public void switchVis(ModelElement elem) {
        FrameData dt = this.components.get(elem);
        ActionBuilder ab = this.anim.editor.action("setAnim", "label.cpm.hidden_effect");
        if (dt == null) {
            dt = new FrameData(elem);
            ab.addToMap(this.components, elem, dt);
        }
        ab.updateValueOp(dt, dt.show, !dt.show, (a, b) -> {
            a.show = b;
        });
        ab.execute();
    }

    public IElem getData(ModelElement modelElement) {
        return this.components.get(modelElement);
    }

    public void apply() {
        this.components.values().forEach(FrameData::apply);
        if (this.applyDrag) {
            this.draggingElem.apply();
        }
    }

    public boolean getVisible(ModelElement component) {
        if (!this.components.containsKey(component)) {
            return !component.hidden && component.rc.doDisplay();
        }
        return this.components.get((Object)component).show;
    }

    public Stream<ModelElement> getAllElements() {
        return this.components.keySet().stream();
    }

    public Stream<ModelElement> getAllElementsFiltered() {
        return this.components.entrySet().stream().filter(e -> ((FrameData)e.getValue()).hasChanges()).map(Map.Entry::getKey);
    }

    public boolean hasPosChanges(ModelElement me) {
        FrameData data = this.components.get(me);
        if (data == null) {
            return false;
        }
        return data.hasPosChanges();
    }

    public boolean hasRotChanges(ModelElement me) {
        FrameData data = this.components.get(me);
        if (data == null) {
            return false;
        }
        return data.hasRotChanges();
    }

    public boolean hasColorChanges(ModelElement me) {
        FrameData data = this.components.get(me);
        if (data == null) {
            return false;
        }
        return data.hasColorChanges();
    }

    public boolean hasVisChanges(ModelElement me) {
        FrameData data = this.components.get(me);
        if (data == null) {
            return false;
        }
        return data.hasVisChanges();
    }

    public boolean hasScaleChanges(ModelElement me) {
        FrameData data = this.components.get(me);
        if (data == null) {
            return false;
        }
        return data.hasScaleChanges();
    }

    public void copy(AnimFrame from) {
        from.components.forEach((e, dt) -> this.components.put((ModelElement)e, new FrameData((FrameData)dt)));
    }

    public void clearSelectedData(ActionBuilder ab, ModelElement me) {
        ab.removeFromMap(this.components, me);
    }

    public static float[] toArray(EditorAnim anim, ModelElement elem, InterpolatorChannel channel) {
        float[] data = new float[anim.getFrames().size()];
        for (int i = 0; i < anim.getFrames().size(); ++i) {
            AnimFrame frm = anim.getFrames().get(i);
            IElem dt = frm.getData(elem);
            if (dt == null) {
                if (anim.add) {
                    data[i] = channel.defaultValue;
                    continue;
                }
                data[i] = elem.part(channel);
                continue;
            }
            data[i] = dt.part(channel);
        }
        return data;
    }

    public Map<ModelElement, FrameData> getComponents() {
        return this.components;
    }

    public EditorAnim getAnim() {
        return this.anim;
    }

    public FrameData makeData(ModelElement elem) {
        FrameData d = new FrameData(elem);
        this.components.put(elem, d);
        return d;
    }

    public void beginDrag(ModelElement elem) {
        this.draggingElem = this.components.get(elem);
        if (this.draggingElem == null) {
            this.draggingElem = new FrameData(elem);
            this.applyDrag = true;
        }
    }

    public void endDrag() {
        this.applyDrag = false;
        this.draggingElem = null;
    }

    public void dragVal(VecType type, Vec3f vec) {
        if (this.draggingElem == null) {
            return;
        }
        switch (type) {
            case POSITION: {
                this.draggingElem.setPos(vec);
                break;
            }
            case ROTATION: {
                this.draggingElem.setRot(vec);
                break;
            }
        }
    }

    public boolean isDragging() {
        return this.applyDrag;
    }

    public class FrameData
    implements IElem {
        private Vec3f pos;
        private Vec3f rot;
        private Vec3f color;
        private Vec3f scale;
        private boolean show = true;
        private ModelElement comp;

        public FrameData(ModelElement comp) {
            this.comp = comp;
            if (!AnimFrame.this.anim.add) {
                if (comp.type == ElementType.ROOT_PART) {
                    PartValues val = ((VanillaModelPart)comp.typeData).getDefaultSize(AnimFrame.this.anim.editor.skinType);
                    this.pos = val.getPos().add(comp.pos);
                    this.rot = new Vec3f(comp.rotation);
                    this.scale = new Vec3f(1.0f, 1.0f, 1.0f);
                } else {
                    this.pos = new Vec3f(comp.pos);
                    this.rot = new Vec3f(comp.rotation);
                    this.scale = new Vec3f(1.0f, 1.0f, 1.0f);
                }
            } else {
                this.pos = new Vec3f();
                this.rot = new Vec3f();
                this.scale = new Vec3f(1.0f, 1.0f, 1.0f);
            }
            int r = (comp.rgb & 0xFF0000) >> 16;
            int g = (comp.rgb & 0xFF00) >> 8;
            int b = comp.rgb & 0xFF;
            this.color = new Vec3f(r, g, b);
            this.show = !comp.hidden;
        }

        public FrameData(ModelElement comp, FrameData cpy) {
            this.comp = comp;
            this.pos = new Vec3f(cpy.pos);
            this.rot = new Vec3f(cpy.rot);
            this.color = new Vec3f(cpy.color);
            this.scale = new Vec3f(cpy.scale);
            this.show = cpy.show;
        }

        public FrameData(FrameData cpy) {
            this(cpy.comp, cpy);
        }

        @Override
        public Vec3f getPosition() {
            return this.pos;
        }

        @Override
        public Vec3f getRotation() {
            return this.rot;
        }

        @Override
        public Vec3f getColor() {
            return this.color;
        }

        @Override
        public boolean isVisible() {
            return this.show;
        }

        @Override
        public Vec3f getScale() {
            return this.scale;
        }

        private void apply() {
            if (this.hasChanges()) {
                this.comp.rc.setRotation(AnimFrame.this.anim.add, (float)Math.toRadians(this.rot.x), (float)Math.toRadians(this.rot.y), (float)Math.toRadians(this.rot.z));
                this.comp.rc.setPosition(AnimFrame.this.anim.add, this.pos.x, this.pos.y, this.pos.z);
                if (this.hasColorChanges()) {
                    this.comp.rc.setColor(this.color.x, this.color.y, this.color.z);
                }
                if (this.hasScaleChanges()) {
                    this.comp.rc.setRenderScale(AnimFrame.this.anim.add, this.scale.x, this.scale.y, this.scale.z);
                }
                if (this.hasVisChanges()) {
                    this.comp.rc.display = this.show;
                }
            }
        }

        public boolean hasChanges() {
            return this.hasPosChanges() || this.hasRotChanges() || this.hasColorChanges() || this.hasVisChanges() || this.hasScaleChanges();
        }

        public boolean hasPosChanges() {
            if (AnimFrame.this.anim.add) {
                return Math.abs(this.pos.x) > 0.01f || Math.abs(this.pos.y) > 0.01f || Math.abs(this.pos.z) > 0.01f;
            }
            return Math.abs(this.pos.x - this.comp.pos.x) > 0.01f || Math.abs(this.pos.y - this.comp.pos.y) > 0.01f || Math.abs(this.pos.z - this.comp.pos.z) > 0.01f;
        }

        public boolean hasRotChanges() {
            if (AnimFrame.this.anim.add) {
                return Math.abs(this.rot.x) > 0.01f || Math.abs(this.rot.y) > 0.01f || Math.abs(this.rot.z) > 0.01f;
            }
            return Math.abs(this.rot.x - this.comp.rotation.x) > 0.01f || Math.abs(this.rot.y - this.comp.rotation.y) > 0.01f || Math.abs(this.rot.z - this.comp.rotation.z) > 0.01f;
        }

        public boolean hasScaleChanges() {
            return Math.abs(this.scale.x - 1.0f) > 0.01f || Math.abs(this.scale.y - 1.0f) > 0.01f || Math.abs(this.scale.z - 1.0f) > 0.01f;
        }

        public boolean hasColorChanges() {
            int rgb;
            return (!this.comp.texture || this.comp.recolor) && (this.comp.rgb & 0xFFFFFF) != ((rgb = (int)this.color.x << 16 | (int)this.color.y << 8 | (int)this.color.z) & 0xFFFFFF);
        }

        public boolean hasVisChanges() {
            return this.comp.hidden == this.show;
        }

        public void setPos(Vec3f pos) {
            this.pos = pos;
        }

        public void setRot(Vec3f rot) {
            this.rot = rot;
        }

        public void setColor(Vec3f color) {
            this.color = color;
        }

        public void setShow(boolean show) {
            this.show = show;
        }

        public void setScale(Vec3f v) {
            this.scale = v;
        }

        public void mirror(ActionBuilder ab) {
            Vec3f p = new Vec3f(this.getPosition());
            p.x = -p.x;
            Vec3f r = new Vec3f(this.getRotation());
            r.y = 360.0f - r.y;
            r.z = 360.0f - r.z;
            ab.updateValueOp(this, this.getPosition(), p, -FormatLimits.getVectorLimit(), FormatLimits.getVectorLimit(), false, FrameData::setPos, AnimFrame.this.anim.editor.setAnimPos);
            ab.updateValueOp(this, this.getRotation(), r, 0, 360, true, FrameData::setRot, AnimFrame.this.anim.editor.setAnimRot);
        }
    }
}

